/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer.maskingMethods.differentialPrivacy;

import com.alibaba.datax.transport.transformer.maskingMethods.differentialPrivacy.DifferentialPrivacyMasking;
import com.alibaba.datax.transport.transformer.maskingMethods.utils.math.algorithm.Laplace;
import java.util.ArrayList;
import java.util.List;

public class EpsilonDifferentialPrivacyImpl
extends DifferentialPrivacyMasking {
    double resVal = 0.0;

    @Override
    public double execute(double epsilon) throws Exception {
        this.resVal = Laplace.pdf(1.0 / epsilon);
        return this.resVal;
    }

    public List<String> execute(List<String> originData, double epsilon) throws Exception {
        ArrayList<String> resVals = new ArrayList<String>();
        for (String data : originData) {
            double val = Double.parseDouble(data) + Laplace.pdf(1.0 / epsilon);
            resVals.add(Double.toString(val));
        }
        return resVals;
    }

    public String maskOne(String originData, double epsilon) throws Exception {
        double val = Double.parseDouble(originData) + Laplace.pdf(1.0 / epsilon);
        return String.valueOf(val);
    }

    public double maskOne(double originData, double epsilon) throws Exception {
        double val = originData + Laplace.pdf(1.0 / epsilon);
        return val;
    }

    public long maskOne(long originData, double epsilon) throws Exception {
        double val = (double)originData + Laplace.pdf(1.0 / epsilon);
        return (long)val;
    }

    @Override
    public void mask() {
    }
}

