/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.CFGraph;
import org.bdware.analysis.gas.Evaluates;
import org.bdware.analysis.gas.PPCount;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.ContractResult;
import org.bdware.sc.JSEngine;
import org.bdware.sc.bean.Contract;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.bean.ProjectConfig;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.boundry.Resources;
import org.bdware.sc.boundry.ScriptReturnException;
import org.bdware.sc.boundry.utils.UtilRegistry;
import org.bdware.sc.encrypt.HardwareInfo;
import org.bdware.sc.engine.ConfidentialContractUtil;
import org.bdware.sc.engine.JSONTool;
import org.bdware.sc.engine.SyncMechUtil;
import org.bdware.sc.engine.YJSClassLoader;
import org.bdware.sc.engine.YJSFilter;
import org.bdware.sc.event.Event;
import org.bdware.sc.event.REvent;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.ArgPacks;
import org.bdware.sc.node.ContractManifest;
import org.bdware.sc.node.ContractNode;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.node.LogType;
import org.bdware.sc.node.Permission;
import org.bdware.sc.syncMech.SyncType;
import org.bdware.sc.trace.ProgramPointCounter;
import org.bdware.sc.util.HashUtil;
import org.bdware.sc.util.JsonUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import wrp.jdk.nashorn.api.scripting.NashornException;
import wrp.jdk.nashorn.api.scripting.NashornScriptEngine;
import wrp.jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import wrp.jdk.nashorn.api.scripting.ScriptObjectMirror;
import wrp.jdk.nashorn.internal.objects.Global;
import wrp.jdk.nashorn.internal.runtime.Context;
import wrp.jdk.nashorn.internal.runtime.ScriptFunction;
import wrp.jdk.nashorn.internal.runtime.ScriptFunctionData;
import wrp.jdk.nashorn.internal.runtime.ScriptLoader;
import wrp.jdk.nashorn.internal.runtime.ScriptObject;
import wrp.jdk.nashorn.internal.runtime.ScriptRuntime;
import wrp.jdk.nashorn.internal.runtime.StructureLoader;
import wrp.jdk.nashorn.internal.runtime.TraceMethod;
import wrp.jdk.nashorn.internal.runtime.TraceType;

public class DesktopEngine
extends JSEngine {
    private static final String ScriptFileName = "contract_main.yjs";
    private static final Logger LOGGER = LogManager.getLogger(DesktopEngine.class);
    public static boolean _with_init_script = true;
    public NashornScriptEngine engine;
    public SyncMechUtil syncUtil;
    public boolean recovering;
    Resources resources;
    YJSClassLoader classLoader;
    private ContractNode cn;
    private Global global;
    private ContractProcess.Logger tracePS = null;
    private Contract contract;
    private ContractManifest manifest;

    public DesktopEngine() {
        this.startEngine();
    }

    public DesktopEngine(ContractManifest manifest, String zipPath, Contract contract) {
        File zipFile = new File(zipPath);
        String dirName = zipFile.getName().replaceAll(".zip$", "").replaceAll(".ypk$", "");
        File traceDirFile = new File(zipFile.getParent(), dirName);
        this.contract = contract;
        if (!traceDirFile.exists()) {
            // empty if block
        }
        this.startEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object applyWithGlobal(ScriptFunction script, Global global, Object ... obj) {
        Global oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != global;
        try {
            Object ret;
            if (globalChanged) {
                Context.setGlobal(global);
            }
            Object object = ret = ScriptRuntime.apply(script, global, obj);
            return object;
        }
        catch (NashornException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
        return null;
    }

    public void setRecovering(boolean b) {
        this.recovering = b;
    }

    public NashornScriptEngine getNashornEngine() {
        return this.engine;
    }

    public Global getDesktopGlobal() {
        return this.global;
    }

    public YJSClassLoader getClassLoad() {
        return this.classLoader;
    }

    public void redirectTracePS(ContractProcess.Logger ps) {
        this.tracePS = ps;
        TraceType.ps = this.tracePS;
        if (ps instanceof TraceMethod) {
            TraceType.mTracer = (TraceMethod)((Object)ps);
        }
    }

    private void startEngine() {
        try {
            this.syncUtil = new SyncMechUtil(this);
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            ccl = ccl == null ? NashornScriptEngineFactory.class.getClassLoader() : ccl;
            String[] args = new String[]{"--loader-per-compile=false", "-strict=false"};
            this.classLoader = new YJSClassLoader(ccl, new YJSFilter());
            this.engine = (NashornScriptEngine)new NashornScriptEngineFactory().getScriptEngine(args, this.classLoader);
            Context.TRACEIF = false;
            if (_with_init_script) {
                InputStream in = DesktopEngine.class.getClassLoader().getResourceAsStream("org/bdware/sc/engine/yancloud_desktop.js");
                assert (in != null);
                InputStreamReader streamReader = new InputStreamReader(in);
                this.engine.getContext().setAttribute("javax.script.filename", "org/bdware/sc/engine/yancloud_desktop.js", 100);
                this.engine.eval(streamReader);
            }
            this.global = this.engine.getNashornGlobal();
            JavaScriptEntry.currentEngine = this.engine;
            JavaScriptEntry.currentSyncUtil = this.syncUtil;
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public void initStubClasses() {
        UtilRegistry.defineUtilClass(this.classLoader);
    }

    public void setPermission(List<Permission> setPermission) {
        this.initStubClasses();
        try {
            StringBuilder yancloud_desktop = new StringBuilder();
            List permissionStub = Permission.allName();
            for (Permission permission : setPermission) {
                yancloud_desktop.append(UtilRegistry.getInitStr(permission.name(), true));
                permissionStub.remove(permission.name());
            }
            for (String str : permissionStub) {
                yancloud_desktop.append(UtilRegistry.getInitStr(str, false));
            }
            this.engine.getContext().setAttribute("javax.script.filename", yancloud_desktop.toString(), 100);
            this.engine.eval(yancloud_desktop.toString());
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public Map<String, byte[]> dumpClass() {
        ScriptLoader loader = this.engine.getNashornContext().getScriptLoader();
        Map<String, byte[]> clzCache = loader.getClzCache();
        HashMap<String, byte[]> ret = new HashMap<String, byte[]>(clzCache);
        StructureLoader sLoader = (StructureLoader)this.engine.getNashornContext().getStructLoader();
        clzCache = sLoader.getClzCache();
        ret.putAll(clzCache);
        return ret;
    }

    public void registerResource(Resources resources) {
        NashornScriptEngine cal = this.engine;
        this.resources = resources;
        try {
            cal.invokeFunction("defineProp", "Resources", resources);
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
    }

    public Object invokeFunction(String functionName, Object ... args) {
        NashornScriptEngine cal = this.engine;
        try {
            return cal.invokeFunction(functionName, args);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Resources getResources() {
        return this.resources;
    }

    public ContractResult loadContract(Contract contract, ContractNode contractNode, boolean isInsnLimit) {
        this.cn = contractNode;
        this.engine.getContext().setAttribute("javax.script.filename", ScriptFileName, 100);
        try {
            this.setPermission(this.cn.getPermission());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (FunctionNode fun : contractNode.getFunctions()) {
            try {
                String str = fun.plainText();
                this.engine.getContext().setAttribute("javax.script.filename", fun.getFileName(), 100);
                this.compileFunction(fun, str, isInsnLimit);
            }
            catch (ScriptException e) {
                return this.wrapperException(e, fun);
            }
            catch (Exception e) {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(bo));
                e.printStackTrace();
                return new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive(bo.toString()));
            }
        }
        LOGGER.debug(JsonUtil.toJson((Object)contractNode.events) + "\n\t" + JsonUtil.toJson((Object)contractNode.logs));
        for (String topic : contractNode.events.keySet()) {
            this.compileEventFunction(topic, topic, (REvent.REventSemantics)contractNode.events.get(topic));
        }
        for (String logName : contractNode.logs.keySet()) {
            String topic = HashUtil.sha3((String[])new String[]{contract.getID(), logName});
            this.compileEventFunction(logName, topic, (REvent.REventSemantics)contractNode.logs.get(logName));
        }
        for (org.bdware.sc.node.ClassNode cn : contractNode.getClzs()) {
            try {
                System.out.println(cn.plainText());
            }
            catch (Exception exception) {}
        }
        ScriptObjectMirror globalVars = (ScriptObjectMirror)this.engine.get("Global");
        ConfidentialContractUtil.generateConfidentialContract(this.cn, globalVars, this.global);
        Context.setGlobal(this.global);
        ContractResult cResult = new ContractResult(ContractResult.Status.Success, (JsonElement)new JsonPrimitive(contract.getPublicKey()));
        cResult.isInsnLimit = isInsnLimit;
        return cResult;
    }

    private void compileEventFunction(String name, String topic, REvent.REventSemantics semantics) {
        try {
            String str = REvent.REventSemantics.AT_LEAST_ONCE.equals((Object)semantics) ? String.format("function %s(arg) { YancloudUtil.pubEvent(\"%s\", arg); }", name, topic) : String.format("function %s(arg) { YancloudUtil.pubEventConstraint(\"%s\", arg, \"%s\"); }", name, topic, semantics.name());
            this.compileFunction(null, str, false);
            LOGGER.debug("compile function " + name + " success!");
            str = String.format("function %ss(arg0, arg1) { YancloudUtil.pubEventConstraint(\"%s\", arg0, arg1); }", name, topic);
            this.compileFunction(null, str, false);
            LOGGER.debug("compile function " + name + "s success!");
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileFunction(FunctionNode functionNode, ScriptObjectMirror sf, boolean instrumentBranch) {
        Global oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.global;
        try {
            if (globalChanged) {
                Context.setGlobal(this.global);
            }
            if (instrumentBranch) {
                Context.TRACEIF = true;
                Context.TRACEMETHOD = true;
            }
            sf.compileScriptFunction();
            ScriptFunction scriptFunction = (ScriptFunction)sf.getScriptObject();
            Field f = ScriptFunction.class.getDeclaredField("data");
            f.setAccessible(true);
            ScriptFunctionData scriptFunctioNData = (ScriptFunctionData)f.get(scriptFunction);
            ScriptObject scope = scriptFunction.getScope();
            Method getGeneric = ScriptFunctionData.class.getDeclaredMethod("getGenericInvoker", ScriptObject.class);
            getGeneric.setAccessible(true);
            MethodHandle methodHandle = (MethodHandle)getGeneric.invoke((Object)scriptFunctioNData, scope);
            if (methodHandle.getClass() != Class.forName("java.lang.invoke.DirectMethodHandle")) {
                Field argL0 = methodHandle.getClass().getDeclaredField("argL0");
                argL0.setAccessible(true);
                methodHandle = (MethodHandle)argL0.get(methodHandle);
            }
            Field memberNameField = methodHandle.getClass().getDeclaredField("member");
            memberNameField.setAccessible(true);
            Object memberName = memberNameField.get(methodHandle);
            Field clazz = memberName.getClass().getDeclaredField("clazz");
            clazz.setAccessible(true);
            Class clazz2 = (Class)clazz.get(memberName);
            if (functionNode != null) {
                functionNode.compiledClazz = clazz2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
            Context.TRACEIF = false;
        }
    }

    public void compileFunction(FunctionNode functionNode, String snippet, boolean instrumentBranch) throws ScriptException {
        this.compileFunction(functionNode, (ScriptObjectMirror)this.engine.eval(snippet), instrumentBranch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractResult executeContract(ContractRequest input) {
        ContractResult contractResult;
        Object msgList;
        boolean globalChanged;
        Global oldGlobal = Context.getGlobal();
        boolean bl = globalChanged = oldGlobal != this.global;
        if (globalChanged) {
            Context.setGlobal(this.global);
        }
        ContractProcess.Logger previous = this.getTracePS();
        ByteArrayOutputStream bo = null;
        if (this.syncUtil.startFlag.booleanValue() && this.syncUtil.currType == SyncType.Trace && !this.recovering) {
            this.syncUtil.traceRecordUtil.startNext();
        } else if (this.syncUtil.startFlag.booleanValue() && this.syncUtil.currType == SyncType.Trans && !this.recovering) {
            if (input.needSeq.booleanValue()) {
                this.syncUtil.transRecordUtil.startNext(input.getAction(), input.getArg(), input.seq);
            } else {
                this.syncUtil.transRecordUtil.startNext(input.getAction(), input.getArg());
            }
        }
        if (input.getAction().equals("getFunctionNodes")) {
            return this.getFunctionNodes();
        }
        JavaScriptEntry.msgList = new ArrayList<REvent>();
        FunctionNode fun = this.cn.getFunction(input.getAction());
        if (fun == null) {
            return new ContractResult(ContractResult.Status.Exception, (JsonElement)new JsonPrimitive("Action " + input.getAction() + " is not exists"));
        }
        ProgramPointCounter ppc = null;
        try {
            Object ret;
            if (fun.getCost() != null && fun.getCost().isCountGas()) {
                ArrayList<String> functions = new ArrayList<String>();
                for (FunctionNode fn : this.cn.getFunctions()) {
                    if (!fn.isExport()) continue;
                    functions.add(fn.functionName);
                }
                int functionIndex = functions.indexOf(input.getAction());
                HashMap<String, Long> ppCountMap = this.evaluatesAnalysis(input.getAction(), functions);
                Long extraGas = this.getExtraGas(fun.getCost().getExtraGas(), input);
                bo = new ByteArrayOutputStream();
                ppc = new ProgramPointCounter(bo, previous.getCp(), Long.MAX_VALUE, functionIndex, input.getGasLimit(), extraGas, input.getAction(), ppCountMap);
                this.redirectTracePS(ppc);
            }
            if (fun.isExport() || fun.isHandler() && null != input.getRequester() && input.getRequester().startsWith("event")) {
                if (fun.isView()) {
                    ret = this.executeWithoutLock(fun, input, null);
                } else {
                    DesktopEngine functionIndex = this;
                    synchronized (functionIndex) {
                        ret = this.executeWithoutLock(fun, input, null);
                    }
                }
                ContractResult contractRes = new ContractResult(ContractResult.Status.Success, JSONTool.convertMirrorToJson(ret));
                if (ppc != null) {
                    contractRes.extraGas = ppc.extraGas;
                    contractRes.executionGas = ppc.cost;
                    contractRes.totalGas = ppc.extraGas + ppc.cost;
                }
                if (bo != null) {
                    contractRes.analysis = bo.toString();
                }
                if (fun.getLogTypes().contains(LogType.Branch)) {
                    contractRes.branch = this.tracePS.getOutputStr();
                }
                msgList = JavaScriptEntry.msgList;
                JavaScriptEntry.msgList = null;
                if (msgList != null && !msgList.isEmpty()) {
                    contractRes.events = msgList;
                    contractRes.eventRelated = true;
                }
                if (fun.isHandler() && input.getRequester().length() == 40) {
                    contractRes.eventRelated = true;
                }
                if (this.syncUtil.startFlag.booleanValue() && !this.recovering) {
                    switch (this.syncUtil.currType) {
                        case Trace: {
                            break;
                        }
                        case Trans: {
                            break;
                        }
                    }
                }
                contractResult = contractRes;
                return contractResult;
            }
            ret = new ContractResult(ContractResult.Status.Exception, (JsonElement)new JsonPrimitive("Action " + input.getAction() + " is not exported!"));
            return ret;
        }
        catch (ScriptReturnException e) {
            e.printStackTrace();
            ContractResult contractRes = new ContractResult(ContractResult.Status.Exception, (JsonElement)e.message);
            return contractRes;
        }
        catch (ScriptException e) {
            Throwable cause = e.getCause();
            e.printStackTrace();
            msgList = this.wrapperException(e, fun);
            return msgList;
        }
        catch (Throwable e) {
            ByteArrayOutputStream bo1 = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bo1);
            e.printStackTrace(ps);
            e.printStackTrace();
            if (e.getCause() != null && e.getCause() instanceof ScriptException) {
                contractResult = new ContractResult(ContractResult.Status.Exception, (JsonElement)new JsonPrimitive(this.extractException(bo1.toString(), this.extract(this.cn, e.getCause()))));
                return contractResult;
            }
            contractResult = new ContractResult(ContractResult.Status.Exception, (JsonElement)new JsonPrimitive(this.extractException(bo1.toString(), this.extract(this.cn, e))));
            return contractResult;
        }
        finally {
            this.redirectTracePS(previous);
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
    }

    public Object executeWithoutLock(FunctionNode fun, ContractRequest input, Object injectedArg) throws ScriptException, NoSuchMethodException {
        ArgPacks argPacks = new ArgPacks(input, (Object)input.getArg(), null);
        if (injectedArg != null) {
            argPacks.arg = injectedArg;
        }
        for (AnnotationHook handler : fun.beforeExecutionAnnotations()) {
            argPacks = handler.handle((JSEngine)this, argPacks);
        }
        if (argPacks.ret == null) {
            argPacks.ret = this.engine.invokeFunction(input.getAction(), fun.isHandler() ? JsonUtil.fromJson((JsonElement)input.getArg(), Event.class) : JSONTool.convertJsonElementToMirror(argPacks.arg), input.getRequester(), input.getRequesterDOI());
        }
        for (AnnotationHook handler : fun.afterExecutionAnnotations()) {
            argPacks = handler.handle((JSEngine)this, argPacks);
        }
        return argPacks.ret;
    }

    private String extractException(String msg, List<String> stack) {
        int endIndex = Math.min(msg.indexOf("in"), msg.length());
        StringBuilder msb = new StringBuilder(msg.substring(0, endIndex));
        for (String str : stack) {
            msb.append("\n").append(str);
        }
        return msb.toString();
    }

    private HashMap<String, Long> evaluatesAnalysis(String getFunction, List<String> functions) {
        HashMap<String, 1> CFGmap = new HashMap<String, 1>();
        HashMap ppCountMap = new HashMap();
        Map<String, byte[]> clzs = this.dumpClass();
        HashMap<String, MethodNode> methods = new HashMap<String, MethodNode>();
        for (byte[] clz : clzs.values()) {
            ClassNode classNode = new ClassNode();
            ClassReader cr = new ClassReader(clz);
            cr.accept((ClassVisitor)classNode, 8);
            for (MethodNode mn : classNode.methods) {
                methods.put(mn.name, mn);
            }
        }
        int flag = 0;
        for (String function : functions) {
            MethodNode mn = (MethodNode)methods.get(function);
            if (mn == null) continue;
            CFGraph cfg = new CFGraph(mn){

                public BasicBlock getBasicBlock(int id) {
                    return new BasicBlock(id);
                }
            };
            CFGmap.put(function, cfg);
            PPCount countFee = new PPCount(cfg, flag);
            BasicBlock bb = cfg.getBasicBlockAt(0);
            countFee.dfs(cfg, bb);
            Evaluates feEvaluates = new Evaluates();
            feEvaluates.getGas(PPCount.branchCount);
            feEvaluates.getInsnGas(PPCount.ppMap);
            PPCount.countFunction((String)function, (HashMap)Evaluates.map);
            ppCountMap = Evaluates.map;
            ++flag;
        }
        return ppCountMap;
    }

    private Long getExtraGas(String costFunction, ContractRequest input) throws ScriptException, NoSuchMethodException {
        if (costFunction == null || costFunction.equals("")) {
            return 0L;
        }
        NashornScriptEngine cal = this.engine;
        Object ret = cal.invokeFunction(costFunction, input.getArg(), input.getRequester(), input.getRequesterDOI());
        if (ret != null && StringUtils.isNumeric((CharSequence)ret.toString())) {
            return Long.parseLong(ret.toString());
        }
        return 0L;
    }

    private ContractResult getFunctionNodes() {
        String msg = JsonUtil.toJson((Object)this.cn.getFunctions());
        return new ContractResult(ContractResult.Status.Exception, (JsonElement)new JsonPrimitive(msg));
    }

    private void dump(Class<?> clz) {
        try {
            int l;
            String name = clz.getCanonicalName().replace(".", "/") + ".class";
            System.out.println("DumpClzz:" + clz.getCanonicalName() + " -->" + name);
            name = "/Script.class";
            InputStream input = clz.getClassLoader().getResourceAsStream(name);
            FileOutputStream fout = new FileOutputStream("./output/" + clz.getCanonicalName() + ".class");
            byte[] arr = new byte[1024];
            assert (input != null);
            while ((l = input.read(arr)) > 0) {
                fout.write(arr, 0, l);
            }
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LinkedHashMap<?, ?> getClassCache(Context c) {
        try {
            Field f = c.getClass().getDeclaredField("classCache");
            f.setAccessible(true);
            Object classCache = f.get(c);
            return (LinkedHashMap)classCache;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ContractResult wrapperException(ScriptException e, FunctionNode fun) {
        int line = fun.getLine();
        int pos = fun.getPos();
        StringBuilder content = new StringBuilder();
        String message = e.getMessage();
        message = message.replaceFirst("^[^:]*:[^:]*:[^ ]* ", "");
        int actLine = e.getLineNumber();
        if (actLine != -1) {
            actLine += line - 1;
        }
        message = message.replaceAll("at line number " + e.getLineNumber(), "at line number " + actLine);
        if (fun.getFileName() != null) {
            message = message.replace("in contract_main.yjs", "in " + fun.getFileName());
        }
        content.append(message);
        content.append("(");
        if (fun.functionName != null) {
            content.append(fun.functionName);
        } else {
            content.append(ScriptFileName);
        }
        content.append(":");
        content.append(actLine);
        content.append(":").append(pos).append(")");
        return new ContractResult(ContractResult.Status.Exception, (JsonElement)new JsonPrimitive(content.toString()));
    }

    private List<String> extract(ContractNode c, Throwable cause) {
        StackTraceElement[] stack = cause.getStackTrace();
        ArrayList<String> ret = new ArrayList<String>();
        for (StackTraceElement element : stack) {
            if (element == null || element.getFileName() == null) continue;
            String methodName = element.getMethodName();
            String fileName = element.getFileName();
            if (fileName.endsWith(".java")) continue;
            if (c.isBundle()) {
                fileName = this.fixFile(c, methodName);
            }
            if (fileName.equals("--")) continue;
            ret.add(String.format("at %s(%s:%d)", methodName, fileName, this.fixLine(c, methodName) + element.getLineNumber()));
        }
        return ret;
    }

    private String fixFile(ContractNode c, String methodName) {
        return c.queryFile(methodName);
    }

    private int fixLine(ContractNode c, String methodName) {
        return c.queryLine(methodName) - 1;
    }

    public Global getGlobal() {
        return this.engine.getNashornGlobal();
    }

    public Object eval(String script, ScriptContext context) {
        return null;
    }

    public Object eval(Reader reader, ScriptContext context) {
        return null;
    }

    public Object eval(String script) {
        return null;
    }

    public Object eval(Reader reader) {
        return null;
    }

    public Object eval(String script, Bindings n) {
        return null;
    }

    public Object eval(Reader reader, Bindings n) {
        return null;
    }

    public void put(String key, Object value) {
    }

    public Object get(String key) {
        return null;
    }

    public Bindings getBindings(int scope) {
        return null;
    }

    public void setBindings(Bindings bindings, int scope) {
    }

    public Bindings createBindings() {
        return null;
    }

    public ScriptContext getContext() {
        return null;
    }

    public void setContext(ScriptContext context) {
    }

    public ScriptEngineFactory getFactory() {
        return null;
    }

    public void loadJar(ZipFile zf) {
        YJSClassLoader loader = this.getAppLoader();
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            try {
                assert (null != loader);
                if (entry.getName().endsWith(".jar")) {
                    loader.loadJar(zf.getInputStream(entry), entry.getName().replaceAll(".*/", ""));
                }
                if (entry.getName().endsWith(".so") || entry.getName().endsWith(".so.1")) {
                    System.out.println("unzip library:" + entry.getName().replaceAll(".*/", ""));
                    loader.unzipLibrary(zf.getInputStream(entry), entry.getName().replaceAll(".*/", ""));
                }
                if (HardwareInfo.type != HardwareInfo.OSType.mac || !entry.getName().endsWith(".dylib")) continue;
                System.out.println("unzip library:" + entry.getName().replaceAll(".*/", ""));
                loader.unzipLibrary(zf.getInputStream(entry), entry.getName().replaceAll(".*/", ""));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != loader) {
            loader.loadLibraries();
        }
    }

    private YJSClassLoader getAppLoader() {
        try {
            Field f = this.engine.getClass().getDeclaredField("nashornContext");
            f.setAccessible(true);
            Context c = (Context)f.get(this.engine);
            Method m = Context.class.getDeclaredMethod("getAppLoader", new Class[0]);
            m.setAccessible(true);
            return (YJSClassLoader)m.invoke((Object)c, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setManifest(ContractManifest manifest) {
        this.manifest = manifest;
    }

    public ContractManifest getManifest() {
        return this.manifest;
    }

    public ContractProcess.Logger getTracePS() {
        return this.tracePS;
    }

    public Contract getContract() {
        return this.contract;
    }

    public ProjectConfig getProjectConfig() {
        return ContractProcess.instance.getProjectConfig();
    }
}

