/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.operations.BasicOperations;
import org.bdware.doip.endpoint.server.DoipRequestHandler;
import org.bdware.doip.endpoint.server.NettyServerHandler;
import org.bdware.doip.endpoint.server.RepositoryHandler;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.engine.hook.DOOPHandler;
import org.bdware.sc.entity.DoipMessagePacker;
import org.bdware.sc.node.FunctionNode;

public class DOOPRequestHandler
implements DoipRequestHandler,
RepositoryHandler {
    public Map<String, FunctionNode> doipFunctionNodeMap = new HashMap<String, FunctionNode>();
    static Logger logger = LogManager.getLogger(NettyServerHandler.class);
    static Gson gson;
    public static DOOPRequestHandler instance;

    public DOOPRequestHandler() {
        gson = new Gson();
    }

    public static DOOPRequestHandler createHandler() {
        if (instance == null) {
            instance = new DOOPRequestHandler();
        }
        return instance;
    }

    public void addDoipOperation(FunctionNode function) {
        this.doipFunctionNodeMap.put(function.getDoipOperationInfo().operationName, function);
    }

    public DoipMessage onRequest(ChannelHandlerContext ctx, DoipMessage msg) {
        String str = msg.header.parameters.operation;
        logger.debug("[Call operation] name: " + str);
        if (str != null) {
            FunctionNode fn = this.doipFunctionNodeMap.get(str);
            if (fn == null) {
                fn = this.doipFunctionNodeMap.get(BasicOperations.Unknown.getName());
            }
            if (fn != null) {
                return this.buildRequestAndInvokeEngine(fn, msg);
            }
        }
        return null;
    }

    public DoipMessage handleHello(DoipMessage request) {
        FunctionNode fn = this.doipFunctionNodeMap.get(BasicOperations.Hello.getName());
        if (fn == null) {
            fn = this.doipFunctionNodeMap.get(BasicOperations.Unknown.getName());
        }
        if (fn != null) {
            return this.buildRequestAndInvokeEngine(fn, request);
        }
        logger.error("DoipOperation Hello is not provided");
        return null;
    }

    public DoipMessage handleListOps(DoipMessage request) {
        FunctionNode fn = this.doipFunctionNodeMap.get(BasicOperations.ListOps.getName());
        if (fn == null) {
            fn = this.doipFunctionNodeMap.get(BasicOperations.Unknown.getName());
        }
        if (fn != null) {
            return this.buildRequestAndInvokeEngine(fn, request);
        }
        logger.error("DoipOperation ListOps is not provided");
        return null;
    }

    public DoipMessage handleCreate(DoipMessage request) {
        FunctionNode fn = this.doipFunctionNodeMap.get(BasicOperations.Create.getName());
        if (fn == null) {
            fn = this.doipFunctionNodeMap.get(BasicOperations.Unknown.getName());
        }
        if (fn != null) {
            return this.buildRequestAndInvokeEngine(fn, request);
        }
        logger.error("DoipOperation Create is not provided");
        return null;
    }

    public DoipMessage handleUpdate(DoipMessage request) {
        FunctionNode fn = this.doipFunctionNodeMap.get(BasicOperations.Update.getName());
        if (fn == null) {
            fn = this.doipFunctionNodeMap.get(BasicOperations.Unknown.getName());
        }
        if (fn != null) {
            return this.buildRequestAndInvokeEngine(fn, request);
        }
        logger.error("DoipOperation Update is not provided");
        return null;
    }

    public DoipMessage handleDelete(DoipMessage request) {
        FunctionNode fn = this.doipFunctionNodeMap.get(BasicOperations.Delete.getName());
        if (fn == null) {
            fn = this.doipFunctionNodeMap.get(BasicOperations.Unknown.getName());
        }
        if (fn != null) {
            return this.buildRequestAndInvokeEngine(fn, request);
        }
        logger.error("DoipOperation Delete is not provided");
        return null;
    }

    public DoipMessage handleRetrieve(DoipMessage request) {
        FunctionNode fn = this.doipFunctionNodeMap.get(BasicOperations.Retrieve.getName());
        if (fn == null) {
            fn = this.doipFunctionNodeMap.get(BasicOperations.Unknown.getName());
        }
        if (fn != null) {
            return this.buildRequestAndInvokeEngine(fn, request);
        }
        logger.error("DoipOperation Retrieve is not provided");
        return null;
    }

    public DoipMessage buildRequestAndInvokeEngine(FunctionNode fn, DoipMessage msg) {
        ContractRequest contractRequest = this.constructContractRequest(fn, msg);
        DoipMessagePacker arg = new DoipMessagePacker("doip", msg);
        try {
            Object ret = ContractProcess.instance.engine.executeWithoutLock(fn, contractRequest, arg);
            return DOOPHandler.convertJsonResponseToDoipMessage(fn, (JsonElement)ret, msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("buildRequestAndInvokeEngine has something wrong, executeWithoutLock err or validateJsonElementRulesByArgSchemaVisitor err");
            return null;
        }
    }

    public ContractRequest constructContractRequest(FunctionNode fn, DoipMessage request) {
        ContractRequest cr = new ContractRequest();
        cr.setContractID("");
        if (request.credential == null) {
            cr.setRequester(null);
        } else {
            cr.setRequester(request.credential.getSigner());
        }
        cr.setAction(fn.functionName);
        return cr;
    }
}

