/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.audit.EndpointConfig;
import org.bdware.doip.audit.EndpointInfo;
import org.bdware.doip.audit.client.AuditIrpClient;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.DoipServerImpl;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.irp.exception.IrpClientException;
import org.bdware.irp.stateinfo.StateInfoBase;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.bean.Contract;
import org.bdware.sc.bean.RouteInfo;
import org.bdware.sc.handler.DOOPRequestHandler;
import org.bdware.sc.node.ContractNode;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.server.DoipLocalSingleton;

public class DoipClusterServer
extends DoipServerImpl {
    static EndpointConfig config;
    static AuditIrpClient repoIrpClient;
    static DoipClusterServer instance;
    private static final Logger LOGGER;

    public DoipClusterServer(EndpointConfig config) {
        super(DoipClusterServer.resolveInfo(config));
        DoipClusterServer.config = config;
    }

    public static void createDOOPServerInstance(EndpointConfig config) {
        instance = new DoipClusterServer(config);
    }

    public static DoipClusterServer getDOOPServerInstance() {
        return instance;
    }

    public static void startDoipServer(String arg) throws InterruptedException {
        final String doipAddr = arg;
        Thread doipServerThread = new Thread(){

            @Override
            public void run() {
                try {
                    DoipLocalSingleton.run(doipAddr);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        doipServerThread.start();
    }

    private static DoipServiceInfo resolveInfo(EndpointConfig config) {
        repoIrpClient = new AuditIrpClient(config);
        EndpointInfo info = repoIrpClient.getEndpointInfo();
        if (info == null) {
            String content = "{\"date\":\"2022-1-13\",\"name\":\"testrepoforaibd\",\"doId\":\"bdware.test.local/Repo\",\"address\":\"tcp://127.0.0.1:" + EndpointConfig.defaultDOIPServerPort + "\",\"status\":\"\u5df2\u5ba1\u6838\",\"protocol\":\"DOIP\",\"pubKey\":\"empty\",\"version\":\"2.1\"}";
            info = EndpointInfo.fromJson((String)content);
        }
        ArrayList<DoipListenerConfig> infos = new ArrayList<DoipListenerConfig>();
        try {
            infos.add(new DoipListenerConfig(info.getURI(), info.getVersion()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DoipServiceInfo ret = new DoipServiceInfo(info.getDoId(), info.getPubKey(), EndpointConfig.defaultRepoType, infos);
        return ret;
    }

    public void updateRepoInfo(Contract contract, ContractNode cn) throws IrpClientException {
        String repoIdentifier = "bdtest/" + DoipClusterServer.config.repoName;
        StateInfoBase repoInfo = new StateInfoBase();
        repoInfo.identifier = repoIdentifier;
        repoInfo.handleValues = new JsonObject();
        JsonObject repoHandleValues = new JsonObject();
        JsonObject createParams = contract.getCreateParam().getAsJsonObject();
        JsonElement clusterInfo = createParams.get("clusterInfo");
        JsonObject methodRouteInfoMap = new JsonObject();
        JsonObject functions = new JsonObject();
        this.maintainRouteInfo(cn, methodRouteInfoMap, functions);
        if (clusterInfo != null) {
            repoHandleValues.add("clusterInfo", clusterInfo);
        }
        if (!functions.equals(new JsonObject())) {
            repoHandleValues.add("functions", functions);
        }
        if (!methodRouteInfoMap.equals(new JsonObject())) {
            repoHandleValues.add("routeInfo", methodRouteInfoMap);
        }
        repoInfo.handleValues.addProperty("cluster", repoHandleValues.toString());
        String updateRepoInfoRes = repoIrpClient.reRegister(repoInfo);
        if (updateRepoInfoRes.equals("success")) {
            LOGGER.info("Update cluster info to router successfully");
        } else if (updateRepoInfoRes.equals("failed")) {
            LOGGER.error("Failed to update cluster info to router");
        } else {
            LOGGER.warn("Oops...The result of updating clusterInfo to the router is " + updateRepoInfoRes);
        }
    }

    public void maintainRouteInfo(ContractNode cn, JsonObject methodRouteInfoMap, JsonObject functions) {
        List allFunctions = cn.getFunctions();
        Gson gson = new Gson();
        for (Map.Entry<String, FunctionNode> doipFunctionNodes : DOOPRequestHandler.instance.doipFunctionNodeMap.entrySet()) {
            String doipOperationName = doipFunctionNodes.getKey();
            FunctionNode doipFunctionNode = doipFunctionNodes.getValue();
            RouteInfo doipFunctionRouteInfo = doipFunctionNode.getRouteInfo();
            if (doipFunctionRouteInfo == null) continue;
            methodRouteInfoMap.addProperty(doipOperationName, gson.toJson(doipFunctionRouteInfo));
            if (doipFunctionRouteInfo.funcName == null) continue;
            String routeFunctionName = doipFunctionRouteInfo.funcName;
            for (FunctionNode functionNode : allFunctions) {
                if (!functionNode.functionName.equals(routeFunctionName)) continue;
                functions.addProperty(functionNode.functionName, functionNode.plainText());
                for (String dependentFunctionName : functionNode.getDependentFunctions()) {
                    for (FunctionNode f : cn.getFunctions()) {
                        if (!f.functionName.equals(dependentFunctionName) || functions.has(dependentFunctionName)) continue;
                        functions.addProperty(dependentFunctionName, f.plainText());
                    }
                }
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger(ContractProcess.class);
    }
}

