/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.server;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.DoipServerImpl;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.doip.endpoint.server.RepositoryHandler;
import org.bdware.sc.handler.DOOPRequestHandler;

public class DoipLocalSingleton {
    static Logger LOGGER = LogManager.getLogger(DoipLocalSingleton.class);

    public static void main(String[] arg) throws InterruptedException {
        final int port = arg.length == 0 ? 21042 : Integer.parseInt(arg[0]);
        Thread doipServerThread = new Thread(){

            @Override
            public void run() {
                try {
                    DoipLocalSingleton.run(port);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        doipServerThread.start();
    }

    public static void run(int port) throws InterruptedException {
        ArrayList<DoipListenerConfig> infos = new ArrayList<DoipListenerConfig>();
        try {
            infos.add(new DoipListenerConfig("tcp://127.0.0.1:" + port, "2.1"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DoipServiceInfo info = new DoipServiceInfo("aibd.govdata.tj/do.3f9c41e6-9f8e-48a0-9220-53f438d40e43", "ownerDEF", "gateRepo", infos);
        DoipServerImpl server = new DoipServerImpl(info);
        AtomicInteger count = new AtomicInteger(0);
        DOOPRequestHandler handler = DOOPRequestHandler.createHandler();
        server.setRepositoryHandler((RepositoryHandler)handler);
        server.start();
        while (true) {
            LOGGER.info("Count:" + count.get());
            Thread.sleep(10000L);
        }
    }

    public static void run(String doipAddr) throws InterruptedException {
        ArrayList<DoipListenerConfig> infos = new ArrayList<DoipListenerConfig>();
        try {
            infos.add(new DoipListenerConfig(doipAddr, "2.1"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DoipServiceInfo info = new DoipServiceInfo("aibd.govdata.tj/do.3f9c41e6-9f8e-48a0-9220-53f438d40e43", "ownerDEF", "gateRepo", infos);
        DoipServerImpl server = new DoipServerImpl(info);
        AtomicInteger count = new AtomicInteger(0);
        DOOPRequestHandler handler = DOOPRequestHandler.createHandler();
        server.setRepositoryHandler((RepositoryHandler)handler);
        server.start();
        while (true) {
            LOGGER.info("Count:" + count.get());
            Thread.sleep(10000L);
        }
    }
}

