/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.reader;

import com.alibaba.datax.common.element.BoolColumn;
import com.alibaba.datax.common.element.BytesColumn;
import com.alibaba.datax.common.element.DateColumn;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.RecordSender;
import com.alibaba.datax.common.plugin.TaskPluginCollector;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetReadProxy {
    private static final Logger LOG = LoggerFactory.getLogger(ResultSetReadProxy.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final byte[] EMPTY_CHAR_ARRAY = new byte[0];

    public static void transportOneRecord(RecordSender recordSender, ResultSet rs, ResultSetMetaData metaData, int columnNumber, String mandatoryEncoding, TaskPluginCollector taskPluginCollector) {
        Record record;
        block19: {
            record = recordSender.createRecord();
            try {
                block15: for (int i = 1; i <= columnNumber; ++i) {
                    switch (metaData.getColumnType(i)) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: {
                            String rawData = StringUtils.isBlank((CharSequence)mandatoryEncoding) ? rs.getString(i) : new String(rs.getBytes(i) == null ? EMPTY_CHAR_ARRAY : rs.getBytes(i), mandatoryEncoding);
                            record.addColumn(new StringColumn(rawData));
                            continue block15;
                        }
                        case 2005: 
                        case 2011: {
                            record.addColumn(new StringColumn(rs.getString(i)));
                            continue block15;
                        }
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            record.addColumn(new LongColumn(rs.getString(i)));
                            continue block15;
                        }
                        case 2: 
                        case 3: {
                            record.addColumn(new DoubleColumn(rs.getString(i)));
                            continue block15;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            record.addColumn(new DoubleColumn(rs.getString(i)));
                            continue block15;
                        }
                        case 92: {
                            record.addColumn(new DateColumn(rs.getTime(i)));
                            continue block15;
                        }
                        case 91: {
                            if (metaData.getColumnTypeName(i).equalsIgnoreCase("year")) {
                                record.addColumn(new LongColumn(rs.getInt(i)));
                                continue block15;
                            }
                            record.addColumn(new DateColumn(rs.getDate(i)));
                            continue block15;
                        }
                        case 93: {
                            record.addColumn(new DateColumn(rs.getTimestamp(i)));
                            continue block15;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            record.addColumn(new BytesColumn(rs.getBytes(i)));
                            continue block15;
                        }
                        case -7: 
                        case 16: {
                            record.addColumn(new BoolColumn(rs.getBoolean(i)));
                            continue block15;
                        }
                        case 0: {
                            String stringData = null;
                            if (rs.getObject(i) != null) {
                                stringData = rs.getObject(i).toString();
                            }
                            record.addColumn(new StringColumn(stringData));
                            continue block15;
                        }
                        default: {
                            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.UNSUPPORTED_TYPE, String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u56e0\u4e3aDataX \u4e0d\u652f\u6301\u6570\u636e\u5e93\u8bfb\u53d6\u8fd9\u79cd\u5b57\u6bb5\u7c7b\u578b. \u5b57\u6bb5\u540d:[%s], \u5b57\u6bb5\u540d\u79f0:[%s], \u5b57\u6bb5Java\u7c7b\u578b:[%s]. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u6570\u636e\u5e93\u51fd\u6570\u5c06\u5176\u8f6c\u6362datax\u652f\u6301\u7684\u7c7b\u578b \u6216\u8005\u4e0d\u540c\u6b65\u8be5\u5b57\u6bb5 .", metaData.getColumnName(i), metaData.getColumnType(i), metaData.getColumnClassName(i)));
                        }
                    }
                }
            }
            catch (Exception e) {
                if (IS_DEBUG) {
                    LOG.debug("read data " + record.toString() + " occur exception:", (Throwable)e);
                }
                taskPluginCollector.collectDirtyRecord(record, e);
                if (!(e instanceof DataXException)) break block19;
                throw (DataXException)e;
            }
        }
        recordSender.sendToWriter(record);
    }
}

