/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import com.alibaba.datax.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.maskingMethods.anonymity.PrefixPreserveMasker;
import java.util.Arrays;

public class PrefixPreserveTransformer
extends Transformer {
    private Object masker;
    String key;
    int columnIndex;

    public PrefixPreserveTransformer() {
        this.setTransformerName("dx_prefix_preserve");
        System.out.println("Using prefix preserve masker");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        try {
            if (paras.length < 2) {
                throw new RuntimeException("dx_prefix_preserve transformer\u7f3a\u5c11\u53c2\u6570");
            }
            this.columnIndex = (Integer)paras[0];
            this.key = String.valueOf(paras[1]);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(this.columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            if (column.getType() == Column.Type.STRING) {
                String newValue = PrefixPreserveMasker.mask(column.asString(), (int)Integer.valueOf(this.key));
                record.setColumn(this.columnIndex, new StringColumn(newValue));
            } else if (column.getType() == Column.Type.LONG) {
                Long newValue = PrefixPreserveMasker.mask(column.asLong(), (int)Integer.valueOf(this.key));
                record.setColumn(this.columnIndex, new LongColumn(newValue));
            }
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

