/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer.maskingConfigure;

import com.alibaba.datax.transport.transformer.maskingConfigure.PemFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class RSAKey {
    public static final int KEY_SIZE = 1024;

    public static void dumpRSAKeyPair() throws FileNotFoundException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPair keyPair = RSAKey.generateRSAKeyPair();
        RSAPrivateKey priv = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey pub = (RSAPublicKey)keyPair.getPublic();
        RSAKey.writePemFile(priv, "RSA PRIVATE KEY", "id_rsa");
        RSAKey.writePemFile(pub, "RSA PUBLIC KEY", "id_rsa.pub");
    }

    private static KeyPair generateRSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        return keyPair;
    }

    private static void writePemFile(Key key, String description, String filename) throws FileNotFoundException, IOException {
        PemFile pemFile = new PemFile(key, description);
        pemFile.write(filename);
    }

    public static RSAPrivateKey getPrivateKey() throws Exception {
        try {
            File file = new File("id_rsa");
            if (!file.exists()) {
                RSAKey.dumpRSAKeyPair();
            }
            FileReader reader = new FileReader("id_rsa");
            PemReader pemReader = new PemReader((Reader)reader);
            PemObject pemObject = pemReader.readPemObject();
            byte[] binaries = pemObject.getContent();
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(binaries);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPrivateKey privateKey = (RSAPrivateKey)factory.generatePrivate(privKeySpec);
            return privateKey;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static RSAPublicKey getPublicKey() throws Exception {
        try {
            File file = new File("id_rsa.pub");
            if (!file.exists()) {
                RSAKey.dumpRSAKeyPair();
            }
            FileReader reader = new FileReader("id_rsa.pub");
            PemReader pemReader = new PemReader((Reader)reader);
            PemObject pemObject = pemReader.readPemObject();
            byte[] binaries = pemObject.getContent();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(binaries);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPublicKey publicKey = (RSAPublicKey)factory.generatePublic(pubKeySpec);
            return publicKey;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }
}

