/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.server;

import java.net.URI;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.DoipServerImpl;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.doip.endpoint.server.RepositoryHandler;
import org.bdware.doip.endpoint.server.StartServerCallback;
import org.bdware.sc.handler.DOOPRequestHandler;

public class DoipLocalSingleton {
    static Logger LOGGER = LogManager.getLogger(DoipLocalSingleton.class);
    private static DoipServerImpl server;

    public static void main(String[] arg) throws InterruptedException {
        final int port = arg.length == 0 ? 21042 : Integer.parseInt(arg[0]);
        Thread doipServerThread = new Thread(){

            @Override
            public void run() {
                try {
                    DoipLocalSingleton.run(port);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        doipServerThread.start();
    }

    public static int run(int port) throws InterruptedException {
        int i = -1;
        LOGGER.info("try to listener port:" + port);
        i = DoipLocalSingleton.run("tcp://127.0.0.1:" + port++);
        while (i < 0) {
            LOGGER.info("try again to listener port:" + port);
            i = DoipLocalSingleton.run("tcp://127.0.0.1:" + port++);
        }
        return i;
    }

    public static int run(String doipAddr) throws InterruptedException {
        ArrayList<DoipListenerConfig> infos = new ArrayList<DoipListenerConfig>();
        int port = -1;
        try {
            URI uri = new URI(doipAddr);
            port = uri.getPort();
            infos.add(new DoipListenerConfig(doipAddr, "2.1"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DoipServiceInfo info = new DoipServiceInfo("aibd.govdata.tj/do.3f9c41e6-9f8e-48a0-9220-53f438d40e43", "ownerDEF", "gateRepo", infos);
        server = new DoipServerImpl(info);
        DOOPRequestHandler handler = DOOPRequestHandler.createHandler();
        server.setRepositoryHandler((RepositoryHandler)handler);
        ResultChecker checker = new ResultChecker();
        server.start((StartServerCallback)checker);
        checker.waitForResult(1000L);
        if (checker.port > 0) {
            return port;
        }
        return -1;
    }

    static class ResultChecker
    implements StartServerCallback {
        int port = -2;

        ResultChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(int i) {
            this.port = i;
            ResultChecker resultChecker = this;
            synchronized (resultChecker) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForResult(long timeout) {
            ResultChecker resultChecker = this;
            synchronized (resultChecker) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(Exception e) {
            this.port = -1;
            ResultChecker resultChecker = this;
            synchronized (resultChecker) {
                this.notify();
            }
        }
    }
}

