/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import com.alibaba.datax.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.maskingMethods.cryptology.AESEncryptionImpl;
import com.alibaba.datax.transport.transformer.maskingMethods.cryptology.FormatPreservingEncryptionImpl;
import com.alibaba.datax.transport.transformer.maskingMethods.cryptology.RSAEncryptionImpl;
import java.util.Arrays;

public class MaskTransformer
extends Transformer {
    private Object masker;
    String maskMethodId = "";
    String key;
    int columnIndex;

    public MaskTransformer() {
        this.setTransformerName("dx_cryp");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        try {
            if (paras.length != 3) {
                throw new RuntimeException("masker paras must be 3");
            }
            if (this.maskMethodId.equals("")) {
                this.maskMethodId = String.valueOf((String)paras[1]);
                System.out.println("Using " + this.maskMethodId + " encryption");
            }
            this.columnIndex = (Integer)paras[0];
            this.key = String.valueOf((String)paras[2]);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(this.columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            if (this.maskMethodId.equals("AES")) {
                AESEncryptionImpl masker = new AESEncryptionImpl();
                String newValue = masker.execute(oriValue);
                record.setColumn(this.columnIndex, new StringColumn(newValue));
            } else if (this.maskMethodId.equals("FPE")) {
                FormatPreservingEncryptionImpl masker = new FormatPreservingEncryptionImpl();
                String newValue = masker.execute(oriValue);
                record.setColumn(this.columnIndex, new StringColumn(newValue));
            } else if (this.maskMethodId.equals("RSA")) {
                RSAEncryptionImpl masker = new RSAEncryptionImpl();
                String newValue = "";
                if (this.key.equals("private_decrypt")) {
                    newValue = masker.executeWithPrivateDecrypt(oriValue, 1);
                } else if (this.key.equals("private_encrypt")) {
                    newValue = masker.executeWithPrivateEncrypt(oriValue, 1);
                } else if (this.key.equals("public_decrypt")) {
                    newValue = masker.executeWithPublicDecrypt(oriValue, 1);
                } else if (this.key.equals("public_encrypt")) {
                    newValue = masker.executeWithPublicEncrypt(oriValue, 1);
                }
                record.setColumn(this.columnIndex, new StringColumn(newValue));
            }
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

