/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.internal.dynalink.beans.StaticClass;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.sc.util.JsonUtil;
import wrp.jdk.nashorn.internal.objects.NativeArray;
import wrp.jdk.nashorn.internal.runtime.PropertyMap;
import wrp.jdk.nashorn.internal.runtime.Undefined;
import wrp.jdk.nashorn.internal.scripts.JO;

public class JSONTool {
    public static JsonElement convertMirrorToJson(Object ret2) {
        return JSONTool.convertMirrorToJsonInternal(ret2, new HashSet<Object>());
    }

    public static Object convertJsonElementToMirror(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            return primitive.getAsNumber();
        }
        if (jsonElement.isJsonObject()) {
            JO jo = new JO(PropertyMap.newMap());
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (String key : jsonObject.keySet()) {
                jo.put(key, JSONTool.convertJsonElementToMirror(jsonObject.get(key)), false);
            }
            return jo;
        }
        if (jsonElement.isJsonArray()) {
            NativeArray narray = new NativeArray();
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                NativeArray.push((Object)narray, JSONTool.convertJsonElementToMirror(jsonArray.get(i)));
            }
            return narray;
        }
        return null;
    }

    public static Object convertJsonElementToMirror(Object input) {
        if (input instanceof JsonElement) {
            return JSONTool.convertJsonElementToMirror((JsonElement)input);
        }
        return input;
    }

    private static JsonElement convertMirrorToJsonInternal(Object obj, Set<Object> recorded) {
        if (recorded.contains(obj)) {
            return JsonNull.INSTANCE;
        }
        if (obj == null) {
            return JsonNull.INSTANCE;
        }
        if (obj.getClass() == Undefined.class) {
            return JsonNull.INSTANCE;
        }
        if (obj instanceof JsonElement) {
            return (JsonElement)obj;
        }
        if (obj.getClass().isArray()) {
            Object[] arr = (Object[])obj;
            recorded.add(obj);
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < arr.length; ++i) {
                jsonArray.add(JSONTool.convertMirrorToJsonInternal(arr[i], recorded));
            }
            return jsonArray;
        }
        if (List.class.isAssignableFrom(obj.getClass())) {
            List arr = (List)obj;
            recorded.add(arr);
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                jsonArray.add(JSONTool.convertMirrorToJsonInternal(arr.get(i), recorded));
            }
            return jsonArray;
        }
        if (List.class.isAssignableFrom(obj.getClass())) {
            List arr = (List)obj;
            recorded.add(arr);
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                jsonArray.add(JSONTool.convertMirrorToJsonInternal(arr.get(i), recorded));
            }
            return jsonArray;
        }
        if (Set.class.isAssignableFrom(obj.getClass())) {
            Set arr = (Set)obj;
            recorded.add(arr);
            JsonArray jsonArray = new JsonArray();
            for (Object k : arr) {
                jsonArray.add(JSONTool.convertMirrorToJsonInternal(k, recorded));
            }
            return jsonArray;
        }
        if (obj.getClass() == wrp.jdk.nashorn.api.scripting.ScriptObjectMirror.class) {
            recorded.add(obj);
            wrp.jdk.nashorn.api.scripting.ScriptObjectMirror som = (wrp.jdk.nashorn.api.scripting.ScriptObjectMirror)obj;
            if (som.isFunction()) {
                return JsonNull.INSTANCE;
            }
            if (som.isArray()) {
                JsonArray jarray = new JsonArray();
                for (String str : som.getOwnKeys(true)) {
                    try {
                        if (Integer.parseInt(str) < 0) continue;
                        jarray.add(JSONTool.convertMirrorToJsonInternal(som.getMember(str), recorded));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return jarray;
            }
            JsonObject jo = new JsonObject();
            for (String str : som.getOwnKeys(true)) {
                jo.add(str, JSONTool.convertMirrorToJsonInternal(som.getMember(str), recorded));
            }
            return jo;
        }
        if (obj.getClass() == ScriptObjectMirror.class) {
            recorded.add(obj);
            ScriptObjectMirror som = (ScriptObjectMirror)obj;
            if (som.isFunction()) {
                return JsonNull.INSTANCE;
            }
            if (som.isArray()) {
                JsonArray jarray = new JsonArray();
                for (String str : som.getOwnKeys(true)) {
                    try {
                        if (Integer.parseInt(str) < 0) continue;
                        jarray.add(JSONTool.convertMirrorToJsonInternal(som.getMember(str), recorded));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return jarray;
            }
            JsonObject jo = new JsonObject();
            for (String str : som.getOwnKeys(true)) {
                jo.add(str, JSONTool.convertMirrorToJsonInternal(som.getMember(str), recorded));
            }
            return jo;
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            Map arr = (Map)obj;
            recorded.add(arr);
            JsonObject jsonObject = new JsonObject();
            for (Object k : arr.keySet()) {
                jsonObject.add(k.toString(), JSONTool.convertMirrorToJsonInternal(arr.get(k), recorded));
            }
            return jsonObject;
        }
        if (obj.getClass() == StaticClass.class) {
            return JsonNull.INSTANCE;
        }
        if (obj.getClass() == DoipMessage.class) {
            return (JsonElement)JsonUtil.fromJson((String)JsonUtil.toJson((Object)obj), JsonObject.class);
        }
        if (obj instanceof Number) {
            return new JsonPrimitive((Number)obj);
        }
        if (obj instanceof String) {
            return new JsonPrimitive((String)obj);
        }
        if (obj instanceof Character) {
            return new JsonPrimitive((Character)obj);
        }
        if (obj instanceof Boolean) {
            return new JsonPrimitive((Boolean)obj);
        }
        if (obj.getClass() == Boolean.TYPE) {
            return new JsonPrimitive((boolean)((Boolean)obj));
        }
        return JsonNull.INSTANCE;
    }
}

