/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.operations.BasicOperations;
import org.bdware.sc.JSEngine;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.boundry.ScriptReturnException;
import org.bdware.sc.engine.hook.ArgSchemaVisitor;
import org.bdware.sc.entity.DoipMessagePacker;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.ArgPacks;

public class DOOPBeforeExecHandler
implements AnnotationHook {
    private final BasicOperations httpOperation;
    private JsonElement httpArgsRules;

    public DOOPBeforeExecHandler(BasicOperations operations) {
        this.httpOperation = operations;
        this.httpArgsRules = DOOPBeforeExecHandler.getRulesForHTTPRequest(operations);
    }

    public ArgPacks handle(JSEngine desktopEngine, ArgPacks argPacks) {
        Object arg = argPacks.arg;
        DoipMessagePacker doipMsgPackerArg = new DoipMessagePacker();
        if (arg instanceof DoipMessagePacker) {
            doipMsgPackerArg = (DoipMessagePacker)arg;
        } else {
            ContractRequest httpReq = argPacks.request;
            this.validateHTTPRequestArgs(httpReq);
            doipMsgPackerArg.setSource("http");
            doipMsgPackerArg.rawDoipMsg = this.convertHttpRequestToDoipMessage(httpReq);
        }
        argPacks.arg = doipMsgPackerArg;
        return argPacks;
    }

    public void validateHTTPRequestArgs(ContractRequest httpReq) {
        JsonElement originArgs = httpReq.getArg();
        JsonElement httpArgs = JsonParser.parseString(originArgs.getAsString());
        ArgSchemaVisitor visitor = new ArgSchemaVisitor(httpArgs);
        DOOPBeforeExecHandler.validateJsonElementRulesByArgSchemaVisitor(this.httpArgsRules, visitor);
    }

    public static JsonElement getRulesForHTTPRequest(BasicOperations basicOperation) {
        switch (basicOperation) {
            case Hello: 
            case Delete: 
            case ListOps: {
                return JsonParser.parseString("{\"!header\":{\"!identifier\":\"string\"}}");
            }
            case Create: 
            case Update: {
                return JsonParser.parseString("{\"!header\":{\"!identifier\":\"string\"}, \"!body\":\"string\"}");
            }
            case Search: {
                return JsonParser.parseString("{\"!header\":{\"!identifier\":\"string\", \"!attributes\":{\"!query\":\"string\", \"!pageNum\":\"int\", \"!pageSize\":\"int\", \"!type\":\"string\"}}}");
            }
            case Retrieve: {
                return JsonParser.parseString("{\"!header\":{\"!identifier\":\"string\", \"attributes\":{\"element\":\"string\", \"includeElementData\":\"boolean\"}}}");
            }
        }
        return null;
    }

    public DoipMessage convertHttpRequestToDoipMessage(ContractRequest httpReq) {
        JsonObject jsonParams = JsonParser.parseString(httpReq.getArg().getAsString()).getAsJsonObject();
        JsonObject header = jsonParams.get("header") != null ? jsonParams.get("header").getAsJsonObject() : null;
        String body = jsonParams.get("body") != null ? jsonParams.get("body").getAsString() : null;
        DoipMessage doipMessage = null;
        switch (this.httpOperation) {
            case Hello: 
            case Delete: 
            case ListOps: {
                doipMessage = new DoipMessageFactory.DoipMessageBuilder().createRequest(header.get("identifier").getAsString(), this.httpOperation.getName()).create();
                break;
            }
            case Create: 
            case Update: {
                doipMessage = new DoipMessageFactory.DoipMessageBuilder().createRequest(header.get("identifier").getAsString(), this.httpOperation.getName()).setBody(body.getBytes(StandardCharsets.UTF_8)).create();
                break;
            }
            case Search: {
                JsonElement type;
                JsonElement pageSize;
                JsonElement pageNum;
                DoipMessageFactory.DoipMessageBuilder searchBuilder = new DoipMessageFactory.DoipMessageBuilder().createRequest(header.get("identifier").getAsString(), this.httpOperation.getName());
                JsonElement query = header.get("query");
                if (query != null) {
                    searchBuilder.addAttributes("query", query.getAsString());
                }
                if ((pageNum = header.get("pageNum")) != null) {
                    searchBuilder.addAttributes("pageNum", pageNum.getAsInt());
                }
                if ((pageSize = header.get("pageSize")) != null) {
                    searchBuilder.addAttributes("pageSize", pageSize.getAsInt());
                }
                if ((type = header.get("type")) != null) {
                    searchBuilder.addAttributes("type", type.getAsString());
                }
                doipMessage = searchBuilder.create();
                break;
            }
            case Retrieve: {
                doipMessage = new DoipMessageFactory.DoipMessageBuilder().createRequest(header.get("identifier").getAsString(), this.httpOperation.getName()).create();
                JsonElement element = header.get("element");
                JsonElement includeElementData = header.get("includeElementData");
                if (element != null) {
                    doipMessage.header.parameters.addAttribute("element", element.getAsString());
                }
                if (includeElementData == null || !includeElementData.getAsBoolean()) break;
                doipMessage.header.parameters.addAttribute("includeElementData", "true");
                break;
            }
            case Extension: {
                DoipMessageFactory.DoipMessageBuilder extensionBuilder = new DoipMessageFactory.DoipMessageBuilder();
                if (header != null) {
                    if (header.get("identifier") != null) {
                        extensionBuilder = extensionBuilder.createRequest(header.get("identifier").getAsString(), this.httpOperation.getName());
                    }
                    Set<Map.Entry<String, JsonElement>> entries = header.entrySet();
                    for (Map.Entry<String, JsonElement> entry : entries) {
                        extensionBuilder.addAttributes(entry.getKey(), entry.getValue());
                    }
                }
                if (body != null) {
                    extensionBuilder.setBody(body.getBytes(StandardCharsets.UTF_8));
                }
                doipMessage = extensionBuilder.create();
                break;
            }
        }
        return doipMessage;
    }

    public static void validateJsonElementRulesByArgSchemaVisitor(JsonElement jsonElement, ArgSchemaVisitor visitor) {
        visitor.visit(jsonElement);
        if (!visitor.getStatus()) {
            JsonObject jo = new JsonObject();
            jo.addProperty("msg", visitor.getException());
            jo.addProperty("code", visitor.errorCode);
            throw new ScriptReturnException(jo);
        }
    }
}

