package org.bdware.sc.server;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.DoipServerImpl;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.doip.endpoint.server.StartServerCallback;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.handler.DOOPRequestHandler;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class DoipLocalSingleton {
    static Logger LOGGER = LogManager.getLogger(DoipLocalSingleton.class);
    private static DoipServerImpl server;

    public static void main(String[] arg) throws InterruptedException {
        final int port = (arg.length == 0 ? 21042 : Integer.parseInt(arg[0]));

        Thread doipServerThread = new Thread() {
            @Override
            public void run() {
                try {
                    DoipLocalSingleton.run(port);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        doipServerThread.start();
    }

    public static int run(int port) throws InterruptedException {
        int i = -1;
        LOGGER.info("try to listener port:" + port);
        for (i = run("tcp://127.0.0.1:" + port++); i < 0; ) {
            LOGGER.info("try again to listener port:" + port);
            i = run("tcp://127.0.0.1:" + port++);
        }
        return i;
    }

    public static int run(String doipAddr) throws InterruptedException {
        List<DoipListenerConfig> infos = new ArrayList<>();
        int port = -1;
        try {
            URI uri = new URI(doipAddr);
            port = uri.getPort();
            infos.add(new DoipListenerConfig(doipAddr, "2.1"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        DoipServiceInfo info = new DoipServiceInfo("aibd.govdata.tj/do.3f9c41e6-9f8e-48a0-9220-53f438d40e43", "ownerDEF", "gateRepo", infos);
        server = new DoipServerImpl(info);
        DOOPRequestHandler handler = ContractProcess.instance.doopRequestHandler;
        server.setRepositoryHandler(handler);
        ResultChecker checker = new ResultChecker();
        server.start(checker);
        checker.waitForResult(1000);
        if (checker.port > 0)
            return port;
        return -1;
    }

    static class ResultChecker implements StartServerCallback {
        int port = -2;

        @Override
        public void onSuccess(int i) {
            port = i;
            synchronized (this) {
                this.notify();
            }
        }

        public void waitForResult(long timeout) {
            synchronized (this) {
                try {
                    this.wait(timeout);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void onException(Exception e) {
            port = -1;
            synchronized (this) {
                this.notify();
            }
        }
    }

}
