/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import java.util.Arrays;

public class ReplaceTransformer
extends Transformer {
    public ReplaceTransformer() {
        this.setTransformerName("dx_replace");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        String replaceString;
        int length;
        int startIndex;
        int columnIndex;
        try {
            if (paras.length != 4) {
                throw new RuntimeException("dx_replace paras must be 4");
            }
            columnIndex = (Integer)paras[0];
            startIndex = Integer.valueOf((String)paras[1]);
            length = Integer.valueOf((String)paras[2]);
            replaceString = (String)paras[3];
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            if (startIndex > oriValue.length()) {
                throw new RuntimeException(String.format("dx_replace startIndex(%s) out of range(%s)", startIndex, oriValue.length()));
            }
            String newValue = startIndex + length >= oriValue.length() ? oriValue.substring(0, startIndex) + replaceString : oriValue.substring(0, startIndex) + replaceString + oriValue.substring(startIndex + length, oriValue.length());
            record.setColumn(columnIndex, new StringColumn(newValue));
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

