/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;

public class RdbmsException
extends DataXException {
    public RdbmsException(ErrorCode errorCode, String message) {
        super(errorCode, message);
    }

    public static DataXException asConnException(DataBaseType dataBaseType, Exception e, String userName, String dbName) {
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            DBUtilErrorCode dbUtilErrorCode = RdbmsException.mySqlConnectionErrorAna(e.getMessage());
            if (dbUtilErrorCode == DBUtilErrorCode.MYSQL_CONN_DB_ERROR && dbName != null) {
                return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u8be5\u6570\u636e\u5e93\u540d\u79f0\u4e3a\uff1a" + dbName + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            if (dbUtilErrorCode == DBUtilErrorCode.MYSQL_CONN_USERPWD_ERROR) {
                return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u8be5\u6570\u636e\u5e93\u7528\u6237\u540d\u4e3a\uff1a" + userName + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
            DBUtilErrorCode dbUtilErrorCode = RdbmsException.oracleConnectionErrorAna(e.getMessage());
            if (dbUtilErrorCode == DBUtilErrorCode.ORACLE_CONN_DB_ERROR && dbName != null) {
                return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u8be5\u6570\u636e\u5e93\u540d\u79f0\u4e3a\uff1a" + dbName + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            if (dbUtilErrorCode == DBUtilErrorCode.ORACLE_CONN_USERPWD_ERROR) {
                return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u8be5\u6570\u636e\u5e93\u7528\u6237\u540d\u4e3a\uff1a" + userName + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        return DataXException.asDataXException((ErrorCode)DBUtilErrorCode.CONN_DB_ERROR, " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
    }

    public static DBUtilErrorCode mySqlConnectionErrorAna(String e) {
        if (e.contains("Unknown database")) {
            return DBUtilErrorCode.MYSQL_CONN_DB_ERROR;
        }
        if (e.contains("Communications link failure")) {
            return DBUtilErrorCode.MYSQL_CONN_IPPORT_ERROR;
        }
        if (e.contains("Access denied")) {
            return DBUtilErrorCode.MYSQL_CONN_USERPWD_ERROR;
        }
        return DBUtilErrorCode.CONN_DB_ERROR;
    }

    public static DBUtilErrorCode oracleConnectionErrorAna(String e) {
        if (e.contains("ORA-12505")) {
            return DBUtilErrorCode.ORACLE_CONN_DB_ERROR;
        }
        if (e.contains("The Network Adapter could not establish the connection")) {
            return DBUtilErrorCode.ORACLE_CONN_IPPORT_ERROR;
        }
        if (e.contains("ORA-01017")) {
            return DBUtilErrorCode.ORACLE_CONN_USERPWD_ERROR;
        }
        return DBUtilErrorCode.CONN_DB_ERROR;
    }

    public static DataXException asQueryException(DataBaseType dataBaseType, Exception e, String querySql, String table, String userName) {
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            DBUtilErrorCode dbUtilErrorCode = RdbmsException.mySqlQueryErrorAna(e.getMessage());
            if (dbUtilErrorCode == DBUtilErrorCode.MYSQL_QUERY_TABLE_NAME_ERROR && table != null) {
                return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u8868\u540d\u4e3a\uff1a" + table + " \u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            if (dbUtilErrorCode == DBUtilErrorCode.MYSQL_QUERY_SELECT_PRI_ERROR && userName != null) {
                return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u7528\u6237\u540d\u4e3a\uff1a" + userName + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u6267\u884c\u7684SQL\u4e3a: " + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
            DBUtilErrorCode dbUtilErrorCode = RdbmsException.oracleQueryErrorAna(e.getMessage());
            if (dbUtilErrorCode == DBUtilErrorCode.ORACLE_QUERY_TABLE_NAME_ERROR && table != null) {
                return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u8868\u540d\u4e3a\uff1a" + table + " \u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            if (dbUtilErrorCode == DBUtilErrorCode.ORACLE_QUERY_SELECT_PRI_ERROR) {
                return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u7528\u6237\u540d\u4e3a\uff1a" + userName + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            return DataXException.asDataXException((ErrorCode)dbUtilErrorCode, "\u6267\u884c\u7684SQL\u4e3a: " + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        return DataXException.asDataXException((ErrorCode)DBUtilErrorCode.SQL_EXECUTE_FAIL, "\u6267\u884c\u7684SQL\u4e3a: " + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
    }

    public static DBUtilErrorCode mySqlQueryErrorAna(String e) {
        if (e.contains("Table") && e.contains("doesn't exist")) {
            return DBUtilErrorCode.MYSQL_QUERY_TABLE_NAME_ERROR;
        }
        if (e.contains("SELECT command denied to user")) {
            return DBUtilErrorCode.MYSQL_QUERY_SELECT_PRI_ERROR;
        }
        if (e.contains("Unknown column") && e.contains("field list")) {
            return DBUtilErrorCode.MYSQL_QUERY_COLUMN_ERROR;
        }
        if (e.contains("where clause")) {
            return DBUtilErrorCode.MYSQL_QUERY_SQL_ERROR;
        }
        return DBUtilErrorCode.READ_RECORD_FAIL;
    }

    public static DBUtilErrorCode oracleQueryErrorAna(String e) {
        if (e.contains("table or view does not exist")) {
            return DBUtilErrorCode.ORACLE_QUERY_TABLE_NAME_ERROR;
        }
        if (e.contains("invalid identifier")) {
            return DBUtilErrorCode.ORACLE_QUERY_SQL_ERROR;
        }
        if (e.contains("insufficient privileges")) {
            return DBUtilErrorCode.ORACLE_QUERY_SELECT_PRI_ERROR;
        }
        return DBUtilErrorCode.READ_RECORD_FAIL;
    }

    public static DataXException asSqlParserException(DataBaseType dataBaseType, Exception e, String querySql) {
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.MYSQL_QUERY_SQL_PARSER_ERROR, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ORACLE_QUERY_SQL_PARSER_ERROR, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.READ_RECORD_FAIL, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
    }

    public static DataXException asPreSQLParserException(DataBaseType dataBaseType, Exception e, String querySql) {
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.MYSQL_PRE_SQL_ERROR, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ORACLE_PRE_SQL_ERROR, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.READ_RECORD_FAIL, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
    }

    public static DataXException asPostSQLParserException(DataBaseType dataBaseType, Exception e, String querySql) {
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.MYSQL_POST_SQL_ERROR, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ORACLE_POST_SQL_ERROR, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.READ_RECORD_FAIL, "\u6267\u884c\u7684SQL\u4e3a:" + querySql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
    }

    public static DataXException asInsertPriException(DataBaseType dataBaseType, String userName, String jdbcUrl) {
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.MYSQL_INSERT_ERROR, "\u7528\u6237\u540d\u4e3a:" + userName + " jdbcURL\u4e3a\uff1a" + jdbcUrl);
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ORACLE_INSERT_ERROR, "\u7528\u6237\u540d\u4e3a:" + userName + " jdbcURL\u4e3a\uff1a" + jdbcUrl);
        }
        throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.NO_INSERT_PRIVILEGE, "\u7528\u6237\u540d\u4e3a:" + userName + " jdbcURL\u4e3a\uff1a" + jdbcUrl);
    }

    public static DataXException asDeletePriException(DataBaseType dataBaseType, String userName, String jdbcUrl) {
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.MYSQL_DELETE_ERROR, "\u7528\u6237\u540d\u4e3a:" + userName + " jdbcURL\u4e3a\uff1a" + jdbcUrl);
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ORACLE_DELETE_ERROR, "\u7528\u6237\u540d\u4e3a:" + userName + " jdbcURL\u4e3a\uff1a" + jdbcUrl);
        }
        throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.NO_DELETE_PRIVILEGE, "\u7528\u6237\u540d\u4e3a:" + userName + " jdbcURL\u4e3a\uff1a" + jdbcUrl);
    }

    public static DataXException asSplitPKException(DataBaseType dataBaseType, Exception e, String splitSql, String splitPkID) {
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            return DataXException.asDataXException((ErrorCode)DBUtilErrorCode.MYSQL_SPLIT_PK_ERROR, "\u914d\u7f6e\u7684SplitPK\u4e3a: " + splitPkID + ", \u6267\u884c\u7684SQL\u4e3a: " + splitSql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle)) {
            return DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ORACLE_SPLIT_PK_ERROR, "\u914d\u7f6e\u7684SplitPK\u4e3a: " + splitPkID + ", \u6267\u884c\u7684SQL\u4e3a: " + splitSql + " \u5177\u4f53\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e);
        }
        return DataXException.asDataXException((ErrorCode)DBUtilErrorCode.READ_RECORD_FAIL, splitSql + e);
    }
}

