/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.codec.doipMessage.HeaderParameter;
import org.bdware.doip.codec.doipMessage.MessageHeader;
import org.bdware.doip.codec.operations.BasicOperations;
import org.bdware.sc.JSEngine;
import org.bdware.sc.boundry.ScriptReturnException;
import org.bdware.sc.engine.JSONTool;
import org.bdware.sc.engine.hook.ArgSchemaVisitor;
import org.bdware.sc.entity.DoipMessagePacker;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.ArgPacks;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.util.JsonUtil;

public class DOOPAfterExecHandler
implements AnnotationHook {
    private JsonElement jsonResponseRules;

    public DOOPAfterExecHandler(BasicOperations operations) {
        this.jsonResponseRules = DOOPAfterExecHandler.getRulesForJsonResponse(operations);
    }

    public ArgPacks handle(JSEngine desktopEngine, ArgPacks argPacks) {
        Object originDoipMsgPacker = argPacks.arg;
        DoipMessage originDoipMsg = null;
        if (originDoipMsgPacker instanceof DoipMessagePacker) {
            String body;
            DoipMessagePacker doipMessagePacker = (DoipMessagePacker)originDoipMsgPacker;
            originDoipMsg = doipMessagePacker.rawDoipMsg;
            if (doipMessagePacker.source.equals("http")) {
                return argPacks;
            }
            JsonObject jsonObjectRes = JSONTool.convertMirrorToJson(argPacks.ret).getAsJsonObject();
            ArgSchemaVisitor visitor = new ArgSchemaVisitor(jsonObjectRes);
            DOOPAfterExecHandler.validateJsonElementRulesByArgSchemaVisitor(this.jsonResponseRules, visitor);
            JsonObject header = jsonObjectRes.get("header") != null ? jsonObjectRes.get("header").getAsJsonObject() : null;
            String string = body = jsonObjectRes.get("body") != null ? jsonObjectRes.get("body").getAsString() : null;
            if (header != null) {
                String headerRespCode;
                originDoipMsg.header = (MessageHeader)JsonUtil.fromJson((JsonElement)header, MessageHeader.class);
                String string2 = headerRespCode = header.get("response") != null ? header.get("response").getAsString() : null;
                if (headerRespCode != null) {
                    if (originDoipMsg.header.parameters == null) {
                        originDoipMsg.header.parameters = new HeaderParameter(null, null);
                    }
                    originDoipMsg.header.parameters.response = DoipResponseCode.valueOf((String)headerRespCode);
                }
            }
            if (body != null) {
                originDoipMsg.body.encodedData = body.getBytes(StandardCharsets.UTF_8);
            }
            argPacks.ret = originDoipMsg;
            return argPacks;
        }
        return argPacks;
    }

    public static JsonElement getRulesForJsonResponse(BasicOperations basicOperations) {
        switch (basicOperations) {
            case Hello: 
            case Retrieve: 
            case Create: 
            case Update: 
            case Search: 
            case ListOps: {
                return JsonParser.parseString("{\"!header\":{\"!response\":\"string\"}, \"!body\":\"string\"}");
            }
            case Delete: {
                return JsonParser.parseString("{\"!header\":{\"!response\":\"string\"}, \"body\":\"string\"}");
            }
        }
        return null;
    }

    public DoipMessage convertJsonResponseToDoipMessage(FunctionNode fn, JsonElement jsonResponse, DoipMessage msg) {
        String body;
        JsonObject jsonParams = jsonResponse.getAsJsonObject();
        ArgSchemaVisitor visitor = new ArgSchemaVisitor(jsonResponse);
        DOOPAfterExecHandler.validateJsonElementRulesByArgSchemaVisitor(this.jsonResponseRules, visitor);
        JsonObject header = jsonParams.get("header") != null ? jsonParams.get("header").getAsJsonObject() : null;
        String string = body = jsonParams.get("body") != null ? jsonParams.get("body").getAsString() : null;
        if (header != null) {
            String headerRespCode;
            String string2 = headerRespCode = header.get("response") != null ? header.get("response").getAsString() : null;
            if (headerRespCode != null) {
                for (DoipResponseCode responseCode : DoipResponseCode.values()) {
                    if (!responseCode.toString().equals(headerRespCode)) continue;
                    msg.header.parameters.response = responseCode;
                    break;
                }
            }
        }
        if (body != null) {
            msg.body.encodedData = body.getBytes(StandardCharsets.UTF_8);
        }
        return msg;
    }

    public static void validateJsonElementRulesByArgSchemaVisitor(JsonElement jsonElement, ArgSchemaVisitor visitor) {
        visitor.visit(jsonElement);
        if (!visitor.getStatus()) {
            JsonObject jo = new JsonObject();
            jo.addProperty("msg", visitor.getException());
            jo.addProperty("code", visitor.errorCode);
            throw new ScriptReturnException(jo);
        }
    }
}

