/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.analysis.dynamic;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.bdware.analysis.AnalysisResult;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.BreadthFirstSearch;
import org.bdware.analysis.taint.HeapObject;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintCFG;
import org.bdware.analysis.taint.TaintResult;
import org.bdware.analysis.taint.TaintValue;
import org.bdware.sc.bean.Contract;
import org.bdware.sc.compiler.YJSCompiler;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.node.ContractNode;
import org.bdware.sc.node.ContractZipBundle;
import org.bdware.sc.node.FunctionNode;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Value;

public class FSAnalysis
extends BreadthFirstSearch<TaintResult, TaintBB> {
    TaintCFG cfg;
    public static boolean isDebug = false;

    public FSAnalysis(TaintCFG cfg) {
        this.cfg = cfg;
        ArrayList<TaintBB> toAnalysis = new ArrayList<TaintBB>();
        TaintBB b = (TaintBB)cfg.getBasicBlockAt(0);
        b.preResult = new TaintResult();
        b.preResult.frame.setLocal(0, (Value)HeapObject.getRootObject());
        b.preResult.frame.setLocal(1, (Value)new TaintValue(1, 0L));
        b.preResult.frame.setLocal(2, (Value)new TaintValue(1, 1L));
        b.preResult.ret = new TaintValue(1);
        TaintResult.printer.setLabelOrder(cfg.getLabelOrder());
        toAnalysis.add(b);
        b.setInList(true);
        this.setToAnalysis(toAnalysis);
        if (isDebug) {
            System.out.println("===Method:" + cfg.getMethodNode().name + cfg.getMethodNode().desc);
            System.out.println("===Local:" + cfg.getMethodNode().maxLocals + " " + cfg.getMethodNode().maxStack);
        }
    }

    public TaintResult execute(TaintBB t) {
        return t.forwardAnalysis();
    }

    public Collection<TaintBB> getSuc(TaintBB t) {
        Set subBlock = this.cfg.getSucBlocks((BasicBlock)t);
        HashSet<TaintBB> ret = new HashSet<TaintBB>();
        for (BasicBlock bb : subBlock) {
            TaintBB ntbb = (TaintBB)bb;
            ntbb.preResult.mergeResult((AnalysisResult)t.sucResult);
            ret.add(ntbb);
        }
        return ret;
    }

    public static String staticVerify(Contract c) {
        try {
            String script = c.getScriptStr();
            ContractNode cn = null;
            YJSCompiler compiler = new YJSCompiler();
            if (script.startsWith("/")) {
                String zipPath = script;
                ZipFile zf = new ZipFile(zipPath);
                ContractZipBundle czb = compiler.compile(zf);
                cn = czb.mergeContractNode();
            } else {
                cn = compiler.compile(new ByteArrayInputStream(script.getBytes()), "contract_main.yjs");
            }
            DesktopEngine engine = new DesktopEngine();
            engine.loadContract(c, cn, false);
            Map<String, byte[]> clzs = engine.dumpClass();
            HashMap<String, MethodNode> methods = new HashMap<String, MethodNode>();
            for (byte[] clz : clzs.values()) {
                ClassNode classNode = new ClassNode();
                ClassReader cr = new ClassReader(clz);
                cr.accept((ClassVisitor)classNode, 8);
                for (MethodNode mn : classNode.methods) {
                    methods.put(mn.name, mn);
                }
            }
            HashMap<String, String> result = new HashMap<String, String>();
            for (FunctionNode fn : cn.getFunctions()) {
                MethodNode mn = (MethodNode)methods.get(fn.functionName);
                if (mn == null || !mn.name.equals("statAge")) continue;
                System.out.println("[ContractManager] verify:" + fn.functionName);
                TaintResult.nLocals = mn.maxLocals;
                TaintResult.nStack = mn.maxStack;
                TaintCFG cfg = new TaintCFG(mn);
                TaintResult.printer.setLabelOrder(cfg.getLabelOrder());
                FSAnalysis analysis = new FSAnalysis(cfg);
                analysis.analysis();
                TaintBB bb = cfg.getLastBlock();
                if (bb != null) {
                    result.put(fn.functionName, bb.getResult());
                }
                cfg.printSelf();
            }
            return "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

