/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.statistics.communication;

import com.alibaba.datax.common.statistics.PerfTrace;
import com.alibaba.datax.common.util.StrUtil;
import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.fastjson.JSON;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.apache.commons.lang.Validate;

public final class CommunicationTool {
    public static final String STAGE = "stage";
    public static final String BYTE_SPEED = "byteSpeed";
    public static final String RECORD_SPEED = "recordSpeed";
    public static final String PERCENTAGE = "percentage";
    public static final String READ_SUCCEED_RECORDS = "readSucceedRecords";
    public static final String READ_SUCCEED_BYTES = "readSucceedBytes";
    public static final String READ_FAILED_RECORDS = "readFailedRecords";
    public static final String READ_FAILED_BYTES = "readFailedBytes";
    public static final String WRITE_RECEIVED_RECORDS = "writeReceivedRecords";
    public static final String WRITE_RECEIVED_BYTES = "writeReceivedBytes";
    public static final String WRITE_FAILED_RECORDS = "writeFailedRecords";
    public static final String WRITE_FAILED_BYTES = "writeFailedBytes";
    public static final String TOTAL_READ_RECORDS = "totalReadRecords";
    private static final String TOTAL_READ_BYTES = "totalReadBytes";
    private static final String TOTAL_ERROR_RECORDS = "totalErrorRecords";
    private static final String TOTAL_ERROR_BYTES = "totalErrorBytes";
    private static final String WRITE_SUCCEED_RECORDS = "writeSucceedRecords";
    private static final String WRITE_SUCCEED_BYTES = "writeSucceedBytes";
    public static final String WAIT_WRITER_TIME = "waitWriterTime";
    public static final String WAIT_READER_TIME = "waitReaderTime";
    public static final String TRANSFORMER_USED_TIME = "totalTransformerUsedTime";
    public static final String TRANSFORMER_SUCCEED_RECORDS = "totalTransformerSuccessRecords";
    public static final String TRANSFORMER_FAILED_RECORDS = "totalTransformerFailedRecords";
    public static final String TRANSFORMER_FILTER_RECORDS = "totalTransformerFilterRecords";
    public static final String TRANSFORMER_NAME_PREFIX = "usedTimeByTransformer_";

    public static Communication getReportCommunication(Communication now, Communication old, int totalStage) {
        Validate.isTrue((now != null && old != null ? 1 : 0) != 0, (String)"\u4e3a\u6c47\u62a5\u51c6\u5907\u7684\u65b0\u65e7metric\u4e0d\u80fd\u4e3anull");
        long totalReadRecords = CommunicationTool.getTotalReadRecords(now);
        long totalReadBytes = CommunicationTool.getTotalReadBytes(now);
        now.setLongCounter(TOTAL_READ_RECORDS, totalReadRecords);
        now.setLongCounter(TOTAL_READ_BYTES, totalReadBytes);
        now.setLongCounter(TOTAL_ERROR_RECORDS, CommunicationTool.getTotalErrorRecords(now));
        now.setLongCounter(TOTAL_ERROR_BYTES, CommunicationTool.getTotalErrorBytes(now));
        now.setLongCounter(WRITE_SUCCEED_RECORDS, CommunicationTool.getWriteSucceedRecords(now));
        now.setLongCounter(WRITE_SUCCEED_BYTES, CommunicationTool.getWriteSucceedBytes(now));
        long timeInterval = now.getTimestamp() - old.getTimestamp();
        long sec = timeInterval <= 1000L ? 1L : timeInterval / 1000L;
        long bytesSpeed = (totalReadBytes - CommunicationTool.getTotalReadBytes(old)) / sec;
        long recordsSpeed = (totalReadRecords - CommunicationTool.getTotalReadRecords(old)) / sec;
        now.setLongCounter(BYTE_SPEED, bytesSpeed < 0L ? 0L : bytesSpeed);
        now.setLongCounter(RECORD_SPEED, recordsSpeed < 0L ? 0L : recordsSpeed);
        now.setDoubleCounter(PERCENTAGE, (double)now.getLongCounter(STAGE).longValue() / (double)totalStage);
        if (old.getThrowable() != null) {
            now.setThrowable(old.getThrowable());
        }
        return now;
    }

    public static long getTotalReadRecords(Communication communication) {
        return communication.getLongCounter(READ_SUCCEED_RECORDS) + communication.getLongCounter(READ_FAILED_RECORDS);
    }

    public static long getTotalReadBytes(Communication communication) {
        return communication.getLongCounter(READ_SUCCEED_BYTES) + communication.getLongCounter(READ_FAILED_BYTES);
    }

    public static long getTotalErrorRecords(Communication communication) {
        return communication.getLongCounter(READ_FAILED_RECORDS) + communication.getLongCounter(WRITE_FAILED_RECORDS);
    }

    public static long getTotalErrorBytes(Communication communication) {
        return communication.getLongCounter(READ_FAILED_BYTES) + communication.getLongCounter(WRITE_FAILED_BYTES);
    }

    public static long getWriteSucceedRecords(Communication communication) {
        return communication.getLongCounter(WRITE_RECEIVED_RECORDS) - communication.getLongCounter(WRITE_FAILED_RECORDS);
    }

    public static long getWriteSucceedBytes(Communication communication) {
        return communication.getLongCounter(WRITE_RECEIVED_BYTES) - communication.getLongCounter(WRITE_FAILED_BYTES);
    }

    public static class Jsonify {
        public static String getSnapshot(Communication communication) {
            Validate.notNull((Object)communication);
            HashMap<String, Object> state = new HashMap<String, Object>();
            Pair<String, Object> pair = Jsonify.getTotalBytes(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getTotalRecords(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getSpeedRecord(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getSpeedByte(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getStage(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getErrorRecords(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getErrorBytes(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getErrorMessage(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getPercentage(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getWaitReaderTime(communication);
            state.put(pair.getKey(), pair.getValue());
            pair = Jsonify.getWaitWriterTime(communication);
            state.put(pair.getKey(), pair.getValue());
            return JSON.toJSONString(state);
        }

        private static Pair<String, Long> getTotalBytes(Communication communication) {
            return new Pair<String, Long>("totalBytes", communication.getLongCounter(CommunicationTool.TOTAL_READ_BYTES));
        }

        private static Pair<String, Long> getTotalRecords(Communication communication) {
            return new Pair<String, Long>("totalRecords", communication.getLongCounter(CommunicationTool.TOTAL_READ_RECORDS));
        }

        private static Pair<String, Long> getSpeedByte(Communication communication) {
            return new Pair<String, Long>("speedBytes", communication.getLongCounter(CommunicationTool.BYTE_SPEED));
        }

        private static Pair<String, Long> getSpeedRecord(Communication communication) {
            return new Pair<String, Long>("speedRecords", communication.getLongCounter(CommunicationTool.RECORD_SPEED));
        }

        private static Pair<String, Long> getErrorRecords(Communication communication) {
            return new Pair<String, Long>("errorRecords", communication.getLongCounter(CommunicationTool.TOTAL_ERROR_RECORDS));
        }

        private static Pair<String, Long> getErrorBytes(Communication communication) {
            return new Pair<String, Long>("errorBytes", communication.getLongCounter(CommunicationTool.TOTAL_ERROR_BYTES));
        }

        private static Pair<String, Long> getStage(Communication communication) {
            return new Pair<String, Long>(CommunicationTool.STAGE, communication.getLongCounter(CommunicationTool.STAGE));
        }

        private static Pair<String, Double> getPercentage(Communication communication) {
            return new Pair<String, Double>(CommunicationTool.PERCENTAGE, communication.getDoubleCounter(CommunicationTool.PERCENTAGE));
        }

        private static Pair<String, String> getErrorMessage(Communication communication) {
            return new Pair<String, String>("errorMessage", communication.getThrowableMessage());
        }

        private static Pair<String, Long> getWaitReaderTime(Communication communication) {
            return new Pair<String, Long>(CommunicationTool.WAIT_READER_TIME, communication.getLongCounter(CommunicationTool.WAIT_READER_TIME));
        }

        private static Pair<String, Long> getWaitWriterTime(Communication communication) {
            return new Pair<String, Long>(CommunicationTool.WAIT_WRITER_TIME, communication.getLongCounter(CommunicationTool.WAIT_WRITER_TIME));
        }

        static class Pair<K, V> {
            private K key;
            private V value;

            public Pair(K key, V value) {
                this.key = key;
                this.value = value;
            }

            public K getKey() {
                return this.key;
            }

            public V getValue() {
                return this.value;
            }
        }
    }

    public static class Stringify {
        private static final DecimalFormat df = new DecimalFormat("0.00");

        public static String getSnapshot(Communication communication) {
            StringBuilder sb = new StringBuilder();
            sb.append("Total ");
            sb.append(Stringify.getTotal(communication));
            sb.append(" | ");
            sb.append("Speed ");
            sb.append(Stringify.getSpeed(communication));
            sb.append(" | ");
            sb.append("Error ");
            sb.append(Stringify.getError(communication));
            sb.append(" | ");
            sb.append(" All Task WaitWriterTime ");
            sb.append(PerfTrace.unitTime(communication.getLongCounter(CommunicationTool.WAIT_WRITER_TIME)));
            sb.append(" | ");
            sb.append(" All Task WaitReaderTime ");
            sb.append(PerfTrace.unitTime(communication.getLongCounter(CommunicationTool.WAIT_READER_TIME)));
            sb.append(" | ");
            if (communication.getLongCounter(CommunicationTool.TRANSFORMER_USED_TIME) > 0L || communication.getLongCounter(CommunicationTool.TRANSFORMER_SUCCEED_RECORDS) > 0L || communication.getLongCounter(CommunicationTool.TRANSFORMER_FAILED_RECORDS) > 0L || communication.getLongCounter(CommunicationTool.TRANSFORMER_FILTER_RECORDS) > 0L) {
                sb.append("Transfermor Success ");
                sb.append(String.format("%d records", communication.getLongCounter(CommunicationTool.TRANSFORMER_SUCCEED_RECORDS)));
                sb.append(" | ");
                sb.append("Transformer Error ");
                sb.append(String.format("%d records", communication.getLongCounter(CommunicationTool.TRANSFORMER_FAILED_RECORDS)));
                sb.append(" | ");
                sb.append("Transformer Filter ");
                sb.append(String.format("%d records", communication.getLongCounter(CommunicationTool.TRANSFORMER_FILTER_RECORDS)));
                sb.append(" | ");
                sb.append("Transformer usedTime ");
                sb.append(PerfTrace.unitTime(communication.getLongCounter(CommunicationTool.TRANSFORMER_USED_TIME)));
                sb.append(" | ");
            }
            sb.append("Percentage ");
            sb.append(Stringify.getPercentage(communication));
            return sb.toString();
        }

        private static String getTotal(Communication communication) {
            return String.format("%d records, %d bytes", communication.getLongCounter(CommunicationTool.TOTAL_READ_RECORDS), communication.getLongCounter(CommunicationTool.TOTAL_READ_BYTES));
        }

        private static String getSpeed(Communication communication) {
            return String.format("%s/s, %d records/s", StrUtil.stringify(communication.getLongCounter(CommunicationTool.BYTE_SPEED)), communication.getLongCounter(CommunicationTool.RECORD_SPEED));
        }

        private static String getError(Communication communication) {
            return String.format("%d records, %d bytes", communication.getLongCounter(CommunicationTool.TOTAL_ERROR_RECORDS), communication.getLongCounter(CommunicationTool.TOTAL_ERROR_BYTES));
        }

        private static String getPercentage(Communication communication) {
            return df.format(communication.getDoubleCounter(CommunicationTool.PERCENTAGE) * 100.0) + "%";
        }
    }
}

