/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.util.container;

import com.alibaba.datax.common.constant.PluginType;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.AbstractJobPlugin;
import com.alibaba.datax.common.plugin.AbstractPlugin;
import com.alibaba.datax.common.plugin.AbstractTaskPlugin;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.taskgroup.runner.AbstractRunner;
import com.alibaba.datax.core.taskgroup.runner.ReaderRunner;
import com.alibaba.datax.core.taskgroup.runner.WriterRunner;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import com.alibaba.datax.core.util.container.JarLoader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LoadUtil {
    private static final String pluginTypeNameFormat = "plugin.%s.%s";
    private static Configuration pluginRegisterCenter;
    private static Map<String, JarLoader> jarLoaderCenter;

    private LoadUtil() {
    }

    public static void bind(Configuration pluginConfigs) {
        pluginRegisterCenter = pluginConfigs;
    }

    private static String generatePluginKey(PluginType pluginType, String pluginName) {
        return String.format(pluginTypeNameFormat, pluginType.toString(), pluginName);
    }

    private static Configuration getPluginConf(PluginType pluginType, String pluginName) {
        Configuration pluginConf = pluginRegisterCenter.getConfiguration(LoadUtil.generatePluginKey(pluginType, pluginName));
        if (null == pluginConf) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.PLUGIN_INSTALL_ERROR, String.format("DataX\u4e0d\u80fd\u627e\u5230\u63d2\u4ef6[%s]\u7684\u914d\u7f6e.", pluginName));
        }
        return pluginConf;
    }

    public static AbstractJobPlugin loadJobPlugin(PluginType pluginType, String pluginName) {
        Class<? extends AbstractPlugin> clazz = LoadUtil.loadPluginClass(pluginType, pluginName, ContainerType.Job);
        try {
            AbstractJobPlugin jobPlugin = (AbstractJobPlugin)clazz.newInstance();
            jobPlugin.setPluginConf(LoadUtil.getPluginConf(pluginType, pluginName));
            return jobPlugin;
        }
        catch (Exception e) {
            throw DataXException.asDataXException(FrameworkErrorCode.RUNTIME_ERROR, String.format("DataX\u627e\u5230plugin[%s]\u7684Job\u914d\u7f6e.", pluginName), e);
        }
    }

    public static AbstractTaskPlugin loadTaskPlugin(PluginType pluginType, String pluginName) {
        Class<? extends AbstractPlugin> clazz = LoadUtil.loadPluginClass(pluginType, pluginName, ContainerType.Task);
        try {
            AbstractTaskPlugin taskPlugin = (AbstractTaskPlugin)clazz.newInstance();
            taskPlugin.setPluginConf(LoadUtil.getPluginConf(pluginType, pluginName));
            return taskPlugin;
        }
        catch (Exception e) {
            throw DataXException.asDataXException(FrameworkErrorCode.RUNTIME_ERROR, String.format("DataX\u4e0d\u80fd\u627eplugin[%s]\u7684Task\u914d\u7f6e.", pluginName), e);
        }
    }

    public static AbstractRunner loadPluginRunner(PluginType pluginType, String pluginName) {
        AbstractTaskPlugin taskPlugin = LoadUtil.loadTaskPlugin(pluginType, pluginName);
        switch (pluginType) {
            case READER: {
                return new ReaderRunner(taskPlugin);
            }
            case WRITER: {
                return new WriterRunner(taskPlugin);
            }
        }
        throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, String.format("\u63d2\u4ef6[%s]\u7684\u7c7b\u578b\u5fc5\u987b\u662f[reader]\u6216[writer]!", pluginName));
    }

    private static synchronized Class<? extends AbstractPlugin> loadPluginClass(PluginType pluginType, String pluginName, ContainerType pluginRunType) {
        Configuration pluginConf = LoadUtil.getPluginConf(pluginType, pluginName);
        JarLoader jarLoader = LoadUtil.getJarLoader(pluginType, pluginName);
        try {
            return jarLoader.loadClass(pluginConf.getString("class") + "$" + pluginRunType.value());
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, e);
        }
    }

    public static synchronized JarLoader getJarLoader(PluginType pluginType, String pluginName) {
        Configuration pluginConf = LoadUtil.getPluginConf(pluginType, pluginName);
        JarLoader jarLoader = jarLoaderCenter.get(LoadUtil.generatePluginKey(pluginType, pluginName));
        if (null == jarLoader) {
            String pluginPath = pluginConf.getString("path");
            if (StringUtils.isBlank((CharSequence)pluginPath)) {
                throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, String.format("%s\u63d2\u4ef6[%s]\u8def\u5f84\u975e\u6cd5!", new Object[]{pluginType, pluginName}));
            }
            jarLoader = new JarLoader(new String[]{pluginPath});
            jarLoaderCenter.put(LoadUtil.generatePluginKey(pluginType, pluginName), jarLoader);
        }
        return jarLoader;
    }

    static {
        jarLoaderCenter = new HashMap<String, JarLoader>();
    }

    private static enum ContainerType {
        Job("Job"),
        Task("Task");

        private String type;

        private ContainerType(String type) {
            this.type = type;
        }

        public String value() {
            return this.type;
        }
    }
}

