/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.writer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.RecordReceiver;
import com.alibaba.datax.common.plugin.TaskPluginCollector;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import com.alibaba.datax.plugin.rdbms.util.RdbmsException;
import com.alibaba.datax.plugin.rdbms.writer.Constant;
import com.alibaba.datax.plugin.rdbms.writer.util.OriginalConfPretreatmentUtil;
import com.alibaba.datax.plugin.rdbms.writer.util.WriterUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonRdbmsWriter {

    public static class Task {
        protected static final Logger LOG = LoggerFactory.getLogger(Task.class);
        protected DataBaseType dataBaseType;
        private static final String VALUE_HOLDER = "?";
        protected String username;
        protected String password;
        protected String jdbcUrl;
        protected String table;
        protected List<String> columns;
        protected List<String> preSqls;
        protected List<String> postSqls;
        protected int batchSize;
        protected int batchByteSize;
        protected int columnNumber = 0;
        protected TaskPluginCollector taskPluginCollector;
        protected static String BASIC_MESSAGE;
        protected static String INSERT_OR_REPLACE_TEMPLATE;
        protected String writeRecordSql;
        protected String writeMode;
        protected boolean emptyAsNull;
        protected Triple<List<String>, List<Integer>, List<String>> resultSetMetaData;

        public Task(DataBaseType dataBaseType) {
            this.dataBaseType = dataBaseType;
        }

        public void init(Configuration writerSliceConfig) {
            this.username = writerSliceConfig.getString("username");
            this.password = writerSliceConfig.getString("password");
            this.jdbcUrl = writerSliceConfig.getString("jdbcUrl");
            if (this.jdbcUrl.startsWith("||_dsc_ob10_dsc_||") && this.dataBaseType == DataBaseType.MySql) {
                String[] ss = this.jdbcUrl.split("\\|\\|_dsc_ob10_dsc_\\|\\|");
                if (ss.length != 3) {
                    throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.JDBC_OB10_ADDRESS_ERROR, "JDBC OB10\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfbaskdatax");
                }
                LOG.info("this is ob1_0 jdbc url.");
                this.username = ss[1].trim() + ":" + this.username;
                this.jdbcUrl = ss[2];
                LOG.info("this is ob1_0 jdbc url. user=" + this.username + " :url=" + this.jdbcUrl);
            }
            this.table = writerSliceConfig.getString("table");
            this.columns = writerSliceConfig.getList("column", String.class);
            this.columnNumber = this.columns.size();
            this.preSqls = writerSliceConfig.getList("preSql", String.class);
            this.postSqls = writerSliceConfig.getList("postSql", String.class);
            this.batchSize = writerSliceConfig.getInt("batchSize", 2048);
            this.batchByteSize = writerSliceConfig.getInt("batchByteSize", 0x2000000);
            this.writeMode = writerSliceConfig.getString("writeMode", "INSERT");
            this.emptyAsNull = writerSliceConfig.getBool("emptyAsNull", true);
            INSERT_OR_REPLACE_TEMPLATE = writerSliceConfig.getString(Constant.INSERT_OR_REPLACE_TEMPLATE_MARK);
            this.writeRecordSql = String.format(INSERT_OR_REPLACE_TEMPLATE, this.table);
            BASIC_MESSAGE = String.format("jdbcUrl:[%s], table:[%s]", this.jdbcUrl, this.table);
        }

        public void prepare(Configuration writerSliceConfig) {
            Connection connection = DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.username, this.password);
            DBUtil.dealWithSessionConfig(connection, writerSliceConfig, this.dataBaseType, BASIC_MESSAGE);
            int tableNumber = writerSliceConfig.getInt(Constant.TABLE_NUMBER_MARK);
            if (tableNumber != 1) {
                LOG.info("Begin to execute preSqls:[{}]. context info:{}.", (Object)StringUtils.join(this.preSqls, (String)";"), (Object)BASIC_MESSAGE);
                WriterUtil.executeSqls(connection, this.preSqls, BASIC_MESSAGE, this.dataBaseType);
            }
            DBUtil.closeDBResources(null, null, connection);
        }

        public void startWriteWithConnection(RecordReceiver recordReceiver, TaskPluginCollector taskPluginCollector, Connection connection) {
            this.taskPluginCollector = taskPluginCollector;
            this.resultSetMetaData = DBUtil.getColumnMetaData(connection, this.table, StringUtils.join(this.columns, (String)","));
            this.calcWriteRecordSql();
            ArrayList<Record> writeBuffer = new ArrayList<Record>(this.batchSize);
            int bufferBytes = 0;
            try {
                Record record;
                while ((record = recordReceiver.getFromReader()) != null) {
                    if (record.getColumnNumber() != this.columnNumber) {
                        throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.CONF_ERROR, String.format("\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u9519\u8bef. \u56e0\u4e3a\u60a8\u914d\u7f6e\u7684\u4efb\u52a1\u4e2d\uff0c\u6e90\u5934\u8bfb\u53d6\u5b57\u6bb5\u6570:%s \u4e0e \u76ee\u7684\u8868\u8981\u5199\u5165\u7684\u5b57\u6bb5\u6570:%s \u4e0d\u76f8\u7b49. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", record.getColumnNumber(), this.columnNumber));
                    }
                    writeBuffer.add(record);
                    if (writeBuffer.size() < this.batchSize && (bufferBytes += record.getMemorySize()) < this.batchByteSize) continue;
                    this.doBatchInsert(connection, writeBuffer);
                    writeBuffer.clear();
                    bufferBytes = 0;
                }
                if (!writeBuffer.isEmpty()) {
                    this.doBatchInsert(connection, writeBuffer);
                    writeBuffer.clear();
                    bufferBytes = 0;
                }
            }
            catch (Exception e) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.WRITE_DATA_ERROR, e);
            }
            finally {
                writeBuffer.clear();
                bufferBytes = 0;
                DBUtil.closeDBResources(null, null, connection);
            }
        }

        public void startWrite(RecordReceiver recordReceiver, Configuration writerSliceConfig, TaskPluginCollector taskPluginCollector) {
            Connection connection = DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.username, this.password);
            DBUtil.dealWithSessionConfig(connection, writerSliceConfig, this.dataBaseType, BASIC_MESSAGE);
            this.startWriteWithConnection(recordReceiver, taskPluginCollector, connection);
        }

        public void post(Configuration writerSliceConfig) {
            boolean hasPostSql;
            int tableNumber = writerSliceConfig.getInt(Constant.TABLE_NUMBER_MARK);
            boolean bl = hasPostSql = this.postSqls != null && this.postSqls.size() > 0;
            if (tableNumber == 1 || !hasPostSql) {
                return;
            }
            Connection connection = DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.username, this.password);
            LOG.info("Begin to execute postSqls:[{}]. context info:{}.", (Object)StringUtils.join(this.postSqls, (String)";"), (Object)BASIC_MESSAGE);
            WriterUtil.executeSqls(connection, this.postSqls, BASIC_MESSAGE, this.dataBaseType);
            DBUtil.closeDBResources(null, null, connection);
        }

        public void destroy(Configuration writerSliceConfig) {
        }

        /*
         * Loose catch block
         */
        protected void doBatchInsert(Connection connection, List<Record> buffer) throws SQLException {
            PreparedStatement preparedStatement = null;
            try {
                connection.setAutoCommit(false);
                preparedStatement = connection.prepareStatement(this.writeRecordSql);
                for (Record record : buffer) {
                    preparedStatement = this.fillPreparedStatement(preparedStatement, record);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
                connection.commit();
            }
            catch (SQLException e) {
                LOG.warn("\u56de\u6eda\u6b64\u6b21\u5199\u5165, \u91c7\u7528\u6bcf\u6b21\u5199\u5165\u4e00\u884c\u65b9\u5f0f\u63d0\u4ea4. \u56e0\u4e3a:" + e.getMessage());
                connection.rollback();
                this.doOneInsert(connection, buffer);
                DBUtil.closeDBResources(preparedStatement, null);
            }
            catch (Exception e2) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.WRITE_DATA_ERROR, e2);
                {
                    catch (Throwable throwable) {
                        DBUtil.closeDBResources(preparedStatement, null);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeDBResources(preparedStatement, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doOneInsert(Connection connection, List<Record> buffer) {
            PreparedStatement preparedStatement = null;
            try {
                connection.setAutoCommit(true);
                preparedStatement = connection.prepareStatement(this.writeRecordSql);
                for (Record record : buffer) {
                    try {
                        preparedStatement = this.fillPreparedStatement(preparedStatement, record);
                        preparedStatement.execute();
                    }
                    catch (SQLException e) {
                        LOG.debug(e.toString());
                        this.taskPluginCollector.collectDirtyRecord(record, e);
                    }
                    finally {
                        preparedStatement.clearParameters();
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.WRITE_DATA_ERROR, e);
                }
                catch (Throwable throwable) {
                    DBUtil.closeDBResources(preparedStatement, null);
                    throw throwable;
                }
            }
            DBUtil.closeDBResources(preparedStatement, null);
        }

        protected PreparedStatement fillPreparedStatement(PreparedStatement preparedStatement, Record record) throws SQLException {
            for (int i = 0; i < this.columnNumber; ++i) {
                int columnSqltype = (Integer)((List)this.resultSetMetaData.getMiddle()).get(i);
                preparedStatement = this.fillPreparedStatementColumnType(preparedStatement, i, columnSqltype, record.getColumn(i));
            }
            return preparedStatement;
        }

        protected PreparedStatement fillPreparedStatementColumnType(PreparedStatement preparedStatement, int columnIndex, int columnSqltype, Column column) throws SQLException {
            switch (columnSqltype) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    preparedStatement.setString(columnIndex + 1, column.asString());
                    break;
                }
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    String strValue = column.asString();
                    if (this.emptyAsNull && "".equals(strValue)) {
                        preparedStatement.setString(columnIndex + 1, null);
                        break;
                    }
                    preparedStatement.setString(columnIndex + 1, strValue);
                    break;
                }
                case -6: {
                    Long longValue = column.asLong();
                    if (null == longValue) {
                        preparedStatement.setString(columnIndex + 1, null);
                        break;
                    }
                    preparedStatement.setString(columnIndex + 1, longValue.toString());
                    break;
                }
                case 91: {
                    java.util.Date utilDate;
                    if (((String)((List)this.resultSetMetaData.getRight()).get(columnIndex)).equalsIgnoreCase("year")) {
                        if (column.asBigInteger() == null) {
                            preparedStatement.setString(columnIndex + 1, null);
                            break;
                        }
                        preparedStatement.setInt(columnIndex + 1, column.asBigInteger().intValue());
                        break;
                    }
                    Date sqlDate = null;
                    try {
                        utilDate = column.asDate();
                    }
                    catch (DataXException e) {
                        throw new SQLException(String.format("Date \u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff1a[%s]", column));
                    }
                    if (null != utilDate) {
                        sqlDate = new Date(utilDate.getTime());
                    }
                    preparedStatement.setDate(columnIndex + 1, sqlDate);
                    break;
                }
                case 92: {
                    java.util.Date utilDate;
                    Time sqlTime = null;
                    try {
                        utilDate = column.asDate();
                    }
                    catch (DataXException e) {
                        throw new SQLException(String.format("TIME \u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff1a[%s]", column));
                    }
                    if (null != utilDate) {
                        sqlTime = new Time(utilDate.getTime());
                    }
                    preparedStatement.setTime(columnIndex + 1, sqlTime);
                    break;
                }
                case 93: {
                    java.util.Date utilDate;
                    Timestamp sqlTimestamp = null;
                    try {
                        utilDate = column.asDate();
                    }
                    catch (DataXException e) {
                        throw new SQLException(String.format("TIMESTAMP \u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff1a[%s]", column));
                    }
                    if (null != utilDate) {
                        sqlTimestamp = new Timestamp(utilDate.getTime());
                    }
                    preparedStatement.setTimestamp(columnIndex + 1, sqlTimestamp);
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    preparedStatement.setBytes(columnIndex + 1, column.asBytes());
                    break;
                }
                case 16: {
                    preparedStatement.setString(columnIndex + 1, column.asString());
                    break;
                }
                case -7: {
                    if (this.dataBaseType == DataBaseType.MySql) {
                        preparedStatement.setBoolean(columnIndex + 1, column.asBoolean());
                        break;
                    }
                    preparedStatement.setString(columnIndex + 1, column.asString());
                    break;
                }
                default: {
                    throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.UNSUPPORTED_TYPE, String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u56e0\u4e3aDataX \u4e0d\u652f\u6301\u6570\u636e\u5e93\u5199\u5165\u8fd9\u79cd\u5b57\u6bb5\u7c7b\u578b. \u5b57\u6bb5\u540d:[%s], \u5b57\u6bb5\u7c7b\u578b:[%d], \u5b57\u6bb5Java\u7c7b\u578b:[%s]. \u8bf7\u4fee\u6539\u8868\u4e2d\u8be5\u5b57\u6bb5\u7684\u7c7b\u578b\u6216\u8005\u4e0d\u540c\u6b65\u8be5\u5b57\u6bb5.", ((List)this.resultSetMetaData.getLeft()).get(columnIndex), ((List)this.resultSetMetaData.getMiddle()).get(columnIndex), ((List)this.resultSetMetaData.getRight()).get(columnIndex)));
                }
            }
            return preparedStatement;
        }

        private void calcWriteRecordSql() {
            if (!VALUE_HOLDER.equals(this.calcValueHolder(""))) {
                ArrayList<String> valueHolders = new ArrayList<String>(this.columnNumber);
                for (int i = 0; i < this.columns.size(); ++i) {
                    String type = (String)((List)this.resultSetMetaData.getRight()).get(i);
                    valueHolders.add(this.calcValueHolder(type));
                }
                boolean forceUseUpdate = false;
                if (this.dataBaseType != null && this.dataBaseType == DataBaseType.MySql && OriginalConfPretreatmentUtil.isOB10(this.jdbcUrl)) {
                    forceUseUpdate = true;
                }
                INSERT_OR_REPLACE_TEMPLATE = WriterUtil.getWriteTemplate(this.columns, valueHolders, this.writeMode, this.dataBaseType, forceUseUpdate);
                this.writeRecordSql = String.format(INSERT_OR_REPLACE_TEMPLATE, this.table);
            }
        }

        protected String calcValueHolder(String columnType) {
            return VALUE_HOLDER;
        }
    }

    public static class Job {
        private DataBaseType dataBaseType;
        private static final Logger LOG = LoggerFactory.getLogger(Job.class);

        public Job(DataBaseType dataBaseType) {
            OriginalConfPretreatmentUtil.DATABASE_TYPE = this.dataBaseType = dataBaseType;
        }

        public void init(Configuration originalConfig) {
            OriginalConfPretreatmentUtil.doPretreatment(originalConfig, this.dataBaseType);
            LOG.debug("After job init(), originalConfig now is:[\n{}\n]", (Object)originalConfig.toJSON());
        }

        public void writerPreCheck(Configuration originalConfig, DataBaseType dataBaseType) {
            this.prePostSqlValid(originalConfig, dataBaseType);
            this.privilegeValid(originalConfig, dataBaseType);
        }

        public void prePostSqlValid(Configuration originalConfig, DataBaseType dataBaseType) {
            WriterUtil.preCheckPrePareSQL(originalConfig, dataBaseType);
            WriterUtil.preCheckPostSQL(originalConfig, dataBaseType);
        }

        public void privilegeValid(Configuration originalConfig, DataBaseType dataBaseType) {
            String username = originalConfig.getString("username");
            String password = originalConfig.getString("password");
            List<Object> connections = originalConfig.getList(Constant.CONN_MARK, Object.class);
            int len = connections.size();
            for (int i = 0; i < len; ++i) {
                boolean hasDeletePri;
                List<String> expandedTables;
                Configuration connConf = Configuration.from(connections.get(i).toString());
                String jdbcUrl = connConf.getString("jdbcUrl");
                boolean hasInsertPri = DBUtil.checkInsertPrivilege(dataBaseType, jdbcUrl, username, password, expandedTables = connConf.getList("table", String.class));
                if (!hasInsertPri) {
                    throw RdbmsException.asInsertPriException(dataBaseType, originalConfig.getString("username"), jdbcUrl);
                }
                if (!DBUtil.needCheckDeletePrivilege(originalConfig) || (hasDeletePri = DBUtil.checkDeletePrivilege(dataBaseType, jdbcUrl, username, password, expandedTables))) continue;
                throw RdbmsException.asDeletePriException(dataBaseType, originalConfig.getString("username"), jdbcUrl);
            }
        }

        public void prepare(Configuration originalConfig) {
            int tableNumber = originalConfig.getInt(Constant.TABLE_NUMBER_MARK);
            if (tableNumber == 1) {
                String username = originalConfig.getString("username");
                String password = originalConfig.getString("password");
                List<Object> conns = originalConfig.getList(Constant.CONN_MARK, Object.class);
                Configuration connConf = Configuration.from(conns.get(0).toString());
                String jdbcUrl = connConf.getString("jdbcUrl");
                originalConfig.set("jdbcUrl", jdbcUrl);
                String table = connConf.getList("table", String.class).get(0);
                originalConfig.set("table", table);
                List<String> preSqls = originalConfig.getList("preSql", String.class);
                List<String> renderedPreSqls = WriterUtil.renderPreOrPostSqls(preSqls, table);
                originalConfig.remove(Constant.CONN_MARK);
                if (null != renderedPreSqls && !renderedPreSqls.isEmpty()) {
                    originalConfig.remove("preSql");
                    Connection conn = DBUtil.getConnection(this.dataBaseType, jdbcUrl, username, password);
                    LOG.info("Begin to execute preSqls:[{}]. context info:{}.", (Object)StringUtils.join(renderedPreSqls, (String)";"), (Object)jdbcUrl);
                    WriterUtil.executeSqls(conn, renderedPreSqls, jdbcUrl, this.dataBaseType);
                    DBUtil.closeDBResources(null, null, conn);
                }
            }
            LOG.debug("After job prepare(), originalConfig now is:[\n{}\n]", (Object)originalConfig.toJSON());
        }

        public List<Configuration> split(Configuration originalConfig, int mandatoryNumber) {
            return WriterUtil.doSplit(originalConfig, mandatoryNumber);
        }

        public void post(Configuration originalConfig) {
            int tableNumber = originalConfig.getInt(Constant.TABLE_NUMBER_MARK);
            if (tableNumber == 1) {
                String username = originalConfig.getString("username");
                String password = originalConfig.getString("password");
                String jdbcUrl = originalConfig.getString("jdbcUrl");
                String table = originalConfig.getString("table");
                List<String> postSqls = originalConfig.getList("postSql", String.class);
                List<String> renderedPostSqls = WriterUtil.renderPreOrPostSqls(postSqls, table);
                if (null != renderedPostSqls && !renderedPostSqls.isEmpty()) {
                    originalConfig.remove("postSql");
                    Connection conn = DBUtil.getConnection(this.dataBaseType, jdbcUrl, username, password);
                    LOG.info("Begin to execute postSqls:[{}]. context info:{}.", (Object)StringUtils.join(renderedPostSqls, (String)";"), (Object)jdbcUrl);
                    WriterUtil.executeSqls(conn, renderedPostSqls, jdbcUrl, this.dataBaseType);
                    DBUtil.closeDBResources(null, null, conn);
                }
            }
        }

        public void destroy(Configuration originalConfig) {
        }
    }
}

