/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.bdware.doip.codec.JsonDoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.MessageCredential;
import org.bdware.doip.codec.operations.BasicOperations;
import org.bdware.sc.JSEngine;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.boundry.ScriptReturnException;
import org.bdware.sc.engine.hook.ArgSchemaVisitor;
import org.bdware.sc.entity.DoipMessagePacker;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.ArgPacks;
import org.bdware.sc.util.JsonUtil;

public class DOOPBeforeExecHandler
implements AnnotationHook {
    private final BasicOperations httpOperation;
    private JsonElement httpArgsRules;

    public DOOPBeforeExecHandler(BasicOperations operations) {
        this.httpOperation = operations;
        this.httpArgsRules = DOOPBeforeExecHandler.getRulesForHTTPRequest(operations);
    }

    public ArgPacks handle(JSEngine desktopEngine, ArgPacks argPacks) {
        Object arg = argPacks.arg;
        DoipMessagePacker doipMsgPackerArg = new DoipMessagePacker();
        if (arg instanceof DoipMessagePacker) {
            doipMsgPackerArg = (DoipMessagePacker)arg;
        } else {
            ContractRequest httpReq = argPacks.request;
            this.validateHTTPRequestArgs(httpReq);
            doipMsgPackerArg.setSource("http");
            doipMsgPackerArg.rawDoipMsg = this.convertHttpRequestToDoipMessage(httpReq);
            doipMsgPackerArg.rawDoipMsg.credential = httpReq.verifySignature() ? new MessageCredential(httpReq.getRequester(), new byte[0]) : null;
        }
        argPacks.arg = doipMsgPackerArg;
        return argPacks;
    }

    public void validateHTTPRequestArgs(ContractRequest httpReq) {
        JsonElement originArgs = httpReq.getArg();
        JsonElement httpArgs = null;
        httpArgs = originArgs.isJsonObject() ? originArgs : JsonParser.parseString(originArgs.getAsString());
        ArgSchemaVisitor visitor = new ArgSchemaVisitor(httpArgs);
        DOOPBeforeExecHandler.validateJsonElementRulesByArgSchemaVisitor(this.httpArgsRules, visitor);
    }

    public static JsonElement getRulesForHTTPRequest(BasicOperations basicOperation) {
        switch (basicOperation) {
            case Hello: 
            case Delete: 
            case ListOps: {
                return JsonParser.parseString("{\"!header\":{\"!identifier\":\"string\"}}");
            }
            case Create: 
            case Update: {
                return JsonParser.parseString("{\"!header\":{\"!identifier\":\"string\"}, \"!body\":\"string\"}");
            }
            case Search: {
                return JsonParser.parseString("{\"!header\":{\"!identifier\":\"string\", \"!attributes\":{\"!query\":\"string\", \"!pageNum\":\"int\", \"!pageSize\":\"int\", \"!type\":\"string\"}}}");
            }
            case Retrieve: {
                return JsonParser.parseString("{\"!header\":{\"!identifier\":\"string\", \"attributes\":{\"element\":\"string\", \"includeElementData\":\"boolean\"}}}");
            }
        }
        return null;
    }

    public DoipMessage convertHttpRequestToDoipMessage(ContractRequest httpReq) {
        JsonObject jsonParams = JsonParser.parseString(httpReq.getArg().getAsString()).getAsJsonObject();
        JsonDoipMessage doipMessage = (JsonDoipMessage)JsonUtil.fromJson((JsonElement)jsonParams, JsonDoipMessage.class);
        return doipMessage.toRequestDoipMessage();
    }

    public static void validateJsonElementRulesByArgSchemaVisitor(JsonElement jsonElement, ArgSchemaVisitor visitor) {
        visitor.visit(jsonElement);
        if (!visitor.getStatus()) {
            JsonObject jo = new JsonObject();
            jo.addProperty("msg", visitor.getException());
            jo.addProperty("code", visitor.errorCode);
            throw new ScriptReturnException(jo);
        }
    }
}

