/*
 * Decompiled with CFR 0.152.
 */
package maskingJobs;

import com.alibaba.datax.common.element.BoolColumn;
import com.alibaba.datax.common.element.BytesColumn;
import com.alibaba.datax.common.element.DateColumn;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.transport.record.DefaultRecord;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerExecution;
import com.alibaba.datax.core.util.TransformerUtil;
import com.alibaba.datax.core.util.container.ClassLoaderSwapper;
import com.alibaba.datax.plugin.rdbms.reader.util.SingleTableSplitUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import com.alibaba.datax.plugin.rdbms.util.RdbmsException;
import com.google.gson.JsonPrimitive;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.bdware.sc.util.JsonUtil;

public class MaskingJob {
    DataBaseType dataBaseType = DataBaseType.MySql;
    private String username;
    private String password;
    private String jdbcUrl;
    private String table;
    private Configuration maskConf;
    private Configuration readerPara;
    private List<Record> buffer;
    private List<TransformerExecution> transformerExecs;

    public void init(String confContent) {
        this.maskConf = Configuration.from(confContent);
        System.out.println("maskConf" + this.maskConf.toString());
        System.out.println("maskCOnfjob" + this.maskConf.get("job").toString());
        this.readerPara = this.maskConf.getConfiguration("job.content[0].reader.parameter");
        System.out.println(this.readerPara);
        this.username = this.readerPara.getString("username");
        this.password = this.readerPara.getString("password");
        this.jdbcUrl = this.readerPara.getString("jdbcUrl");
        this.table = this.readerPara.getString("table");
        this.buffer = new ArrayList<Record>();
        System.out.println("maskConf11" + this.maskConf.getConfiguration("job.content[0]"));
        this.transformerExecs = TransformerUtil.buildTransformerInfo(this.maskConf.getConfiguration("job.content[0]"));
    }

    public String buildQuerySql() {
        String column = "*";
        String table = this.readerPara.getString("table");
        String where = this.readerPara.getString("where", null);
        String querySql = SingleTableSplitUtil.buildQuerySql(column, table, where) + " limit 100";
        return querySql;
    }

    public JsonPrimitive getMaskedData(String confContent) {
        this.init(confContent);
        return this.startRead();
    }

    public JsonPrimitive startRead() {
        String querySql = this.buildQuerySql();
        System.out.println("startRead" + (Object)((Object)this.dataBaseType) + this.jdbcUrl + this.username + this.password);
        Connection conn = DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.username, this.password);
        System.out.println((Object)((Object)this.dataBaseType) + this.jdbcUrl + this.username + this.password);
        int columnNumber = 0;
        String res = "";
        ArrayList<String> columnName = new ArrayList<String>();
        try {
            ResultSet rs = DBUtil.query(conn, querySql);
            ResultSetMetaData metaData = rs.getMetaData();
            columnNumber = metaData.getColumnCount();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                columnName.add(metaData.getColumnName(i));
            }
            while (rs.next()) {
                this.transportOneRecord(rs, metaData, columnNumber);
            }
        }
        catch (Exception e) {
            throw RdbmsException.asQueryException(this.dataBaseType, e, querySql, this.table, this.username);
        }
        finally {
            DBUtil.closeDBResources(null, conn);
        }
        res = this.getResult(columnName);
        return new JsonPrimitive(res);
    }

    private Record transportOneRecord(ResultSet rs, ResultSetMetaData metaData, int columnNumber) {
        Record record = this.buildRecord(rs, metaData, columnNumber);
        this.sendToWriter(record);
        return record;
    }

    private void sendToWriter(Record record) {
        Validate.notNull((Object)record, (String)"record\u4e0d\u80fd\u4e3a\u7a7a.", (Object[])new Object[0]);
        record = this.doTransformer(record);
        if (record == null) {
            return;
        }
        this.buffer.add(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Record doTransformer(Record record) {
        System.out.println("Record" + record);
        if (this.transformerExecs == null || this.transformerExecs.size() == 0) {
            return record;
        }
        ClassLoaderSwapper classLoaderSwapper = ClassLoaderSwapper.newCurrentThreadClassLoaderSwapper();
        Record result = record;
        String errorMsg = null;
        boolean failed = false;
        for (TransformerExecution transformerInfoExec : this.transformerExecs) {
            System.out.println("transformerExecs" + transformerInfoExec.getTransformerName());
            if (transformerInfoExec.getClassLoader() != null) {
                classLoaderSwapper.setCurrentThreadClassLoader(transformerInfoExec.getClassLoader());
            }
            if (!transformerInfoExec.isChecked()) {
                if (transformerInfoExec.getColumnIndex() != null && transformerInfoExec.getColumnIndex() >= record.getColumnNumber()) {
                    throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, String.format("columnIndex[%s] out of bound[%s]. name=%s", transformerInfoExec.getColumnIndex(), record.getColumnNumber(), transformerInfoExec.getTransformerName()));
                }
                transformerInfoExec.setIsChecked(true);
            }
            try {
                result = transformerInfoExec.getTransformer().evaluate(result, transformerInfoExec.gettContext(), transformerInfoExec.getFinalParas());
            }
            catch (Exception e) {
                errorMsg = String.format("transformer(%s) has Exception(%s)", transformerInfoExec.getTransformerName(), e.getMessage());
                failed = true;
                break;
            }
            finally {
                if (transformerInfoExec.getClassLoader() != null) {
                    classLoaderSwapper.restoreCurrentThreadClassLoader();
                }
            }
            if (result != null) continue;
            break;
        }
        if (failed) {
            return null;
        }
        System.out.println("result" + result);
        return result;
    }

    protected Record buildRecord(ResultSet rs, ResultSetMetaData metaData, int columnNumber) {
        DefaultRecord record;
        block17: {
            byte[] EMPTY_CHAR_ARRAY = new byte[]{};
            record = new DefaultRecord();
            try {
                block14: for (int i = 1; i <= columnNumber; ++i) {
                    switch (metaData.getColumnType(i)) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: 
                        case 2011: {
                            record.addColumn(new StringColumn(rs.getString(i)));
                            continue block14;
                        }
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            record.addColumn(new LongColumn(rs.getString(i)));
                            continue block14;
                        }
                        case 2: 
                        case 3: {
                            record.addColumn(new DoubleColumn(rs.getString(i)));
                            continue block14;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            record.addColumn(new DoubleColumn(rs.getString(i)));
                            continue block14;
                        }
                        case 92: {
                            record.addColumn(new DateColumn(rs.getTime(i)));
                            continue block14;
                        }
                        case 91: {
                            if (metaData.getColumnTypeName(i).equalsIgnoreCase("year")) {
                                record.addColumn(new LongColumn(rs.getInt(i)));
                                continue block14;
                            }
                            record.addColumn(new DateColumn(rs.getDate(i)));
                            continue block14;
                        }
                        case 93: {
                            record.addColumn(new DateColumn(rs.getTimestamp(i)));
                            continue block14;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            record.addColumn(new BytesColumn(rs.getBytes(i)));
                            continue block14;
                        }
                        case -7: 
                        case 16: {
                            record.addColumn(new BoolColumn(rs.getBoolean(i)));
                            continue block14;
                        }
                        case 0: {
                            String stringData = null;
                            if (rs.getObject(i) != null) {
                                stringData = rs.getObject(i).toString();
                            }
                            record.addColumn(new StringColumn(stringData));
                            continue block14;
                        }
                        default: {
                            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.UNSUPPORTED_TYPE, String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u56e0\u4e3aDataX \u4e0d\u652f\u6301\u6570\u636e\u5e93\u8bfb\u53d6\u8fd9\u79cd\u5b57\u6bb5\u7c7b\u578b. \u5b57\u6bb5\u540d:[%s], \u5b57\u6bb5\u540d\u79f0:[%s], \u5b57\u6bb5Java\u7c7b\u578b:[%s]. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u6570\u636e\u5e93\u51fd\u6570\u5c06\u5176\u8f6c\u6362datax\u652f\u6301\u7684\u7c7b\u578b \u6216\u8005\u4e0d\u540c\u6b65\u8be5\u5b57\u6bb5 .", metaData.getColumnName(i), metaData.getColumnType(i), metaData.getColumnClassName(i)));
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!(e instanceof DataXException)) break block17;
                throw (DataXException)e;
            }
        }
        return record;
    }

    public String getResult(ArrayList<String> columnName) {
        ArrayList dataList = new ArrayList();
        int size = this.buffer.size();
        int colmnSize = columnName.size();
        for (int i = 0; i < colmnSize; ++i) {
            HashMap<String, String> rowData = new HashMap<String, String>();
            for (int j = 0; j < size; ++j) {
                rowData.put(columnName.get(i), this.buffer.get(j).getColumn(i).asString());
            }
            dataList.add(rowData);
        }
        return JsonUtil.toJson(dataList);
    }
}

