/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.redo;

import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.engine.SyncMechUtil;
import org.bdware.sc.redo.TransRecord;

public class TransRecordUtil {
    public static final int RESERVED = 20;
    public static final int DUMP_PERIOD = 50;
    private static final Logger LOGGER = LogManager.getLogger(TransRecordUtil.class);
    public Map<Integer, TransRecord> cacheTransRecords = new TreeMap<Integer, TransRecord>();
    public TransRecord currentTransRecord;
    SyncMechUtil syncUtil;
    DesktopEngine engine;
    String fileName;

    public TransRecordUtil(DesktopEngine en, SyncMechUtil sync) {
        this.engine = en;
        this.syncUtil = sync;
    }

    public void setFileName(String path) {
        this.fileName = path;
    }

    public void startNext(String fun, JsonElement arg, int sequence) {
        this.currentTransRecord = new TransRecord(fun, arg, sequence);
    }

    public void startNext(String fun, JsonElement arg) {
        this.currentTransRecord = new TransRecord(fun, arg);
    }

    public synchronized void eachFinish() {
        this.cacheTransRecords.put(this.currentTransRecord.seq, this.currentTransRecord);
        if (this.cacheTransRecords.size() == 20) {
            int temp = 0;
            Iterator<Integer> iterator = this.cacheTransRecords.keySet().iterator();
            if (iterator.hasNext()) {
                Integer i = iterator.next();
                temp = i;
            }
            this.cacheTransRecords.remove(temp);
        }
        this.appendTransFile(this.currentTransRecord);
    }

    public void appendTransFile(TransRecord record) {
        this.syncUtil.filedTrans.getAndIncrement();
        File file = new File(this.syncUtil.transDir + "/" + this.fileName);
        File parent = file.getParentFile();
        if (parent.isDirectory() && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            FileWriter fw = new FileWriter(file, true);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(record.toString());
            pw.flush();
            fw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.syncUtil.filedTrans.get() == 50) {
            File temp;
            String[] children;
            LOGGER.info("\u81ea\u52a8\u89e6\u53d1\u68c0\u67e5\u70b9  DUMP_PERIOD=50");
            file = new File(this.syncUtil.memoryDir);
            if (file.isDirectory()) {
                children = file.list();
                for (int i = 0; i < children.length; ++i) {
                    temp = new File(file, children[i]);
                    temp.delete();
                }
            }
            if ((file = new File(this.syncUtil.traceDir)).isDirectory()) {
                children = file.list();
                for (int i = 0; i < children.length; ++i) {
                    temp = new File(file, children[i]);
                    temp.delete();
                }
            }
            if ((file = new File(this.syncUtil.transDir)).isDirectory()) {
                children = file.list();
                for (int i = 0; i < children.length; ++i) {
                    temp = new File(file, children[i]);
                    temp.delete();
                }
            }
            file = new File(this.syncUtil.syncDir + "/" + this.syncUtil.syncFileName);
            String firstLine = "";
            try {
                FileReader fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                String line = "";
                line = br.readLine();
                if (line != null) {
                    firstLine = line;
                }
                br.close();
                fr.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            file.delete();
            file = new File(this.syncUtil.syncDir + "/" + this.syncUtil.syncFileName);
            try {
                FileWriter fw = new FileWriter(file, true);
                PrintWriter pw = new PrintWriter(fw);
                pw.println(firstLine);
                pw.flush();
                fw.flush();
                pw.close();
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.syncUtil.setStartFlag(true);
        }
    }

    public void recordExecutes(String k, String v) {
        if (this.currentTransRecord != null) {
            this.currentTransRecord.executes.put(k, v);
        } else {
            LOGGER.info("[TransRecordUtil] recordExecutes error!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedTransRecords(int start) {
        StringBuilder str = new StringBuilder();
        if (!this.cacheTransRecords.containsKey(start)) {
            return "";
        }
        Map<Integer, TransRecord> map = this.cacheTransRecords;
        synchronized (map) {
            int temp = -1;
            int j = start - 1;
            for (Integer i : this.cacheTransRecords.keySet()) {
                if (i < start) continue;
                if (i == j + 1) {
                    str.append(this.cacheTransRecords.get(i).toString() + "\n");
                    temp = Math.max(temp, i);
                    j = i;
                    continue;
                }
                LOGGER.info("i=" + i + "  j=" + j + "   \u4e0d\u8fde\u7eed");
                return "";
            }
            if (temp != -1) {
                str.append("==>>" + temp);
            }
        }
        return str.toString();
    }
}

