/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.server;

import com.google.gson.JsonElement;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.audit.EndpointConfig;
import org.bdware.doip.audit.EndpointInfo;
import org.bdware.doip.audit.client.AuditIrpClient;
import org.bdware.doip.audit.config.TempConfigStorage;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.DoipRequestHandler;
import org.bdware.doip.endpoint.server.DoipServerImpl;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.doip.endpoint.server.StartServerCallback;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.handler.DOOPRequestHandler;

public class DoipLocalSingleton {
    static Logger LOGGER = LogManager.getLogger(DoipLocalSingleton.class);
    private static DoipServerImpl server;

    public static void main(String[] arg) throws InterruptedException {
        final int port = arg.length == 0 ? 21042 : Integer.parseInt(arg[0]);
        Thread doipServerThread = new Thread(){

            @Override
            public void run() {
                try {
                    DoipLocalSingleton.run(port, null);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        doipServerThread.start();
    }

    public static int run(int port, JsonElement otherConfigs) throws InterruptedException {
        int i = -1;
        LOGGER.info("try to listener port:" + port);
        i = DoipLocalSingleton.run("tcp://127.0.0.1:" + port++, otherConfigs);
        while (i < 0) {
            LOGGER.info("try again to listener port:" + port);
            i = DoipLocalSingleton.run("tcp://127.0.0.1:" + port++, otherConfigs);
        }
        return i;
    }

    public static int run(String doipAddr, JsonElement otherConfigs) throws InterruptedException {
        ArrayList<DoipListenerConfig> infos = new ArrayList<DoipListenerConfig>();
        int port = -1;
        try {
            URI uri = new URI(doipAddr);
            port = uri.getPort();
            infos.add(new DoipListenerConfig(doipAddr, "2.1"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String repoID = "bdtest/BDRepo/" + UUID.randomUUID().toString();
        String owner = ContractProcess.instance.getContract().getOwner();
        String repoType = "Repository";
        try {
            if (otherConfigs != null && otherConfigs.isJsonObject()) {
                EndpointConfig config = new TempConfigStorage(otherConfigs.toString()).loadAsEndpointConfig();
                if (config.routerURI != null) {
                    AuditIrpClient irpClient = new AuditIrpClient(config);
                    EndpointInfo endpointInfo = irpClient.getEndpointInfo();
                    repoID = endpointInfo.getDoId();
                    owner = endpointInfo.getPubKey();
                    infos.clear();
                    infos.add(new DoipListenerConfig(endpointInfo.getURI(), "2.1"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DoipServiceInfo info = new DoipServiceInfo(repoID, owner, repoType, infos);
        server = new DoipServerImpl(info);
        DOOPRequestHandler handler = ContractProcess.instance.doopRequestHandler;
        server.setRequestCallback((DoipRequestHandler)handler);
        ResultChecker checker = new ResultChecker();
        server.start((StartServerCallback)checker);
        checker.waitForResult(1000L);
        if (checker.port > 0) {
            return port;
        }
        return -1;
    }

    static class ResultChecker
    implements StartServerCallback {
        int port = -2;

        ResultChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(int i) {
            this.port = i;
            ResultChecker resultChecker = this;
            synchronized (resultChecker) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForResult(long timeout) {
            ResultChecker resultChecker = this;
            synchronized (resultChecker) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(Exception e) {
            this.port = -1;
            ResultChecker resultChecker = this;
            synchronized (resultChecker) {
                this.notify();
            }
        }
    }
}

