/*
 * Decompiled with CFR 0.152.
 */
package wrp.jdk.nashorn.internal.runtime;

import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import wrp.jdk.nashorn.internal.runtime.Context;
import wrp.jdk.nashorn.internal.runtime.Instrumenter;
import wrp.jdk.nashorn.internal.runtime.NashornLoader;

public final class ScriptLoader
extends NashornLoader {
    private static final String NASHORN_PKG_PREFIX = "wrp.jdk.nashorn.internal.";
    private final Context context;
    private Map<String, byte[]> clzCache;
    private Instrumenter instr;

    public Map<String, byte[]> getClzCache() {
        return this.clzCache;
    }

    Context getContext() {
        return this.context;
    }

    ScriptLoader(Context context, Instrumenter instr) {
        this(context);
        this.instr = instr;
    }

    ScriptLoader(Context context) {
        super(context.getStructLoader());
        this.context = context;
        this.clzCache = new HashMap<String, byte[]>();
        this.instr = null;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ScriptLoader.checkPackageAccess(name);
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ClassLoader appLoader = this.context.getAppLoader();
        if (appLoader == null || name.startsWith(NASHORN_PKG_PREFIX)) {
            throw new ClassNotFoundException(name);
        }
        return appLoader.loadClass(name);
    }

    synchronized Class<?> installClass(String name, byte[] data, CodeSource cs) {
        byte[] instrumentedData = this.instr != null ? this.instr.instrument(name, data) : data;
        this.clzCache.put(name, instrumentedData);
        return this.defineClass(name, instrumentedData, 0, instrumentedData.length, Objects.requireNonNull(cs));
    }
}

