/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.container.util;

import com.alibaba.datax.common.constant.CommonConstant;
import com.alibaba.datax.common.util.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;

public final class JobAssignUtil {
    private JobAssignUtil() {
    }

    public static List<Configuration> assignFairly(Configuration configuration, int channelNumber, int channelsPerTaskGroup) {
        boolean hasLoadBalanceResourceMark;
        Validate.isTrue((configuration != null ? 1 : 0) != 0, (String)"\u6846\u67b6\u83b7\u5f97\u7684 Job \u4e0d\u80fd\u4e3a null.");
        List<Configuration> contentConfig = configuration.getListConfiguration("job.content");
        Validate.isTrue((contentConfig.size() > 0 ? 1 : 0) != 0, (String)"\u6846\u67b6\u83b7\u5f97\u7684\u5207\u5206\u540e\u7684 Job \u65e0\u5185\u5bb9.");
        Validate.isTrue((channelNumber > 0 && channelsPerTaskGroup > 0 ? 1 : 0) != 0, (String)"\u6bcf\u4e2achannel\u7684\u5e73\u5747task\u6570[averTaskPerChannel]\uff0cchannel\u6570\u76ee[channelNumber]\uff0c\u6bcf\u4e2ataskGroup\u7684\u5e73\u5747channel\u6570[channelsPerTaskGroup]\u90fd\u5e94\u8be5\u4e3a\u6b63\u6570");
        int taskGroupNumber = (int)Math.ceil(1.0 * (double)channelNumber / (double)channelsPerTaskGroup);
        Configuration aTaskConfig = contentConfig.get(0);
        String readerResourceMark = aTaskConfig.getString("reader.parameter." + CommonConstant.LOAD_BALANCE_RESOURCE_MARK);
        String writerResourceMark = aTaskConfig.getString("writer.parameter." + CommonConstant.LOAD_BALANCE_RESOURCE_MARK);
        boolean bl = hasLoadBalanceResourceMark = StringUtils.isNotBlank((CharSequence)readerResourceMark) || StringUtils.isNotBlank((CharSequence)writerResourceMark);
        if (!hasLoadBalanceResourceMark) {
            for (Configuration conf : contentConfig) {
                conf.set("reader.parameter." + CommonConstant.LOAD_BALANCE_RESOURCE_MARK, "aFakeResourceMarkForLoadBalance");
            }
            Collections.shuffle(contentConfig, new Random(System.currentTimeMillis()));
        }
        LinkedHashMap<String, List<Integer>> resourceMarkAndTaskIdMap = JobAssignUtil.parseAndGetResourceMarkAndTaskIdMap(contentConfig);
        List<Configuration> taskGroupConfig = JobAssignUtil.doAssign(resourceMarkAndTaskIdMap, configuration, taskGroupNumber);
        JobAssignUtil.adjustChannelNumPerTaskGroup(taskGroupConfig, channelNumber);
        return taskGroupConfig;
    }

    private static void adjustChannelNumPerTaskGroup(List<Configuration> taskGroupConfig, int channelNumber) {
        int i;
        int taskGroupNumber = taskGroupConfig.size();
        int avgChannelsPerTaskGroup = channelNumber / taskGroupNumber;
        int remainderChannelCount = channelNumber % taskGroupNumber;
        for (i = 0; i < remainderChannelCount; ++i) {
            taskGroupConfig.get(i).set("core.container.taskGroup.channel", avgChannelsPerTaskGroup + 1);
        }
        for (int j = 0; j < taskGroupNumber - remainderChannelCount; ++j) {
            taskGroupConfig.get(i + j).set("core.container.taskGroup.channel", avgChannelsPerTaskGroup);
        }
    }

    private static LinkedHashMap<String, List<Integer>> parseAndGetResourceMarkAndTaskIdMap(List<Configuration> contentConfig) {
        LinkedHashMap<String, List<Integer>> readerResourceMarkAndTaskIdMap = new LinkedHashMap<String, List<Integer>>();
        LinkedHashMap<String, List<Integer>> writerResourceMarkAndTaskIdMap = new LinkedHashMap<String, List<Integer>>();
        for (Configuration aTaskConfig : contentConfig) {
            int taskId = aTaskConfig.getInt("taskId");
            String readerResourceMark = aTaskConfig.getString("reader.parameter." + CommonConstant.LOAD_BALANCE_RESOURCE_MARK);
            if (readerResourceMarkAndTaskIdMap.get(readerResourceMark) == null) {
                readerResourceMarkAndTaskIdMap.put(readerResourceMark, new LinkedList());
            }
            readerResourceMarkAndTaskIdMap.get(readerResourceMark).add(taskId);
            String writerResourceMark = aTaskConfig.getString("writer.parameter." + CommonConstant.LOAD_BALANCE_RESOURCE_MARK);
            if (writerResourceMarkAndTaskIdMap.get(writerResourceMark) == null) {
                writerResourceMarkAndTaskIdMap.put(writerResourceMark, new LinkedList());
            }
            writerResourceMarkAndTaskIdMap.get(writerResourceMark).add(taskId);
        }
        if (readerResourceMarkAndTaskIdMap.size() >= writerResourceMarkAndTaskIdMap.size()) {
            return readerResourceMarkAndTaskIdMap;
        }
        return writerResourceMarkAndTaskIdMap;
    }

    private static List<Configuration> doAssign(LinkedHashMap<String, List<Integer>> resourceMarkAndTaskIdMap, Configuration jobConfiguration, int taskGroupNumber) {
        List<Configuration> contentConfig = jobConfiguration.getListConfiguration("job.content");
        Configuration taskGroupTemplate = jobConfiguration.clone();
        taskGroupTemplate.remove("job.content");
        LinkedList<Configuration> result = new LinkedList<Configuration>();
        ArrayList taskGroupConfigList = new ArrayList(taskGroupNumber);
        for (int i = 0; i < taskGroupNumber; ++i) {
            taskGroupConfigList.add(new LinkedList());
        }
        int mapValueMaxLength = -1;
        ArrayList<String> resourceMarks = new ArrayList<String>();
        for (Map.Entry<String, List<Integer>> entry : resourceMarkAndTaskIdMap.entrySet()) {
            resourceMarks.add(entry.getKey());
            if (entry.getValue().size() <= mapValueMaxLength) continue;
            mapValueMaxLength = entry.getValue().size();
        }
        int taskGroupIndex = 0;
        for (int i = 0; i < mapValueMaxLength; ++i) {
            for (String resourceMark : resourceMarks) {
                if (resourceMarkAndTaskIdMap.get(resourceMark).size() <= 0) continue;
                int taskId = resourceMarkAndTaskIdMap.get(resourceMark).get(0);
                ((List)taskGroupConfigList.get(taskGroupIndex % taskGroupNumber)).add(contentConfig.get(taskId));
                ++taskGroupIndex;
                resourceMarkAndTaskIdMap.get(resourceMark).remove(0);
            }
        }
        for (int i = 0; i < taskGroupNumber; ++i) {
            Configuration tempTaskGroupConfig = taskGroupTemplate.clone();
            tempTaskGroupConfig.set("job.content", taskGroupConfigList.get(i));
            tempTaskGroupConfig.set("core.container.taskGroup.id", i);
            result.add(tempTaskGroupConfig);
        }
        return result;
    }
}

