/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import com.alibaba.datax.core.util.container.CoreConstant;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class SecretUtil {
    private static Properties properties;
    private static Map<String, Triple<String, String, String>> versionKeyMap;
    private static final String ENCODING = "UTF-8";
    public static final String KEY_ALGORITHM_RSA = "RSA";
    public static final String KEY_ALGORITHM_3DES = "DESede";
    private static final String CIPHER_ALGORITHM_3DES = "DESede/ECB/PKCS5Padding";
    private static final Base64 base64;

    public static String encryptBASE64(byte[] plaintextBytes) throws Exception {
        return new String(base64.encode(plaintextBytes), ENCODING);
    }

    public static byte[] decryptBASE64(String cipherText) {
        return base64.decode(cipherText);
    }

    public static String encrypt(String data, String key, String method) {
        if (KEY_ALGORITHM_RSA.equals(method)) {
            return SecretUtil.encryptRSA(data, key);
        }
        if (KEY_ALGORITHM_3DES.equals(method)) {
            return SecretUtil.encrypt3DES(data, key);
        }
        throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, String.format("\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef,\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7c7b\u578b", method));
    }

    public static String decrypt(String data, String key, String method) {
        if (KEY_ALGORITHM_RSA.equals(method)) {
            return SecretUtil.decryptRSA(data, key);
        }
        if (KEY_ALGORITHM_3DES.equals(method)) {
            return SecretUtil.decrypt3DES(data, key);
        }
        throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, String.format("\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef,\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7c7b\u578b", method));
    }

    public static String encryptRSA(String data, String key) {
        try {
            byte[] keyBytes = SecretUtil.decryptBASE64(key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicKey);
            return SecretUtil.encryptBASE64(cipher.doFinal(data.getBytes(ENCODING)));
        }
        catch (Exception e) {
            throw DataXException.asDataXException(FrameworkErrorCode.SECRET_ERROR, "rsa\u52a0\u5bc6\u51fa\u9519", e);
        }
    }

    public static String decryptRSA(String data, String key) {
        try {
            byte[] keyBytes = SecretUtil.decryptBASE64(key);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateKey);
            return new String(cipher.doFinal(SecretUtil.decryptBASE64(data)), ENCODING);
        }
        catch (Exception e) {
            throw DataXException.asDataXException(FrameworkErrorCode.SECRET_ERROR, "rsa\u89e3\u5bc6\u51fa\u9519", e);
        }
    }

    public static String[] initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        String[] publicAndPrivateKey = new String[]{SecretUtil.encryptBASE64(publicKey.getEncoded()), SecretUtil.encryptBASE64(privateKey.getEncoded())};
        return publicAndPrivateKey;
    }

    public static String encrypt3DES(String data, String key) {
        try {
            SecretKeySpec desKey = new SecretKeySpec(SecretUtil.build3DesKey(key), KEY_ALGORITHM_3DES);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_3DES);
            cipher.init(1, desKey);
            return SecretUtil.encryptBASE64(cipher.doFinal(data.getBytes(ENCODING)));
        }
        catch (Exception e) {
            throw DataXException.asDataXException(FrameworkErrorCode.SECRET_ERROR, "3\u91cdDES\u52a0\u5bc6\u51fa\u9519", e);
        }
    }

    public static String decrypt3DES(String data, String key) {
        try {
            SecretKeySpec desKey = new SecretKeySpec(SecretUtil.build3DesKey(key), KEY_ALGORITHM_3DES);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_3DES);
            cipher.init(2, desKey);
            return new String(cipher.doFinal(SecretUtil.decryptBASE64(data)), ENCODING);
        }
        catch (Exception e) {
            throw DataXException.asDataXException(FrameworkErrorCode.SECRET_ERROR, "rsa\u89e3\u5bc6\u51fa\u9519", e);
        }
    }

    private static byte[] build3DesKey(String keyStr) {
        try {
            byte[] key = "000000000000000000000000".getBytes(ENCODING);
            byte[] temp = keyStr.getBytes(ENCODING);
            if (key.length > temp.length) {
                System.arraycopy(temp, 0, key, 0, temp.length);
            } else {
                System.arraycopy(temp, 0, key, 0, key.length);
            }
            return key;
        }
        catch (Exception e) {
            throw DataXException.asDataXException(FrameworkErrorCode.SECRET_ERROR, "\u6784\u5efa\u4e09\u91cdDES\u5bc6\u5319\u51fa\u9519", e);
        }
    }

    public static synchronized Properties getSecurityProperties() {
        if (properties == null) {
            FileInputStream secretStream = null;
            try {
                secretStream = new FileInputStream(CoreConstant.DATAX_SECRET_PATH);
            }
            catch (FileNotFoundException e) {
                throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, "DataX\u914d\u7f6e\u8981\u6c42\u52a0\u89e3\u5bc6\uff0c\u4f46\u65e0\u6cd5\u627e\u5230\u5bc6\u94a5\u7684\u914d\u7f6e\u6587\u4ef6");
            }
            properties = new Properties();
            try {
                properties.load(secretStream);
                ((InputStream)secretStream).close();
            }
            catch (IOException e) {
                throw DataXException.asDataXException(FrameworkErrorCode.SECRET_ERROR, "\u8bfb\u53d6\u52a0\u89e3\u5bc6\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", e);
            }
        }
        return properties;
    }

    public static Configuration encryptSecretKey(Configuration configuration) {
        String keyVersion = configuration.getString("job.setting.keyVersion");
        if (StringUtils.isBlank((String)keyVersion)) {
            return configuration;
        }
        Map<String, Triple<String, String, String>> versionKeyMap = SecretUtil.getPrivateKeyMap();
        if (null == versionKeyMap.get(keyVersion)) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, String.format("DataX\u914d\u7f6e\u7684\u5bc6\u94a5\u7248\u672c\u4e3a[%s]\uff0c\u4f46\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u914d\u7f6e\uff0c\u4efb\u52a1\u5bc6\u94a5\u914d\u7f6e\u9519\u8bef\uff0c\u4e0d\u5b58\u5728\u60a8\u914d\u7f6e\u7684\u5bc6\u94a5\u7248\u672c", keyVersion));
        }
        String key = (String)versionKeyMap.get(keyVersion).getRight();
        String method = (String)versionKeyMap.get(keyVersion).getMiddle();
        if (StringUtils.isBlank((String)key)) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, String.format("DataX\u914d\u7f6e\u7684\u5bc6\u94a5\u7248\u672c\u4e3a[%s]\uff0c\u4f46\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u914d\u7f6e\uff0c\u53ef\u80fd\u662f\u4efb\u52a1\u5bc6\u94a5\u914d\u7f6e\u9519\u8bef\uff0c\u4e5f\u53ef\u80fd\u662f\u7cfb\u7edf\u7ef4\u62a4\u95ee\u9898", keyVersion));
        }
        String tempEncrptedData = null;
        for (String path : configuration.getSecretKeyPathSet()) {
            tempEncrptedData = SecretUtil.encrypt(configuration.getString(path), key, method);
            int lastPathIndex = path.lastIndexOf(".") + 1;
            String lastPathKey = path.substring(lastPathIndex);
            String newPath = path.substring(0, lastPathIndex) + "*" + lastPathKey;
            configuration.set(newPath, tempEncrptedData);
            configuration.remove(path);
        }
        return configuration;
    }

    public static Configuration decryptSecretKey(Configuration config) {
        String keyVersion = config.getString("job.setting.keyVersion");
        if (StringUtils.isBlank((String)keyVersion)) {
            return config;
        }
        Map<String, Triple<String, String, String>> versionKeyMap = SecretUtil.getPrivateKeyMap();
        if (null == versionKeyMap.get(keyVersion)) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, String.format("DataX\u914d\u7f6e\u7684\u5bc6\u94a5\u7248\u672c\u4e3a[%s]\uff0c\u4f46\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u914d\u7f6e\uff0c\u4efb\u52a1\u5bc6\u94a5\u914d\u7f6e\u9519\u8bef\uff0c\u4e0d\u5b58\u5728\u60a8\u914d\u7f6e\u7684\u5bc6\u94a5\u7248\u672c", keyVersion));
        }
        String decryptKey = (String)versionKeyMap.get(keyVersion).getLeft();
        String method = (String)versionKeyMap.get(keyVersion).getMiddle();
        if (StringUtils.isBlank((String)decryptKey)) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, String.format("DataX\u914d\u7f6e\u7684\u5bc6\u94a5\u7248\u672c\u4e3a[%s]\uff0c\u4f46\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u914d\u7f6e\uff0c\u53ef\u80fd\u662f\u4efb\u52a1\u5bc6\u94a5\u914d\u7f6e\u9519\u8bef\uff0c\u4e5f\u53ef\u80fd\u662f\u7cfb\u7edf\u7ef4\u62a4\u95ee\u9898", keyVersion));
        }
        for (String key : config.getKeys()) {
            Object value;
            int lastPathIndex;
            String lastPathKey = key.substring(lastPathIndex = key.lastIndexOf(".") + 1);
            if (lastPathKey.length() <= 1 || lastPathKey.charAt(0) != '*' || lastPathKey.charAt(1) == '*' || !((value = config.get(key)) instanceof String)) continue;
            String newKey = key.substring(0, lastPathIndex) + lastPathKey.substring(1);
            config.set(newKey, SecretUtil.decrypt((String)value, decryptKey, method));
            config.addSecretKeyPath(newKey);
            config.remove(key);
        }
        return config;
    }

    private static synchronized Map<String, Triple<String, String, String>> getPrivateKeyMap() {
        if (versionKeyMap == null) {
            versionKeyMap = new HashMap<String, Triple<String, String, String>>();
            Properties properties = SecretUtil.getSecurityProperties();
            String[] serviceUsernames = new String[]{"last.service.username", "current.service.username"};
            String[] servicePasswords = new String[]{"last.service.password", "current.service.password"};
            for (int i = 0; i < serviceUsernames.length; ++i) {
                String serviceUsername = properties.getProperty(serviceUsernames[i]);
                if (!StringUtils.isNotBlank((String)serviceUsername)) continue;
                String servicePassword = properties.getProperty(servicePasswords[i]);
                if (StringUtils.isNotBlank((String)servicePassword)) {
                    versionKeyMap.put(serviceUsername, (Triple<String, String, String>)ImmutableTriple.of((Object)servicePassword, (Object)KEY_ALGORITHM_3DES, (Object)servicePassword));
                    continue;
                }
                throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, String.format("DataX\u914d\u7f6e\u8981\u6c42\u52a0\u89e3\u5bc6\uff0c\u4f46\u914d\u7f6e\u7684\u5bc6\u94a5\u7248\u672c[%s]\u5b58\u5728\u5bc6\u94a5\u4e3a\u7a7a\u7684\u60c5\u51b5", serviceUsername));
            }
            String[] keyVersions = new String[]{"last.keyVersion", "current.keyVersion"};
            String[] privateKeys = new String[]{"last.privateKey", "current.privateKey"};
            String[] publicKeys = new String[]{"last.publicKey", "current.publicKey"};
            for (int i = 0; i < keyVersions.length; ++i) {
                String keyVersion = properties.getProperty(keyVersions[i]);
                if (!StringUtils.isNotBlank((String)keyVersion)) continue;
                String privateKey = properties.getProperty(privateKeys[i]);
                String publicKey = properties.getProperty(publicKeys[i]);
                if (StringUtils.isNotBlank((String)privateKey) && StringUtils.isNotBlank((String)publicKey)) {
                    versionKeyMap.put(keyVersion, (Triple<String, String, String>)ImmutableTriple.of((Object)privateKey, (Object)KEY_ALGORITHM_RSA, (Object)publicKey));
                    continue;
                }
                throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, String.format("DataX\u914d\u7f6e\u8981\u6c42\u52a0\u89e3\u5bc6\uff0c\u4f46\u914d\u7f6e\u7684\u516c\u79c1\u94a5\u5bf9\u5b58\u5728\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0c\u7248\u672c[%s]", keyVersion));
            }
        }
        if (versionKeyMap.size() <= 0) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.SECRET_ERROR, "DataX\u914d\u7f6e\u8981\u6c42\u52a0\u89e3\u5bc6\uff0c\u4f46\u65e0\u6cd5\u627e\u5230\u52a0\u89e3\u5bc6\u914d\u7f6e");
        }
        return versionKeyMap;
    }

    static {
        base64 = new Base64();
    }
}

