/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.transport.transformer;

import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import groovy.lang.GroovyClassLoader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyTransformer
extends Transformer {
    private Transformer groovyTransformer;

    public GroovyTransformer() {
        this.setTransformerName("dx_groovy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record evaluate(Record record, Object ... paras) {
        if (this.groovyTransformer == null) {
            if (paras.length < 1 || paras.length > 2) {
                throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "dx_groovy paras must be 1 or 2 . now paras is: " + Arrays.asList(paras).toString());
            }
            GroovyTransformer groovyTransformer = this;
            synchronized (groovyTransformer) {
                if (this.groovyTransformer == null) {
                    String code = (String)paras[0];
                    List extraPackage = paras.length == 2 ? (List)paras[1] : null;
                    this.initGroovyTransformer(code, extraPackage);
                }
            }
        }
        return this.groovyTransformer.evaluate(record, new Object[0]);
    }

    private void initGroovyTransformer(String code, List<String> extraPackage) {
        Class groovyClass;
        GroovyClassLoader loader = new GroovyClassLoader(GroovyTransformer.class.getClassLoader());
        String groovyRule = this.getGroovyRule(code, extraPackage);
        try {
            groovyClass = loader.parseClass(groovyRule);
        }
        catch (CompilationFailedException cfe) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_GROOVY_INIT_EXCEPTION, cfe);
        }
        try {
            Object t = groovyClass.newInstance();
            if (!(t instanceof Transformer)) {
                throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_GROOVY_INIT_EXCEPTION, "datax bug! contact askdatax");
            }
            this.groovyTransformer = (Transformer)t;
        }
        catch (Throwable ex) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_GROOVY_INIT_EXCEPTION, ex);
        }
    }

    private String getGroovyRule(String expression, List<String> extraPackagesStrList) {
        StringBuffer sb = new StringBuffer();
        if (extraPackagesStrList != null) {
            for (String extraPackagesStr : extraPackagesStrList) {
                if (!StringUtils.isNotEmpty((CharSequence)extraPackagesStr)) continue;
                sb.append(extraPackagesStr);
            }
        }
        sb.append("import static com.alibaba.datax.core.transport.transformer.GroovyTransformerStaticUtil.*;");
        sb.append("import com.alibaba.datax.common.element.*;");
        sb.append("import com.alibaba.datax.common.exception.DataXException;");
        sb.append("import Transformer;");
        sb.append("import java.util.*;");
        sb.append("public class RULE extends Transformer").append("{");
        sb.append("public Record evaluate(Record record, Object... paras) {");
        sb.append(expression);
        sb.append("}}");
        return sb.toString();
    }
}

