/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.rdbms.reader.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.common.util.ListUtil;
import com.alibaba.datax.plugin.rdbms.reader.Constant;
import com.alibaba.datax.plugin.rdbms.util.DBUtil;
import com.alibaba.datax.plugin.rdbms.util.DBUtilErrorCode;
import com.alibaba.datax.plugin.rdbms.util.DataBaseType;
import com.alibaba.datax.plugin.rdbms.util.TableExpandUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OriginalConfPretreatmentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OriginalConfPretreatmentUtil.class);
    public static DataBaseType DATABASE_TYPE;

    public static void doPretreatment(Configuration originalConfig) {
        originalConfig.getNecessaryValue("username", DBUtilErrorCode.REQUIRED_VALUE);
        originalConfig.getNecessaryValue("password", DBUtilErrorCode.REQUIRED_VALUE);
        OriginalConfPretreatmentUtil.dealWhere(originalConfig);
        OriginalConfPretreatmentUtil.simplifyConf(originalConfig);
    }

    public static void dealWhere(Configuration originalConfig) {
        String where = originalConfig.getString("where", null);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            String whereImprove = where.trim();
            if (whereImprove.endsWith(";") || whereImprove.endsWith("\uff1b")) {
                whereImprove = whereImprove.substring(0, whereImprove.length() - 1);
            }
            originalConfig.set("where", whereImprove);
        }
    }

    private static void simplifyConf(Configuration originalConfig) {
        boolean isTableMode = OriginalConfPretreatmentUtil.recognizeTableOrQuerySqlMode(originalConfig);
        originalConfig.set(Constant.IS_TABLE_MODE, isTableMode);
        OriginalConfPretreatmentUtil.dealJdbcAndTable(originalConfig);
        OriginalConfPretreatmentUtil.dealColumnConf(originalConfig);
    }

    private static void dealJdbcAndTable(Configuration originalConfig) {
        String username = originalConfig.getString("username");
        String password = originalConfig.getString("password");
        boolean checkSlave = originalConfig.getBool("checkSlave", false);
        boolean isTableMode = originalConfig.getBool(Constant.IS_TABLE_MODE);
        boolean isPreCheck = originalConfig.getBool("dryRun", false);
        List<Object> conns = originalConfig.getList(Constant.CONN_MARK, Object.class);
        List<String> preSql = originalConfig.getList("preSql", String.class);
        int tableNum = 0;
        int len = conns.size();
        for (int i = 0; i < len; ++i) {
            Configuration connConf = Configuration.from(conns.get(i).toString());
            connConf.getNecessaryValue("jdbcUrl", DBUtilErrorCode.REQUIRED_VALUE);
            List<String> jdbcUrls = connConf.getList("jdbcUrl", String.class);
            String jdbcUrl = isPreCheck ? DBUtil.chooseJdbcUrlWithoutRetry(DATABASE_TYPE, jdbcUrls, username, password, preSql, checkSlave) : DBUtil.chooseJdbcUrl(DATABASE_TYPE, jdbcUrls, username, password, preSql, checkSlave);
            jdbcUrl = DATABASE_TYPE.appendJDBCSuffixForReader(jdbcUrl);
            originalConfig.set(String.format("%s[%d].%s", Constant.CONN_MARK, i, "jdbcUrl"), jdbcUrl);
            LOG.info("Available jdbcUrl:{}.", (Object)jdbcUrl);
            if (!isTableMode) continue;
            List<String> tables = connConf.getList("table", String.class);
            List<String> expandedTables = TableExpandUtil.expandTableConf(DATABASE_TYPE, tables);
            if (null == expandedTables || expandedTables.isEmpty()) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_VALUE, String.format("\u60a8\u6240\u914d\u7f6e\u7684\u8bfb\u53d6\u6570\u636e\u5e93\u8868:%s \u4e0d\u6b63\u786e. \u56e0\u4e3aDataX\u6839\u636e\u60a8\u7684\u914d\u7f6e\u627e\u4e0d\u5230\u8fd9\u5f20\u8868. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.\u8bf7\u5148\u4e86\u89e3 DataX \u914d\u7f6e.", StringUtils.join(tables, (String)",")));
            }
            tableNum += expandedTables.size();
            originalConfig.set(String.format("%s[%d].%s", Constant.CONN_MARK, i, "table"), expandedTables);
        }
        originalConfig.set(Constant.TABLE_NUMBER_MARK, tableNum);
    }

    private static void dealColumnConf(Configuration originalConfig) {
        boolean isTableMode = originalConfig.getBool(Constant.IS_TABLE_MODE);
        List<String> userConfiguredColumns = originalConfig.getList("column", String.class);
        if (isTableMode) {
            if (null == userConfiguredColumns || userConfiguredColumns.isEmpty()) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.REQUIRED_VALUE, "\u60a8\u672a\u914d\u7f6e\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u7684\u5217\u4fe1\u606f. \u6b63\u786e\u7684\u914d\u7f6e\u65b9\u5f0f\u662f\u7ed9 column \u914d\u7f6e\u4e0a\u60a8\u9700\u8981\u8bfb\u53d6\u7684\u5217\u540d\u79f0,\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694. \u4f8b\u5982: \"column\": [\"id\", \"name\"],\u8bf7\u53c2\u8003\u4e0a\u8ff0\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
            }
            String splitPk = originalConfig.getString("splitPk", null);
            if (1 == userConfiguredColumns.size() && "*".equals(userConfiguredColumns.get(0))) {
                LOG.warn("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u5b58\u5728\u4e00\u5b9a\u7684\u98ce\u9669. \u56e0\u4e3a\u60a8\u672a\u914d\u7f6e\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u7684\u5217\uff0c\u5f53\u60a8\u7684\u8868\u5b57\u6bb5\u4e2a\u6570\u3001\u7c7b\u578b\u6709\u53d8\u52a8\u65f6\uff0c\u53ef\u80fd\u5f71\u54cd\u4efb\u52a1\u6b63\u786e\u6027\u751a\u81f3\u4f1a\u8fd0\u884c\u51fa\u9519\u3002\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
                originalConfig.set("column", "*");
            } else {
                String jdbcUrl = originalConfig.getString(String.format("%s[0].%s", Constant.CONN_MARK, "jdbcUrl"));
                String username = originalConfig.getString("username");
                String password = originalConfig.getString("password");
                String tableName = originalConfig.getString(String.format("%s[0].%s[0]", Constant.CONN_MARK, "table"));
                List<String> allColumns = DBUtil.getTableColumns(DATABASE_TYPE, jdbcUrl, username, password, tableName);
                LOG.info("table:[{}] has columns:[{}].", (Object)tableName, (Object)StringUtils.join(allColumns, (String)","));
                allColumns = ListUtil.valueToLowerCase(allColumns);
                ArrayList<String> quotedColumns = new ArrayList<String>();
                for (String column : userConfiguredColumns) {
                    if ("*".equals(column)) {
                        throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_VALUE, "\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u56e0\u4e3a\u6839\u636e\u60a8\u7684\u914d\u7f6e\uff0c\u6570\u636e\u5e93\u8868\u7684\u5217\u4e2d\u5b58\u5728\u591a\u4e2a*. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539. ");
                    }
                    quotedColumns.add(column);
                }
                originalConfig.set("columnList", quotedColumns);
                originalConfig.set("column", StringUtils.join(quotedColumns, (String)","));
                if (StringUtils.isNotBlank((CharSequence)splitPk) && !allColumns.contains(splitPk.toLowerCase())) {
                    throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef. \u56e0\u4e3a\u6839\u636e\u60a8\u7684\u914d\u7f6e\uff0c\u60a8\u8bfb\u53d6\u7684\u6570\u636e\u5e93\u8868:%s \u4e2d\u6ca1\u6709\u4e3b\u952e\u540d\u4e3a:%s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", tableName, splitPk));
                }
            }
        } else {
            String splitPk;
            String where;
            if (null != userConfiguredColumns && userConfiguredColumns.size() > 0) {
                LOG.warn("\u60a8\u7684\u914d\u7f6e\u6709\u8bef. \u7531\u4e8e\u60a8\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u91c7\u7528\u4e86querySql\u7684\u65b9\u5f0f, \u6240\u4ee5\u60a8\u4e0d\u9700\u8981\u518d\u914d\u7f6e column. \u5982\u679c\u60a8\u4e0d\u60f3\u770b\u5230\u8fd9\u6761\u63d0\u9192\uff0c\u8bf7\u79fb\u9664\u60a8\u6e90\u5934\u8868\u4e2d\u914d\u7f6e\u4e2d\u7684 column.");
                originalConfig.remove("column");
            }
            if (StringUtils.isNotBlank((CharSequence)(where = originalConfig.getString("where", null)))) {
                LOG.warn("\u60a8\u7684\u914d\u7f6e\u6709\u8bef. \u7531\u4e8e\u60a8\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u91c7\u7528\u4e86querySql\u7684\u65b9\u5f0f, \u6240\u4ee5\u60a8\u4e0d\u9700\u8981\u518d\u914d\u7f6e where. \u5982\u679c\u60a8\u4e0d\u60f3\u770b\u5230\u8fd9\u6761\u63d0\u9192\uff0c\u8bf7\u79fb\u9664\u60a8\u6e90\u5934\u8868\u4e2d\u914d\u7f6e\u4e2d\u7684 where.");
                originalConfig.remove("where");
            }
            if (StringUtils.isNotBlank((CharSequence)(splitPk = originalConfig.getString("splitPk", null)))) {
                LOG.warn("\u60a8\u7684\u914d\u7f6e\u6709\u8bef. \u7531\u4e8e\u60a8\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u91c7\u7528\u4e86querySql\u7684\u65b9\u5f0f, \u6240\u4ee5\u60a8\u4e0d\u9700\u8981\u518d\u914d\u7f6e splitPk. \u5982\u679c\u60a8\u4e0d\u60f3\u770b\u5230\u8fd9\u6761\u63d0\u9192\uff0c\u8bf7\u79fb\u9664\u60a8\u6e90\u5934\u8868\u4e2d\u914d\u7f6e\u4e2d\u7684 splitPk.");
                originalConfig.remove("splitPk");
            }
        }
    }

    private static boolean recognizeTableOrQuerySqlMode(Configuration originalConfig) {
        List<Object> conns = originalConfig.getList(Constant.CONN_MARK, Object.class);
        ArrayList<Boolean> tableModeFlags = new ArrayList<Boolean>();
        ArrayList<Boolean> querySqlModeFlags = new ArrayList<Boolean>();
        String table = null;
        String querySql = null;
        boolean isTableMode = false;
        boolean isQuerySqlMode = false;
        int len = conns.size();
        for (int i = 0; i < len; ++i) {
            Configuration connConf = Configuration.from(conns.get(i).toString());
            table = connConf.getString("table", null);
            querySql = connConf.getString("querySql", null);
            isTableMode = StringUtils.isNotBlank((CharSequence)table);
            tableModeFlags.add(isTableMode);
            isQuerySqlMode = StringUtils.isNotBlank((CharSequence)querySql);
            querySqlModeFlags.add(isQuerySqlMode);
            if (!isTableMode && !isQuerySqlMode) {
                throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.TABLE_QUERYSQL_MISSING, "\u60a8\u7684\u914d\u7f6e\u6709\u8bef. \u56e0\u4e3atable\u548cquerySql\u5e94\u8be5\u914d\u7f6e\u5e76\u4e14\u53ea\u80fd\u914d\u7f6e\u4e00\u4e2a. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
            }
            if (!isTableMode || !isQuerySqlMode) continue;
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.TABLE_QUERYSQL_MIXED, "\u60a8\u7684\u914d\u7f6e\u51cc\u4e71\u4e86. \u56e0\u4e3adatax\u4e0d\u80fd\u540c\u65f6\u65e2\u914d\u7f6etable\u53c8\u914d\u7f6equerySql.\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
        }
        if (!ListUtil.checkIfValueSame(tableModeFlags) || !ListUtil.checkIfValueSame(tableModeFlags)) {
            throw DataXException.asDataXException((ErrorCode)DBUtilErrorCode.TABLE_QUERYSQL_MIXED, "\u60a8\u914d\u7f6e\u51cc\u4e71\u4e86. \u4e0d\u80fd\u540c\u65f6\u65e2\u914d\u7f6etable\u53c8\u914d\u7f6equerySql. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.");
        }
        return (Boolean)tableModeFlags.get(0);
    }
}

