/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import com.alibaba.datax.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.maskingMethods.anonymity.EnumerateMasker;
import java.util.Arrays;

public class EnumerateTransformer
extends Transformer {
    private Object masker;
    String key;
    int columnIndex;

    public EnumerateTransformer() {
        this.setTransformerName("dx_enum");
        System.out.println("Using enumerate masker");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        try {
            if (paras.length < 2) {
                throw new RuntimeException("dx_enum transformer\u7f3a\u5c11\u53c2\u6570");
            }
            this.columnIndex = (Integer)paras[0];
            this.key = String.valueOf(paras[1]);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(this.columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            int offset = Integer.parseInt(this.key);
            double newValue = EnumerateMasker.mask(column.asLong(), offset);
            record.setColumn(this.columnIndex, new DoubleColumn(newValue));
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

