/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.boundry.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.bdware.sc.compiler.PermissionStub;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.http.ApiGate;
import org.bdware.sc.node.Permission;
import org.bdware.sc.util.JsonUtil;
import wrp.jdk.nashorn.api.scripting.NashornScriptEngine;
import wrp.jdk.nashorn.api.scripting.ScriptObjectMirror;
import wrp.jdk.nashorn.internal.runtime.PropertyMap;
import wrp.jdk.nashorn.internal.runtime.ScriptFunction;
import wrp.jdk.nashorn.internal.runtime.ScriptObject;
import wrp.jdk.nashorn.internal.scripts.JO;

@PermissionStub(permission=Permission.Http)
public class HttpUtil {
    public static NashornScriptEngine currentEngine;

    public static ScriptObject request(ScriptObjectMirror str) {
        JO ret = new JO(PropertyMap.newMap());
        try {
            URL url = new URL((String)str.get("url"));
            String method = (String)str.get("method");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod(method.toUpperCase());
            Object headers = str.get("headers");
            if (headers != null && headers instanceof ScriptObjectMirror) {
                ScriptObjectMirror som = (ScriptObjectMirror)headers;
                for (String key : som.getOwnKeys(true)) {
                    Object val = som.get(key);
                    if (!(val instanceof String)) continue;
                    connection.setRequestProperty(key, (String)val);
                }
            } else {
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("Content-Type", "application/json");
            }
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            if (str.get("data") != null) {
                out.append((String)str.get("data"));
            }
            out.flush();
            out.close();
            ret.put("responseCode", connection.getResponseCode(), false);
            InputStream input = connection.getInputStream();
            Scanner sc = new Scanner(input);
            StringBuilder sb = new StringBuilder();
            while (sc.hasNextLine()) {
                sb.append(sc.nextLine()).append("\n");
            }
            sc.close();
            ret.put("response", sb.toString(), false);
        }
        catch (Throwable e) {
            ret.put("responseCode", 505, false);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            ret.put("response", bo.toString(), false);
        }
        return ret;
    }

    public static String encodeURI(String str) {
        return URLEncoder.encode(str);
    }

    public static String decodeURI(String str) {
        return URLDecoder.decode(str);
    }

    public static ScriptObject get(String str) {
        JO ret = new JO(PropertyMap.newMap());
        try {
            URL url = new URL(str);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            ret.put("responseCode", connection.getResponseCode(), false);
            InputStream input = connection.getInputStream();
            Scanner sc = new Scanner(input);
            StringBuilder sb = new StringBuilder();
            while (sc.hasNextLine()) {
                sb.append(sc.nextLine()).append("\n");
            }
            sc.close();
            ret.put("response", sb.toString(), false);
        }
        catch (Throwable e) {
            ret.put("resposeCode", 505, false);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            ret.put("response", bo.toString(), false);
        }
        return ret;
    }

    public static ScriptObject post(ScriptObjectMirror str) {
        JO ret = new JO(PropertyMap.newMap());
        try {
            URL url = new URL((String)str.get("url"));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            Object headers = str.get("headers");
            if (headers instanceof ScriptObjectMirror) {
                ScriptObjectMirror som = (ScriptObjectMirror)headers;
                for (String key : som.getOwnKeys(true)) {
                    Object val = som.get(key);
                    if (!(val instanceof String)) continue;
                    connection.setRequestProperty(key, (String)val);
                }
            } else {
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("Content-Type", "application/json");
            }
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
            out.append((String)str.get("data"));
            out.flush();
            out.close();
            ret.put("responseCode", connection.getResponseCode(), false);
            InputStream input = connection.getInputStream();
            Scanner sc = new Scanner(input);
            StringBuilder sb = new StringBuilder();
            while (sc.hasNextLine()) {
                sb.append(sc.nextLine()).append("\n");
            }
            sc.close();
            ret.put("response", sb.toString(), false);
        }
        catch (Throwable e) {
            ret.put("responseCode", 505, false);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            ret.put("response", bo.toString(), false);
        }
        return ret;
    }

    private static CloseableHttpClient getHttpClient(String url) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (arg0, arg1) -> true).build();
            SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslcontext, null, null, (HostnameVerifier)new NoopHostnameVerifier());
            int tle = 10;
            if (url.contains("data.tj.gov.cn")) {
                tle = 3;
            }
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).setKeepAliveStrategy((arg0, arg1) -> 0L).setConnectionTimeToLive((long)tle, TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String postTask(String args, final ScriptFunction callback) {
        System.out.println("[JavaScriptEntry]" + args);
        PostRequest req = new PostRequest();
        req = (PostRequest)JsonUtil.fromJson((String)args, PostRequest.class);
        OkHttpClient okHttpClient = new OkHttpClient();
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)req.data);
        Request request = new Request.Builder().url(req.url).post(body).build();
        Call call = okHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
                String result = response.body().string();
                System.out.println("currentEngine:");
                DesktopEngine.applyWithGlobal(callback, currentEngine.getNashornGlobal(), result);
            }
        });
        return "success";
    }

    public static ApiGate createAPIGate(String ip) {
        return new ApiGate(ip);
    }

    public static ApiGate createAPIGate(String ip, String port) {
        return new ApiGate(ip, Integer.parseInt(port));
    }

    static class PostRequest {
        String url;
        String data;

        PostRequest() {
        }
    }
}

