/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import wrp.jdk.nashorn.api.scripting.ClassFilter;

public class YJSClassLoader
extends URLClassLoader {
    ClassFilter classFilter;
    File libDir = null;
    List<String> toLoad = new ArrayList<String>();

    public YJSClassLoader(ClassLoader parent, ClassFilter cf) {
        super(new URL[0], parent);
        this.classFilter = cf;
    }

    @Override
    public Class<?> findClass(String fullName) throws ClassNotFoundException {
        if (this.classFilter != null && !this.classFilter.exposeToScripts(fullName)) {
            throw new ClassNotFoundException(fullName);
        }
        return super.findClass(fullName);
    }

    public Class<?> defineStubClass(String name, byte[] bytes) {
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    public void loadJar(InputStream inputStream, String path) {
        String fileName = this.unzipLibrary(inputStream, path);
        try {
            super.addURL(new File(fileName).toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private byte[] asByteArray(InputStream in) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int len = 0;
            while ((len = in.read(buff)) > 0) {
                bo.write(buff, 0, len);
            }
            return bo.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String unzipLibrary(InputStream inputStream, String name) {
        try {
            if (this.libDir == null) {
                this.libDir = new File(System.getProperty("java.io.tmpdir"), "yjscontract_" + System.currentTimeMillis());
                this.libDir.mkdirs();
            }
            File f = new File(this.libDir, name);
            f.createNewFile();
            this.toLoad.add(f.getAbsolutePath());
            FileOutputStream fout = new FileOutputStream(f);
            byte[] buff = new byte[102400];
            int k = 0;
            while ((k = inputStream.read(buff)) > 0) {
                fout.write(buff, 0, k);
            }
            fout.close();
            return f.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "/dev/null";
        }
    }

    private void addDirToPath(String s) {
        try {
            Field field = ClassLoader.class.getDeclaredField("sys_paths");
            field.setAccessible(true);
            String[] path = (String[])field.get(null);
            String[] temp = new String[path.length + 1];
            System.arraycopy(path, 0, temp, 0, path.length);
            temp[path.length] = s;
            field.set(null, temp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadLibraries() {
        if (this.libDir != null) {
            this.addDirToPath(this.libDir.getAbsolutePath());
        }
    }
}

