/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.engine.hook;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.security.interfaces.RSAPrivateKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractResult;
import org.bdware.sc.JSEngine;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.engine.hook.HomoVisitor;
import org.bdware.sc.engine.hook.ObjToJsonHandler;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.ArgPacks;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.util.JsonUtil;
import org.paillier.PaillierKeyPair;

public class HomomorphicDecryptHandler
implements AnnotationHook {
    private static final Logger LOGGER = LogManager.getLogger(ObjToJsonHandler.class);
    private final FunctionNode fun;

    public HomomorphicDecryptHandler(FunctionNode fun) {
        this.fun = fun;
    }

    public ArgPacks handle(JSEngine engine, ArgPacks argPacks) {
        try {
            JsonElement homoDecryptConf = this.fun.getHomoDecryptConf();
            if (null != homoDecryptConf && !homoDecryptConf.isJsonNull()) {
                String res = (String)JavaScriptEntry.executeContract("keyManager_1", "getPrivKey", this.fun.getSecretID().replaceAll("\"", ""));
                LOGGER.info("HomomorphicDecryptHandler--------------------------------1: " + res);
                ContractResult results = (ContractResult)JsonUtil.fromJson((String)res, ContractResult.class);
                String privKeyStr = results.result.getAsString();
                LOGGER.info("HomomorphicEncryptHandler--------------------------------2: " + privKeyStr);
                RSAPrivateKey privkey = (RSAPrivateKey)PaillierKeyPair.pemToPrivateKey((String)privKeyStr);
                LOGGER.info("HomomorphicEncryptHandler--------------------------------3: " + privkey);
                HomoVisitor.privateKey = privkey;
                argPacks.ret = this.getDecryptResult(homoDecryptConf, JsonUtil.parseObject((Object)argPacks.ret));
                if (null != argPacks.ret) {
                    return argPacks;
                }
                argPacks.ret = new JsonObject();
            }
            return argPacks;
        }
        catch (Exception e) {
            e.printStackTrace();
            return argPacks;
        }
    }

    private Object getDecryptResult(JsonElement homoDecryptConf, JsonElement data) {
        if (null == homoDecryptConf) {
            return data;
        }
        HomoVisitor visitor = new HomoVisitor(data);
        visitor.visit(homoDecryptConf);
        JsonElement root = visitor.get();
        LOGGER.info("HomoRetInvoke: " + root);
        return root;
    }
}

