/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.statistics.plugin.task;

import com.alibaba.datax.common.constant.PluginType;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.datax.core.statistics.plugin.task.AbstractTaskPluginCollector;
import com.alibaba.datax.core.statistics.plugin.task.util.DirtyRecord;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdoutPluginCollector
extends AbstractTaskPluginCollector {
    private static final Logger LOG = LoggerFactory.getLogger(StdoutPluginCollector.class);
    private static final int DEFAULT_MAX_DIRTYNUM = 128;
    private AtomicInteger maxLogNum = new AtomicInteger(0);
    private AtomicInteger currentLogNum = new AtomicInteger(0);

    public StdoutPluginCollector(Configuration configuration, Communication communication, PluginType type) {
        super(configuration, communication, type);
        this.maxLogNum = new AtomicInteger(configuration.getInt("core.statistics.collector.plugin.maxDirtyNumber", 128));
    }

    private String formatDirty(Record dirty, Throwable t, String msg) {
        HashMap<String, Object> msgGroup = new HashMap<String, Object>();
        msgGroup.put("type", super.getPluginType().toString());
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            msgGroup.put("message", msg);
        }
        if (null != t && StringUtils.isNotBlank((CharSequence)t.getMessage())) {
            msgGroup.put("exception", t.getMessage());
        }
        if (null != dirty) {
            msgGroup.put("record", DirtyRecord.asDirtyRecord(dirty).getColumns());
        }
        return JSON.toJSONString(msgGroup);
    }

    @Override
    public void collectDirtyRecord(Record dirtyRecord, Throwable t, String errorMessage) {
        int logNum = this.currentLogNum.getAndIncrement();
        if (logNum == 0 && t != null) {
            LOG.error("", t);
        }
        if (this.maxLogNum.intValue() < 0 || this.currentLogNum.intValue() < this.maxLogNum.intValue()) {
            LOG.error("\u810f\u6570\u636e: \n" + this.formatDirty(dirtyRecord, t, errorMessage));
        }
        super.collectDirtyRecord(dirtyRecord, t, errorMessage);
    }
}

