/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipFile;
import javax.script.ScriptException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.CFGraph;
import org.bdware.analysis.FrontCF;
import org.bdware.analysis.dynamic.NaiveDynamicTaintAnalysis;
import org.bdware.analysis.dynamic.TracedFile;
import org.bdware.analysis.example.MultiSourceTaintAnalysis;
import org.bdware.analysis.gas.Evaluates;
import org.bdware.analysis.gas.PPCount;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintCFG;
import org.bdware.analysis.taint.TaintResult;
import org.bdware.doip.audit.EndpointConfig;
import org.bdware.sc.ContractResult;
import org.bdware.sc.bean.Contract;
import org.bdware.sc.bean.ContractExecType;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.bean.FunctionDesp;
import org.bdware.sc.bean.ProjectConfig;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.boundry.Resources;
import org.bdware.sc.boundry.utils.RocksDBUtil;
import org.bdware.sc.boundry.utils.UtilRegistry;
import org.bdware.sc.compiler.YJSCompiler;
import org.bdware.sc.conn.ByteUtil;
import org.bdware.sc.conn.MsgHandler;
import org.bdware.sc.conn.ServiceServer;
import org.bdware.sc.conn.SocketGet;
import org.bdware.sc.engine.DesktopEngine;
import org.bdware.sc.engine.JSONTool;
import org.bdware.sc.engine.hook.AccessHandler;
import org.bdware.sc.engine.hook.ArgSchemaHandler;
import org.bdware.sc.engine.hook.ConfidentialHandler;
import org.bdware.sc.engine.hook.DOOPAfterExecHandler;
import org.bdware.sc.engine.hook.DOOPBeforeExecHandler;
import org.bdware.sc.engine.hook.HomomorphicDecryptHandler;
import org.bdware.sc.engine.hook.HomomorphicEncryptHandler;
import org.bdware.sc.engine.hook.MockTemplateHandler;
import org.bdware.sc.engine.hook.ObjToJsonHandler;
import org.bdware.sc.engine.hook.ResultSchemaHandler;
import org.bdware.sc.engine.hook.YJSAnnotation;
import org.bdware.sc.handler.ContractHandler;
import org.bdware.sc.handler.DOOPRequestHandler;
import org.bdware.sc.index.TimeSerialIndex;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.ContractNode;
import org.bdware.sc.node.ContractZipBundle;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.node.LogType;
import org.bdware.sc.node.Permission;
import org.bdware.sc.node.YjsType;
import org.bdware.sc.server.DoipClusterServer;
import org.bdware.sc.trace.ProgramPointCounter;
import org.bdware.sc.util.FileUtil;
import org.bdware.sc.util.HashUtil;
import org.bdware.sc.util.JsonUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ContractProcess {
    private static final byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static final byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(ContractProcess.class);
    public static ContractProcess instance;
    public final String cmi;
    public final ContractHandler handler;
    private final Set<String> cachedRequests = new HashSet<String>();
    public ServiceServer server;
    public DesktopEngine engine;
    String dbPath;
    String dir;
    Contract contract;
    ProjectConfig projectConfig;
    ContractNode cn;
    DumpTask dt;
    Map<String, String> isOpen = new HashMap<String, String>();
    long gasLimit = 0L;
    Map<String, String> logDetails = new HashMap<String, String>();
    String memorySet;
    HashMap<String, CFGraph> CFGmap = new HashMap();
    HashMap<String, Long> ppCountMap = new HashMap();
    List<String> function = new ArrayList<String>();
    private TimeSerialIndex logIndex;
    private RocksDBUtil edion;
    private String pid;
    public DOOPRequestHandler doopRequestHandler;

    public ContractProcess(int port, String cmi) {
        this.handler = new ContractHandler(this);
        this.server = new ServiceServer((MsgHandler)this.handler, port);
        this.cmi = cmi;
    }

    public static void main(String[] args) {
        int port = 1616;
        String cmi = "";
        InputStream pidInput = System.in;
        for (String arg : args) {
            if (arg.startsWith("-port")) {
                String portStr = arg.substring(6);
                if (!portStr.replaceAll("\\d+", "").isEmpty()) continue;
                port = Integer.parseInt(portStr);
                continue;
            }
            if (arg.startsWith("-cmi")) {
                cmi = arg.substring(5);
                continue;
            }
            if (arg.startsWith("-debug")) {
                LOGGER.info("log level: debug");
                Configurator.setRootLevel((Level)Level.DEBUG);
                continue;
            }
            if (!arg.startsWith("-disablePID")) continue;
            pidInput = new ByteArrayInputStream("CP PID:-1".getBytes(StandardCharsets.UTF_8));
        }
        Scanner sc = new Scanner(pidInput);
        while (sc.hasNextLine()) {
            String str = sc.nextLine();
            LOGGER.info("[CP From STDIN] " + str);
            if (!str.contains("CP PID:")) continue;
            int pid = Integer.parseInt(str.replace("CP PID:", ""));
            System.setProperty("io.netty.processId", pid + "");
            LOGGER.info("[CP SET PID DONE] " + str);
            break;
        }
        LOGGER.info("[Create CP]");
        instance = new ContractProcess(port, cmi);
    }

    public static boolean isArchiveFile(File file) {
        if (null == file) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        boolean isArchive = false;
        try (FileInputStream input = new FileInputStream(file);){
            byte[] buffer = new byte[4];
            int length = ((InputStream)input).read(buffer, 0, 4);
            if (length == 4) {
                isArchive = Arrays.equals(ZIP_HEADER_1, buffer) || Arrays.equals(ZIP_HEADER_2, buffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isArchive;
    }

    public static long toByte(String size) {
        String[] unit = new String[]{"B", "KB", "MB", "GB", "TB"};
        String[] a = size.split(" ");
        double r = Double.parseDouble(a[0]);
        if (a[1].equals(unit[1])) {
            r = Math.pow(1024.0, 1.0);
        } else if (a[1].equals(unit[2])) {
            r = Math.pow(1024.0, 2.0);
        } else if (a[1].equals(unit[3])) {
            r = Math.pow(1024.0, 3.0);
        } else if (a[1].equals(unit[4])) {
            r = Math.pow(1024.0, 4.0);
        }
        long res = (long)r;
        return res;
    }

    public static String getContractDir() {
        if (null != instance && null != ContractProcess.instance.cn && null != ContractProcess.instance.cn.getContractName()) {
            return ContractProcess.instance.cn.getContractName();
        }
        return "debug";
    }

    public String getContractName() {
        return this.cn.getContractName();
    }

    public String staticVerify(Contract c) {
        LOGGER.info("ccccc--cccc" + JsonUtil.toJson((Object)c) + "\n" + c.getPublicKey());
        ContractResult ret = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive(""));
        try {
            ContractNode cn;
            String script = c.getScriptStr();
            YJSCompiler compiler = new YJSCompiler();
            if (script.startsWith("/")) {
                ZipFile zf = new ZipFile(script);
                ContractZipBundle czb = compiler.compile(zf);
                cn = czb.mergeContractNode();
            } else {
                cn = compiler.compile(new ByteArrayInputStream(script.getBytes()), "contract_main.yjs");
            }
            DesktopEngine engine = new DesktopEngine();
            engine.loadContract(c, cn, ret.isInsnLimit);
            Map<String, byte[]> clzs = engine.dumpClass();
            HashMap<String, MethodNode> methods = new HashMap<String, MethodNode>();
            for (byte[] clz : clzs.values()) {
                ClassNode classNode = new ClassNode();
                ClassReader cr = new ClassReader(clz);
                cr.accept((ClassVisitor)classNode, 8);
                for (MethodNode mn : classNode.methods) {
                    methods.put(mn.name, mn);
                }
            }
            JsonObject result = new JsonObject();
            for (FunctionNode fn : cn.getFunctions()) {
                System.out.println("[ContractManager] verify:" + fn.functionName);
                MethodNode mn = (MethodNode)methods.get(fn.functionName);
                if (mn == null) continue;
                System.out.println("[ContractManager] getMethodNode, verify:" + fn.functionName);
                TaintResult.nLocals = mn.maxLocals;
                TaintResult.nStack = mn.maxStack;
                TaintCFG cfg = new TaintCFG(mn);
                TaintResult.printer.setLabelOrder(cfg.getLabelOrder());
                try {
                    MultiSourceTaintAnalysis analysis = new MultiSourceTaintAnalysis(cfg);
                    analysis.analysis();
                    TaintBB bb = cfg.getLastBlock();
                    if (bb != null) {
                        result.addProperty(fn.functionName, bb.getResultWithTaintBit());
                    }
                    System.out.println("[ContractManager] verifyDone:" + fn.functionName);
                }
                catch (Exception e) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(bo));
                    result.addProperty(fn.functionName, bo.toString());
                    e.printStackTrace();
                }
            }
            ret.status = ContractResult.Status.Success;
            ret.result = result;
        }
        catch (Exception e) {
            ret.status = ContractResult.Status.Exception;
            JsonObject a = new JsonObject();
            a.addProperty("info", e.getMessage());
            ret.result = a;
            e.printStackTrace();
        }
        return JsonUtil.toJson((Object)ret);
    }

    public String getControlFlow(Contract c) {
        try {
            c.setPublicKey("temporypubkey");
            long start = System.currentTimeMillis();
            DesktopEngine engine = new DesktopEngine();
            YJSCompiler compiler = new YJSCompiler();
            ContractNode cn = compiler.compile(new ZipFile(c.getScriptStr())).mergeContractNode();
            engine.loadContract(c, cn, false);
            Map<String, byte[]> clzs = engine.dumpClass();
            HashMap<String, MethodNode> methods = new HashMap<String, MethodNode>();
            for (byte[] byArray : clzs.values()) {
                ClassNode classNode = new ClassNode();
                ClassReader cr = new ClassReader(byArray);
                cr.accept((ClassVisitor)classNode, 8);
                for (MethodNode mn : classNode.methods) {
                    methods.put(mn.name, mn);
                }
            }
            HashMap<String, FrontCF> result = new HashMap<String, FrontCF>();
            for (FunctionNode fn : cn.getFunctions()) {
                System.out.println("[ContractManager] getCFG:" + fn.functionName);
                MethodNode mn = (MethodNode)methods.get(fn.functionName);
                if (mn == null) continue;
                TaintResult.nLocals = mn.maxLocals;
                TaintResult.nStack = mn.maxStack;
                TaintCFG cfg = new TaintCFG(mn);
                TaintResult.printer.setLabelOrder(cfg.getLabelOrder());
                MultiSourceTaintAnalysis analysis = new MultiSourceTaintAnalysis(cfg);
                analysis.analysis();
                Map map = MultiSourceTaintAnalysis.depAnalysis((TaintCFG)cfg);
                FrontCF frontCF = new FrontCF((CFGraph)cfg);
                String[] data = fn.plainText().split("\n");
                for (int i = 0; i < cfg.getBasicBlockSize(); ++i) {
                    BasicBlock bb = cfg.getBasicBlockAt(i);
                    String decompiled = "";
                    if (bb.lineNum - 1 < data.length && bb.lineNum > 0) {
                        decompiled = data[bb.lineNum - 1];
                    }
                    List ids = (List)map.get(i);
                    frontCF.addBB(bb, decompiled, ids, cfg);
                    Set suc = cfg.getSucBlocks(bb);
                    for (BasicBlock sucBB : suc) {
                        frontCF.addEdge(bb, sucBB);
                    }
                }
                result.put(fn.functionName, frontCF);
            }
            System.out.println("Test:" + JsonUtil.toJson(result));
            long l = System.currentTimeMillis();
            System.out.println(l - start);
            return JsonUtil.toJson(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{\"status\":\"failed\"}";
        }
    }

    private void logCode() {
        Map<String, byte[]> clzs = this.engine.dumpClass();
        HashMap<String, String> clzs2 = new HashMap<String, String>();
        for (String k : clzs.keySet()) {
            String v = ByteUtil.encodeBASE64((byte[])clzs.get(k));
            clzs2.put(k, v);
        }
        String code = JsonUtil.toJson(clzs2);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("contract-bytecode", code);
        map1.put("contractID", this.contract.getID());
        map1.put("contractType", this.contract.getType().name());
        map1.put("operation", "startContract");
        map1.put("timestamp", System.currentTimeMillis() + "");
        this.writeContractDB(map1);
    }

    public String setDesktopPermission(String isChanged) {
        try {
            System.out.println("permission" + isChanged);
            String[] pmList = isChanged.split(",");
            String yancloud_desktop = "";
            this.isOpen.put(pmList[0], pmList[1]);
            yancloud_desktop = yancloud_desktop + UtilRegistry.getInitStr(pmList[0], pmList[1].equals("open"));
            this.engine.getNashornEngine().getContext().setAttribute("javax.script.filename", yancloud_desktop, 100);
            this.engine.getNashornEngine().eval(yancloud_desktop);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String getMemorySet() {
        if (null == this.memorySet) {
            return "";
        }
        return this.memorySet;
    }

    public String getLogType(String funName) {
        return this.logDetails.get(funName);
    }

    public String verifyOracleAndContractPermission(Contract contract) {
        if (this.cn.getYjsType() == YjsType.Oracle && contract.getType() != ContractExecType.Sole && contract.getType() != ContractExecType.Sharding) {
            LOGGER.info("Oracle only support Sole ContractType!");
            return JsonUtil.toJson((Object)new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("Oracle only support Sole ContractType!")));
        }
        if (this.cn.getYjsType() == YjsType.Contract) {
            for (Permission per : this.cn.getPermission()) {
                if (per != Permission.SQL && per != Permission.Http && per != Permission.RocksDB && per != Permission.MongoDB) continue;
                LOGGER.debug("Contract can not have permissions of IO!");
                return JsonUtil.toJson((Object)new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("Contract can not have permissions of IO|")));
            }
        }
        return "";
    }

    public String setMembers(List<String> members) {
        JavaScriptEntry.members = members;
        if (members != null) {
            return members.size() + "";
        }
        return "0";
    }

    public String setContractBundle(Contract contract) {
        try {
            this.contract = contract;
            JavaScriptEntry.random = new Random();
            JavaScriptEntry.invokeID = 0L;
            JavaScriptEntry.random.setSeed(Integer.parseInt(contract.getID()));
            JavaScriptEntry.numOfCopies = this.contract.getNumOfCopies();
            JavaScriptEntry.shardingID = this.contract.getShardingId();
            String zipPath = contract.getScriptStr();
            if (ContractProcess.isArchiveFile(new File(zipPath))) {
                ZipFile zf = new ZipFile(zipPath);
                ContractZipBundle zipBundle = new YJSCompiler().compile(zf);
                this.cn = zipBundle.mergeContractNode();
                this.injectHandlers();
                this.contract.setYjsType(this.cn.getYjsType());
                this.memorySet = this.cn.memorySet;
                this.contract.sourcePath = zipBundle.getManifest().sourcePath;
                LOGGER.debug("check sourcePath\n\tin-contract=" + this.contract.sourcePath + "\n\tin-manifest=" + zipBundle.getManifest().sourcePath);
                String ver = this.verifyOracleAndContractPermission(contract);
                if (!ver.isEmpty()) {
                    return ver;
                }
                for (Permission per : this.cn.getPermission()) {
                    this.isOpen.put(per.name(), "open");
                }
                this.handleLog();
                this.engine = new DesktopEngine(zipBundle.getManifest(), zipPath, contract);
                this.engine.loadJar(zf);
                this.engine.registerResource(new Resources(zf, this.engine.getClassLoad()));
                ContractResult result = this.engine.loadContract(contract, this.cn, this.cn.getInstrumentBranch());
                JsonObject jo = new JsonObject();
                ContractResult onCreate = this.invokeOnCreate(contract.getCreateParam());
                jo.add("onCreate", JsonUtil.parseObject((Object)onCreate));
                jo.add("loadContract", JsonUtil.parseObject((Object)result));
                jo.addProperty("status", result.status.merge(onCreate.status).toString());
                LOGGER.debug("result: " + jo.toString());
                if (this.cn.hasDoipModule()) {
                    this.updateRepoInfo(contract.getCreateParam());
                    this.invokeOnStartingDoipServer(this.cn, contract.getCreateParam(), jo);
                }
                return jo.toString();
            }
            contract.setScript(FileUtil.getFileContent((String)zipPath));
            return this.setContract(contract);
        }
        catch (JsonSyntaxException | MalformedJsonException e) {
            return JsonUtil.toJson((Object)new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("parse manifest.json error, not json format!")));
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            return JsonUtil.toJson((Object)new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive(bo.toString())));
        }
    }

    private void injectHandlers() throws Exception {
        if (!this.contract.isDebug()) {
            for (FunctionNode fun : this.cn.getFunctions()) {
                if (!fun.isExport()) continue;
                fun.appendBeforeInvokeHandler((AnnotationHook)new MockTemplateHandler());
            }
        }
        Object doopBeforeExecHandler = null;
        Object doopAfterExecHandler = null;
        this.doopRequestHandler = null;
        for (FunctionNode fun : this.cn.getFunctions()) {
            ArgSchemaHandler argSchemaHandler;
            if (fun.isConfidential()) {
                fun.appendBeforeInvokeHandler((AnnotationHook)new ConfidentialHandler(fun));
            }
            if ((argSchemaHandler = this.createHandlerIfExist(fun, ArgSchemaHandler.class)) != null) {
                fun.appendBeforeInvokeHandler((AnnotationHook)argSchemaHandler);
            }
            if (fun.isExport()) {
                AccessHandler accessHandler = this.createHandlerIfExist(fun, AccessHandler.class);
                if (accessHandler != null) {
                    fun.appendBeforeInvokeHandler((AnnotationHook)accessHandler);
                }
                fun.appendAfterInvokeHandler((AnnotationHook)new ObjToJsonHandler());
                ResultSchemaHandler resultSchemaHandler = this.createHandlerIfExist(fun, ResultSchemaHandler.class);
                if (resultSchemaHandler != null) {
                    fun.appendAfterInvokeHandler((AnnotationHook)resultSchemaHandler);
                }
            }
            if (fun.isHomomorphicEncrypt()) {
                LOGGER.info("injectHandlers--------------------------------1");
                fun.appendAfterInvokeHandler((AnnotationHook)new HomomorphicEncryptHandler(fun));
            }
            if (fun.isHomomorphicDecrypt()) {
                fun.appendAfterInvokeHandler((AnnotationHook)new HomomorphicDecryptHandler(fun));
            }
            if (!fun.isDoipOperation()) continue;
            if (this.doopRequestHandler == null) {
                this.doopRequestHandler = new DOOPRequestHandler();
            }
            fun.appendBeforeInvokeHandler((AnnotationHook)new DOOPBeforeExecHandler(fun.getDoipOperationInfo().operation));
            fun.appendAfterInvokeHandler((AnnotationHook)new DOOPAfterExecHandler(fun.getDoipOperationInfo().operation));
            this.doopRequestHandler.addDoipOperation(fun);
        }
    }

    <T extends AnnotationHook> T createHandlerIfExist(FunctionNode function, Class<T> clz) {
        YJSAnnotation annotation = clz.getAnnotation(YJSAnnotation.class);
        if (annotation == null) {
            return null;
        }
        try {
            AnnotationNode node = function.getAnnotation(annotation.name());
            if (node == null) {
                return null;
            }
            Method m = clz.getDeclaredMethod("fromAnnotationNode", FunctionNode.class, AnnotationNode.class);
            AnnotationHook result = (AnnotationHook)m.invoke(null, function, node);
            return (T)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String changeDumpPeriod(String period) {
        System.out.println("[ContractProcess] period" + period);
        this.startAutoDump();
        return "success";
    }

    public String getDumpPeriod() {
        return this.projectConfig.getDumpPeriod();
    }

    public String setContract(Contract contract) {
        try {
            JavaScriptEntry.random = new Random();
            JavaScriptEntry.invokeID = 0L;
            JavaScriptEntry.random.setSeed(Integer.parseInt(contract.getID()));
            JavaScriptEntry.numOfCopies = contract.getNumOfCopies();
            this.engine = new DesktopEngine();
            this.contract = contract;
            this.contract.sourcePath = "script_" + System.currentTimeMillis();
            YJSCompiler compiler = new YJSCompiler();
            this.cn = compiler.compile(contract.getScript(), null);
            contract.setYjsType(this.cn.getYjsType());
            this.injectHandlers();
            String ver = this.verifyOracleAndContractPermission(contract);
            if (!ver.equals("")) {
                return ver;
            }
            this.handleLog();
            LOGGER.info("load script, contract:" + JsonUtil.toJson((Object)contract.getScriptStr()));
            LOGGER.info("load cn:" + JsonUtil.toJson((Object)this.cn));
            ContractResult ret = this.engine.loadContract(contract, this.cn, this.cn.getInstrumentBranch());
            ContractResult onCreate = this.invokeOnCreate(contract.getCreateParam());
            JsonObject jo = new JsonObject();
            jo.add("onCreate", JsonUtil.parseObject((Object)onCreate));
            jo.add("loadContract", JsonUtil.parseObject((Object)ret));
            jo.addProperty("status", ret.status.merge(onCreate.status).toString());
            LOGGER.debug("result: " + jo.toString());
            if (this.cn.getYjsType() == YjsType.DoipModule) {
                this.updateRepoInfo(contract.getCreateParam());
                this.invokeOnStartingDoipServer(this.cn, contract.getCreateParam(), jo);
            }
            return jo.toString();
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            return JsonUtil.toJson((Object)new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive(bo.toString())));
        }
    }

    public void updateRepoInfo(JsonElement arg) throws Exception {
        if (JavaScriptEntry.shardingID == -1) {
            DoipClusterServer server = DoipClusterServer.getDOOPServerInstance();
            if (server == null) {
                JsonElement routerInfo;
                JsonObject createParams = arg.getAsJsonObject();
                if (createParams.has("router")) {
                    routerInfo = createParams.get("router");
                    if (!routerInfo.isJsonObject()) {
                        throw new Exception("Provide wrong router info in create params to DoipModule");
                    }
                } else {
                    throw new Exception("DoipModule should provide router info in create params");
                }
                EndpointConfig endpointConfig = JsonUtil.GSON.fromJson((JsonElement)routerInfo.getAsJsonObject(), EndpointConfig.class);
                DoipClusterServer.createDOOPServerInstance(endpointConfig);
                server = DoipClusterServer.getDOOPServerInstance();
            }
            server.updateRepoInfo(this.contract, this.cn);
        }
    }

    public void invokeOnStartingDoipServer(ContractNode cn, JsonElement arg, JsonObject returnValue) {
        ContractRequest onStartingDoipServer = new ContractRequest();
        onStartingDoipServer.setAction("onServerStart");
        if (arg == null) {
            arg = this.engine != null && this.engine.getManifest() != null && this.engine.getManifest().createParam != null ? this.engine.getManifest().createParam : new JsonPrimitive("");
        }
        onStartingDoipServer.setArg(arg);
        LOGGER.debug("invoke onStartingDoipServer, param:" + onStartingDoipServer.getArg().toString());
        onStartingDoipServer.setRequester(this.contract.getOwner());
        FunctionNode funNode = cn.getFunction("onServerStart");
        try {
            JsonElement onStartingDoipServerRes = this.invoke((ContractRequest)onStartingDoipServer, (FunctionNode)funNode).result;
            returnValue.add("doipModuleStartResult", onStartingDoipServerRes);
            int startPort = ContractProcess.instance.server.getPort() + 1;
            if (arg.isJsonObject() && arg.getAsJsonObject().has("doipStartPort")) {
                startPort = arg.getAsJsonObject().get("doipStartPort").getAsInt();
            }
            LOGGER.info("Fetch the onStartingDoipServerRes from router successfully, the result is " + onStartingDoipServerRes);
            int doipListenPort = DoipClusterServer.startDoipServer(startPort, onStartingDoipServerRes);
            returnValue.addProperty("doipListenPort", doipListenPort);
            this.contract.setDoipPort(doipListenPort);
            returnValue.addProperty("doipStartPort", startPort);
        }
        catch (Exception e) {
            LOGGER.error("DoipLocalSingleton cannot starts properly, plz check the onServerStart function");
            e.printStackTrace();
        }
        funNode = cn.getFunction("onInitSharableVars");
        if (funNode != null) {
            ContractRequest requestForInitVar = new ContractRequest();
            requestForInitVar.setAction("onInitSharableVars");
            requestForInitVar.setArg(onStartingDoipServer.getArg());
            requestForInitVar.setRequester(onStartingDoipServer.getRequester());
            JsonElement onInitSharableVars = this.invoke((ContractRequest)requestForInitVar, (FunctionNode)funNode).result;
            returnValue.add("onInitSharableVars", onInitSharableVars);
        }
    }

    private void handleLog() {
        for (FunctionNode fun : this.cn.getFunctions()) {
            StringBuilder detail = new StringBuilder();
            for (LogType type : fun.getLogTypes()) {
                switch (type) {
                    case Arg: {
                        detail.append("Arg;");
                        break;
                    }
                    case Branch: {
                        detail.append("Branch;");
                        break;
                    }
                    case Result: {
                        detail.append("Result;");
                        break;
                    }
                }
            }
            if (fun.getLogToBDContract()) {
                detail.append("bdcontract;");
            }
            if (fun.getLogToNamedLedger()) {
                for (String str : fun.getLedgerNames()) {
                    detail.append("bdledger:").append(str).append(";");
                }
            }
            this.logDetails.put(fun.functionName, detail.toString());
        }
    }

    public String setDBInfo(String path) {
        this.dbPath = path;
        return "success";
    }

    public long getUsedMemory(String arg) {
        Runtime r = Runtime.getRuntime();
        return r.totalMemory() - r.freeMemory();
    }

    private ContractResult invokeOnCreate(JsonElement arg) {
        long start = System.currentTimeMillis();
        this.logIndex = new TimeSerialIndex("./ContractDB/" + this.cn.getContractName() + ".index");
        LOGGER.debug("timeSerialIndex: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.edion = RocksDBUtil.loadDB("defaultLog", false);
        LOGGER.debug("create RocksDB: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.engine.redirectTracePS(new Logger((OutputStream)new ByteArrayOutputStream(), this));
        if (null != this.cn.getLogTypes() && this.cn.getLogTypes().contains(LogType.Code)) {
            this.logCode();
        }
        JavaScriptEntry.setSM2KeyPair(this.contract.getPublicKey(), this.contract.getKey());
        if (null != this.contract.getAuthInfoPersistDOI() && !this.contract.getAuthInfoPersistDOI().isEmpty()) {
            JavaScriptEntry.authInfoPersistDOI = this.contract.getAuthInfoPersistDOI();
        }
        JavaScriptEntry.isDebug = this.contract.isDebug();
        ContractRequest onCreate = new ContractRequest();
        onCreate.setAction("onCreate");
        if (arg == null) {
            arg = this.engine != null && this.engine.getManifest() != null && this.engine.getManifest().createParam != null ? this.engine.getManifest().createParam : new JsonPrimitive("");
        }
        onCreate.setArg(arg);
        LOGGER.debug("invoke onCreate, param:" + onCreate.getArg().toString());
        onCreate.setRequester(this.contract.getOwner());
        FunctionNode funNode = this.cn.getFunction("onCreate");
        return this.invoke(onCreate, funNode);
    }

    public void resetContractName(String name) {
        if (name != null) {
            this.cn.resetContractName(name);
        }
    }

    private ContractResult invokeOnRecover(JsonElement arg) {
        ContractRequest onRecover = new ContractRequest();
        onRecover.setAction("onRecover");
        if (arg == null) {
            onRecover.setArg("null");
        } else {
            onRecover.setArg(arg);
        }
        onRecover.setRequester(this.contract.getOwner());
        FunctionNode funNode = this.cn.getFunction("onRecover");
        return this.invoke(onRecover, funNode);
    }

    private ContractResult invoke(ContractRequest onRecover, FunctionNode funNode) {
        if (funNode != null) {
            funNode.setIsExport(true);
            ContractResult result = this.engine.executeContract(onRecover);
            funNode.setIsExport(false);
            this.engine.getTracePS().clean();
            return result;
        }
        return new ContractResult(ContractResult.Status.Success, (JsonElement)new JsonPrimitive("no funNode found"));
    }

    public boolean isSigRequired() {
        return this.cn.sigRequired;
    }

    public String requestLog(long offset, int size) {
        List hashes = this.logIndex.request(offset, size);
        ArrayList<Map> jo = new ArrayList<Map>();
        TypeToken<Map<String, String>> token = new TypeToken<Map<String, String>>(){};
        for (Long hash : hashes) {
            try {
                Map obj = (Map)JsonUtil.fromJson((String)this.edion.get(hash.toString()), (Type)token.getType());
                jo.add(obj);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
        return JsonUtil.toJson(jo);
    }

    public String requestLast(int count) {
        List hashes = this.logIndex.requestLast(count);
        ArrayList<Map> jo = new ArrayList<Map>();
        TypeToken<Map<String, String>> token = new TypeToken<Map<String, String>>(){};
        for (Long hash : hashes) {
            try {
                String log = this.edion.get(hash.toString());
                if (null == log || 0 == log.length()) continue;
                Map obj = (Map)JsonUtil.fromJson((String)log, (Type)token.getType());
                if (obj == null) {
                    System.out.println("[ContractProcess] requestLast, parseJsonError:" + log + "==");
                    continue;
                }
                obj.put("hash", hash + "");
                jo.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return JsonUtil.toJson(jo);
    }

    public long logSize() {
        return this.logIndex.size();
    }

    public String executeFunctionWithoutLimit(String arg) {
        try {
            JsonObject body = JsonUtil.parseString((String)arg).getAsJsonObject();
            String funcName = body.get("funcName").getAsString();
            JsonArray arr = body.getAsJsonArray("funcArgs");
            Object[] funcArgs = new Object[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                funcArgs[i] = JSONTool.convertJsonElementToMirror(arr.get(i));
            }
            Object result = this.engine.invokeFunction(funcName, funcArgs);
            result = JSONTool.convertMirrorToJson(result);
            return JsonUtil.toJson((Object)result);
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            return bo.toString();
        }
    }

    public String executeContract(String arg) {
        ContractRequest request;
        try {
            request = (ContractRequest)JsonUtil.fromJson((String)arg, ContractRequest.class);
        }
        catch (Exception ignored) {
            ContractResult result = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("Illegal Arguments!"));
            return JsonUtil.toJson((Object)result);
        }
        String reqID = request.getRequestID();
        if (this.cachedRequests.contains(reqID)) {
            LOGGER.info("[Hit Cache]:" + reqID);
            try {
                String cachedResult = this.edion.get(reqID);
                if (cachedResult != null && !cachedResult.isEmpty()) {
                    return cachedResult;
                }
            }
            catch (Exception cachedResult) {
                // empty catch block
            }
        }
        try {
            ContractResult result;
            Logger previous;
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            if (request.withDynamicAnalysis) {
                previous = this.engine.getTracePS();
                this.engine.redirectTracePS(new Logger((OutputStream)bo, this));
                result = this.engine.executeContract(request);
                result.analysis = bo.toString();
                System.out.println("[ContractProcess] result.analysis = " + result.analysis);
                this.engine.redirectTracePS(previous);
                this.dynamicAnalysis(request, result);
            } else if (request.withEvaluatesAnalysis) {
                previous = this.engine.getTracePS();
                System.out.println("[size:]" + this.function.size());
                System.out.println("[action index]:" + this.function.indexOf(request.getAction()));
                System.out.println("[InsnFeeValue]" + request.getValue());
                System.out.println("[InsnFeeLimit]" + this.gasLimit);
                int functionIndex = this.function.indexOf(request.getAction());
                if (this.ppCountMap == null || this.ppCountMap.isEmpty()) {
                    System.out.println("\u6ca1\u6709\u63d0\u524d\u8fdb\u884c\u9884\u4f30");
                    this.evaluatesAnalysis(request.getAction());
                }
                this.engine.redirectTracePS(new ProgramPointCounter(bo, this, this.gasLimit, functionIndex, request.getValue(), 0L, request.getAction(), this.ppCountMap));
                result = this.engine.executeContract(request);
                result.analysis = bo.toString();
                this.engine.redirectTracePS(previous);
            } else {
                previous = this.engine.getTracePS();
                this.engine.redirectTracePS(new Logger((OutputStream)bo, this));
                result = this.engine.executeContract(request);
                this.engine.redirectTracePS(previous);
            }
            String ret = JsonUtil.toJson((Object)result);
            if (reqID != null && reqID.endsWith("_mul")) {
                this.cachedRequests.add(reqID);
                this.edion.put(reqID, ret);
            }
            return ret;
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            return bo.toString();
        }
    }

    public String evaluatesAnalysis(String getFunction) {
        Map<String, byte[]> clzs = this.engine.dumpClass();
        HashMap<String, MethodNode> methods = new HashMap<String, MethodNode>();
        for (byte[] clz : clzs.values()) {
            ClassNode classNode = new ClassNode();
            ClassReader cr = new ClassReader(clz);
            cr.accept((ClassVisitor)classNode, 8);
            for (MethodNode mn : classNode.methods) {
                methods.put(mn.name, mn);
            }
        }
        int flag = 0;
        for (String string : this.function) {
            MethodNode mn = (MethodNode)methods.get(string);
            if (mn == null) continue;
            CFGraph cfg = new CFGraph(mn){

                public BasicBlock getBasicBlock(int id) {
                    return new BasicBlock(id);
                }
            };
            this.CFGmap.put(string, cfg);
            PPCount countFee = new PPCount(cfg, flag);
            BasicBlock bb = cfg.getBasicBlockAt(0);
            countFee.dfs(cfg, bb);
            Evaluates feEvaluates = new Evaluates();
            feEvaluates.getGas(PPCount.branchCount);
            feEvaluates.getInsnGas(PPCount.ppMap);
            PPCount.countFunction((String)string, (HashMap)Evaluates.map);
            this.ppCountMap = Evaluates.map;
            System.out.println("+++++++" + PPCount.ppMap);
            ++flag;
        }
        for (Map.Entry entry : PPCount.functionSumGas.entrySet()) {
            if (((String)entry.getKey()).contains(getFunction) && ((String)entry.getKey()).contains("true")) {
                System.out.println("[\u5408\u7ea6\u65b9\u6cd5pub\u4e2d\u6761\u4ef6\u5faa\u73af\u4e3atrue\u65f6\uff1a]" + entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).contains(getFunction) && ((String)entry.getKey()).contains("false")) {
                System.out.println("[\u5408\u7ea6\u65b9\u6cd5pub\u4e2d\u6761\u4ef6\u5faa\u73af\u4e3afalse\u65f6\uff1a]" + entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).contains(getFunction)) continue;
            System.out.println("[\u5408\u7ea6\u65b9\u6cd5pub\u4e2d\u5176\u4ed6\u8bed\u53e5\u6d88\u8017\uff1a]" + entry.getValue());
        }
        return PPCount.functionSumGas.toString();
    }

    public void dynamicAnalysis(ContractRequest ac, ContractResult result) {
        Map<String, byte[]> classes = this.engine.dumpClass();
        HashMap<String, MethodNode> methods = new HashMap<String, MethodNode>();
        for (byte[] clz : classes.values()) {
            ClassNode classNode = new ClassNode();
            ClassReader cr = new ClassReader(clz);
            System.out.print("[cr:]" + cr);
            cr.accept((ClassVisitor)classNode, 8);
            for (MethodNode mn : classNode.methods) {
                methods.put(mn.name, mn);
            }
        }
        MethodNode mn = (MethodNode)methods.get(ac.getAction());
        if (mn != null) {
            TaintResult.nLocals = mn.maxLocals;
            TaintResult.nStack = mn.maxStack;
            TaintCFG cfg = new TaintCFG(mn);
            String trace = result.analysis;
            System.out.println("TraceFile:\n" + trace);
            System.out.println("TraceFile\u7ed3\u675f=====================================");
            System.out.println("\u6253\u5370cfg\u56fe=====================================");
            cfg.printSelf();
            System.out.println("\u6253\u5370cfg\u56fe=====================================");
            TracedFile tf = new TracedFile((InputStream)new ByteArrayInputStream(trace.getBytes()));
            TaintResult.printer.setLabelOrder(cfg.getLabelOrder());
            NaiveDynamicTaintAnalysis analysis = new NaiveDynamicTaintAnalysis(cfg, tf);
            analysis.analysis();
            TaintBB bb = cfg.getLastBlock();
            result.analysis = bb.getResultWithTaintBit();
            System.out.println("[ContractProcess] dynamically verify: " + ac.getAction() + "-->" + result.analysis);
        }
    }

    public String registerMangerPort(String arg) {
        JavaScriptEntry.get = new SocketGet("127.0.0.1", Integer.parseInt(arg));
        return "success";
    }

    public void subscribe(String functionName) {
        this.cn.getFunction(functionName).setHandler(true);
        this.cn.getFunction("_preSub").setHandler(true);
    }

    public void unSubscribe(String functionName) {
        this.cn.getFunction(functionName).setHandler(false);
    }

    public boolean checkSub() {
        return !JavaScriptEntry.topic_handlers.isEmpty();
    }

    public void beforeSuicide() {
    }

    public String redo(String path) {
        return this.engine.syncUtil.redo(path);
    }

    public String getMemoryDump(String path) {
        return this.engine.syncUtil.dumpMemory(path, this.contract.getStateful());
    }

    public String getJSERandomCur() {
        return JavaScriptEntry.random.toString();
    }

    public String loadMemoryDump(String path) {
        String str = this.engine.syncUtil.loadMemoryDump(path, this.contract.getStateful());
        this.invokeOnRecover(this.contract.getCreateParam());
        return str;
    }

    public String showPermission() {
        return JsonUtil.toJson(this.isOpen);
    }

    public String getStorage() {
        Runtime run = Runtime.getRuntime();
        long mem = run.totalMemory() - run.freeMemory();
        System.out.println("[ContractProcess] getStorage = " + ByteUtil.byteTo((long)mem));
        return ByteUtil.byteTo((long)mem);
    }

    public void writeContractDB(Map<String, String> data) {
        String path = this.dbPath;
        if (path == null) {
            return;
        }
        try {
            String result = JsonUtil.toJson(data);
            long hash = HashUtil.hashStr2Long((String)result);
            this.logIndex.index(hash);
            this.edion.put(String.valueOf(hash), result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() {
    }

    public String getDeclaredEvents() {
        return JsonUtil.toJson((Object)this.cn.events);
    }

    public String getAnnotations() {
        return JsonUtil.toJson((Object)this.cn.annotations);
    }

    public String getExportedFunctions() {
        ArrayList<FunctionDesp> ret = new ArrayList<FunctionDesp>();
        for (FunctionNode fn : this.cn.getFunctions()) {
            if (!fn.isExport() || fn.functionName.equals("onCreate")) continue;
            this.function.add(fn.functionName);
            FunctionDesp desp = new FunctionDesp(fn.functionName, fn.annotations, fn.getRouteInfo(), fn.getJoinInfo(), fn.isView());
            ret.add(desp);
        }
        return JsonUtil.toJson(ret);
    }

    public Contract getContract() {
        return this.contract;
    }

    public String getPID() {
        return this.pid;
    }

    public void setPID(String pid) {
        this.pid = pid;
    }

    public String startAutoDump() {
        String dumpPeriod = this.projectConfig.getDumpPeriod();
        System.out.println("[ContractProcess] startAutoDump : " + this.cn.getContractName() + " period = " + dumpPeriod);
        String status = "startAutoDump status 0";
        if (null != this.dt) {
            if (null == dumpPeriod || dumpPeriod.isEmpty()) {
                this.dt.cancel();
                status = "startAutoDump status 1";
            } else {
                this.dt.cancel();
                Timer timer = new Timer();
                this.dt = new DumpTask();
                timer.schedule((TimerTask)this.dt, new Date(), Long.parseLong(dumpPeriod));
                status = "startAutoDump status 2";
            }
        } else if (dumpPeriod != null && !dumpPeriod.equals("")) {
            Timer timer = new Timer();
            this.dt = new DumpTask();
            timer.schedule((TimerTask)this.dt, new Date(), Long.parseLong(dumpPeriod));
            status = "startAutoDump status 3";
        }
        LOGGER.debug("[ContractProcess] status : " + status);
        return status;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String s) {
        this.dir = s + "/ADSPDir/" + this.contract.getID() + "/";
        this.engine.syncUtil.setDir(this.dir);
    }

    public boolean isDebug() {
        return this.contract.isDebug();
    }

    public String getCachedTransRecords(String startSeq) {
        int start = Integer.parseInt(startSeq);
        if (this.engine.syncUtil != null && this.engine.syncUtil.transRecordUtil != null) {
            return this.engine.syncUtil.transRecordUtil.getCachedTransRecords(start);
        }
        return "";
    }

    public void clearSyncFiles(String arg) {
        if (this.engine.syncUtil == null) {
            LOGGER.debug("syncUtil is null, can not clear all sync files!");
            return;
        }
        this.engine.syncUtil.clearAllFiles();
    }

    public String getStateful() {
        return this.contract.getStateful() + "";
    }

    public void startSync() {
        this.engine.syncUtil.setStartFlag(true);
    }

    public void setCRFile(String fileName) {
        this.engine.syncUtil.setCRFile(fileName);
    }

    public void stopSync() {
        this.engine.syncUtil.setStartFlag(false);
    }

    public String changeDebugFlag(Boolean b) {
        this.contract.setDebug(b.booleanValue());
        JavaScriptEntry.isDebug = b;
        return "success";
    }

    public String parseYpkPermissions(String ypkPath) {
        YJSCompiler compiler = new YJSCompiler();
        try {
            ContractZipBundle bundle = compiler.compile(new ZipFile(ypkPath));
            ContractNode contractNode = bundle.mergeContractNode();
            return JsonUtil.toJson((Object)contractNode.getPermission());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "[]";
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(String args) {
        this.projectConfig = (ProjectConfig)JsonUtil.fromJson((String)args, ProjectConfig.class);
        String period = this.projectConfig.getDumpPeriod();
        if (period != null && period.length() > 0) {
            this.changeDumpPeriod(period);
        }
    }

    public String getDependentContracts() {
        return JsonUtil.toJson((Object)this.cn.getDependentContracts());
    }

    private class DumpTask
    extends TimerTask {
        private DumpTask() {
        }

        @Override
        public void run() {
            System.out.println("[ContractProcess  DumpTask] auto dump period : " + ContractProcess.this.projectConfig.getDumpPeriod());
            File file1 = new File(ContractProcess.this.dir);
            File file2 = new File(file1.getParent());
            String dir2 = file2.getParent() + "/memory/";
            System.out.println("[ContractProcess] auto dump dir " + dir2);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd.HH_mm_ss");
            File f = new File(dir2 + ContractProcess.this.cn.getContractName(), df.format(new Date()));
            System.out.println("[ContractProcess] dump file " + f.getAbsolutePath());
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            ContractProcess.this.getMemoryDump(f.getAbsolutePath());
        }
    }

    public static class Bean {
        public String name;
        public String value;
    }

    public static class Logger
    extends PrintStream {
        ContractProcess cp;
        OutputStream out;

        public Logger(OutputStream out, ContractProcess cp) {
            super(out);
            this.cp = cp;
            this.out = out;
        }

        public Logger(OutputStream out) {
            super(out);
            this.cp = null;
            this.out = out;
        }

        public Logger(PrintStream err) {
            super(err);
            this.out = null;
        }

        public ContractProcess getCp() {
            return this.cp;
        }

        public void writeToDB(Map<String, String> data) {
            if (this.cp != null) {
                this.cp.writeContractDB(data);
            }
        }

        public String getOutputStr() {
            return this.out.toString();
        }

        public void clean() {
            if (this.out instanceof ByteArrayOutputStream) {
                this.out = new ByteArrayOutputStream();
            }
        }
    }
}

