/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt;

import com.google.gson.JsonElement;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.audit.AuditDoaClient;
import org.bdware.doip.audit.EndpointConfig;
import org.bdware.doip.audit.client.AuditDoipClient;
import org.bdware.doip.audit.client.AuditIrpClient;
import org.bdware.doip.codec.JsonDoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.endpoint.client.DoipMessageCallback;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.stateinfo.StateInfoBase;
import org.bdware.sc.crdt.SharableVar;
import org.bdware.sc.util.JsonUtil;

public class SharableVarManager {
    static Logger LOGGER = LogManager.getLogger(SharableVarManager.class);
    public static SharableVarManager instance;
    private final String cpId;
    Map<String, SharableVar> allVars = new ConcurrentHashMap<String, SharableVar>();
    IrpClient client;
    AuditDoaClient doaClient;
    public static final String SHARABLEOP = "86.100871/SyncVar";

    public SharableVarManager(String id, EndpointConfig config) {
        this.client = new AuditIrpClient(config);
        this.doaClient = new AuditDoaClient("", config, null);
        this.cpId = id;
    }

    public static void initSharableVarManager(String id, EndpointConfig config) {
        instance = new SharableVarManager(id, config);
    }

    public DoipMessage handleSyncMessage(DoipMessage message) {
        try {
            String varId = message.header.parameters.attributes.get("varId").getAsString();
            String content = message.header.parameters.attributes.get("content").getAsString();
            SharableVar var = this.getVar(varId);
            var.join(content);
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.Success, message);
            builder.addAttributes("msg", "success");
            return builder.create();
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.UnKnownError, message);
            builder.addAttributes("exception", bo.toString());
            return builder.create();
        }
    }

    private SharableVar getVar(String varId) {
        return this.allVars.get(varId);
    }

    private DoipMessage createSyncMessage(String target, String varId, String content) {
        DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
        builder.createRequest(target, SHARABLEOP);
        builder.addAttributes("varId", varId);
        builder.addAttributes("content", content);
        return builder.create();
    }

    public void broadcastSyncMessage(String varId, List<String> sendTo, String content) {
        for (String target : sendTo) {
            DoipMessage doipMessage = this.createSyncMessage(target, varId, content);
            AuditDoipClient client = this.getClient(target);
            client.sendMessage(doipMessage, new DoipMessageCallback(){

                public void onResult(DoipMessage doipMessage) {
                    LOGGER.info("RECV Sync:" + JsonUtil.toJson((Object)JsonDoipMessage.fromDoipMessage((DoipMessage)doipMessage)));
                }
            });
        }
    }

    private AuditDoipClient getClient(String id) {
        return this.doaClient.convertDoidToRepo(id);
    }

    public synchronized SharableVar createVar(String identifier, String type) {
        try {
            if (this.allVars.containsKey(identifier)) {
                return this.allVars.get(identifier);
            }
            StateInfoBase stateInfoBase = this.client.resolve(identifier);
            if (stateInfoBase.handleValues.has("bdwType") && stateInfoBase.handleValues.get("bdwType").getAsString().equals("SharableVar")) {
                VarResolveResult resolveResult = (VarResolveResult)JsonUtil.fromJson((JsonElement)stateInfoBase.handleValues, VarResolveResult.class);
                SharableVar sharableVar = new SharableVar(this.cpId, identifier, resolveResult);
                this.allVars.put(identifier, sharableVar);
                return sharableVar;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class VarResolveResult {
        String[] writer;
        String[] reader;
        int[][] sendTo;
        long[] interval;
        long maxDelay;

        VarResolveResult() {
        }
    }
}

