/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.transport.transformer;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.transport.transformer.ComplexTransformerProxy;
import com.alibaba.datax.core.transport.transformer.FilterTransformer;
import com.alibaba.datax.core.transport.transformer.GroovyTransformer;
import com.alibaba.datax.core.transport.transformer.PadTransformer;
import com.alibaba.datax.core.transport.transformer.ReplaceTransformer;
import com.alibaba.datax.core.transport.transformer.SubstrTransformer;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerInfo;
import com.alibaba.datax.core.util.container.CoreConstant;
import com.alibaba.datax.core.util.container.JarLoader;
import com.alibaba.datax.transport.transformer.ComplexTransformer;
import com.alibaba.datax.transport.transformer.EDPTransformer;
import com.alibaba.datax.transport.transformer.EnumerateTransformer;
import com.alibaba.datax.transport.transformer.FloorTransformer;
import com.alibaba.datax.transport.transformer.HidingTransformer;
import com.alibaba.datax.transport.transformer.MD5Transformer;
import com.alibaba.datax.transport.transformer.MaskTransformer;
import com.alibaba.datax.transport.transformer.PrefixPreserveTransformer;
import com.alibaba.datax.transport.transformer.Transformer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TransformerRegistry.class);
    private static Map<String, TransformerInfo> registedTransformer = new HashMap<String, TransformerInfo>();

    public static void loadTransformerFromLocalStorage() {
        TransformerRegistry.loadTransformerFromLocalStorage(null);
    }

    public static void loadTransformerFromLocalStorage(List<String> transformers) {
        String[] paths = new File(CoreConstant.DATAX_STORAGE_TRANSFORMER_HOME).list();
        if (null == paths) {
            return;
        }
        for (String each : paths) {
            try {
                if (transformers != null && !transformers.contains(each)) continue;
                TransformerRegistry.loadTransformer(each);
            }
            catch (Exception e) {
                LOG.error(String.format("skip transformer(%s) loadTransformer has Exception(%s)", each, e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void loadTransformer(String each) {
        Configuration transformerConfiguration;
        String transformerPath = CoreConstant.DATAX_STORAGE_TRANSFORMER_HOME + File.separator + each;
        try {
            transformerConfiguration = TransformerRegistry.loadTransFormerConfig(transformerPath);
        }
        catch (Exception e) {
            LOG.error(String.format("skip transformer(%s),load transformer.json error, path = %s, ", each, transformerPath), (Throwable)e);
            return;
        }
        String className = transformerConfiguration.getString("class");
        if (StringUtils.isEmpty((CharSequence)className)) {
            LOG.error(String.format("skip transformer(%s),class not config, path = %s, config = %s", each, transformerPath, transformerConfiguration.beautify()));
            return;
        }
        String funName = transformerConfiguration.getString("name");
        if (!each.equals(funName)) {
            LOG.warn(String.format("transformer(%s) name not match transformer.json config name[%s], will ignore json's name, path = %s, config = %s", each, funName, transformerPath, transformerConfiguration.beautify()));
        }
        JarLoader jarLoader = new JarLoader(new String[]{transformerPath});
        try {
            Class<?> transformerClass = jarLoader.loadClass(className);
            Object transformer = transformerClass.newInstance();
            if (ComplexTransformer.class.isAssignableFrom(transformer.getClass())) {
                ((ComplexTransformer)transformer).setTransformerName(each);
                TransformerRegistry.registComplexTransformer((ComplexTransformer)transformer, jarLoader, false);
            } else if (Transformer.class.isAssignableFrom(transformer.getClass())) {
                ((Transformer)transformer).setTransformerName(each);
                TransformerRegistry.registTransformer((Transformer)transformer, jarLoader, false);
            } else {
                LOG.error(String.format("load Transformer class(%s) error, path = %s", className, transformerPath));
            }
        }
        catch (Exception e) {
            LOG.error(String.format("skip transformer(%s),load Transformer class error, path = %s ", each, transformerPath), (Throwable)e);
        }
    }

    private static Configuration loadTransFormerConfig(String transformerPath) {
        return Configuration.from(new File(transformerPath + File.separator + "transformer.json"));
    }

    public static TransformerInfo getTransformer(String transformerName) {
        TransformerInfo result = registedTransformer.get(transformerName);
        return result;
    }

    public static synchronized void registTransformer(Transformer transformer) {
        TransformerRegistry.registTransformer(transformer, null, true);
    }

    public static synchronized void registTransformer(Transformer transformer, ClassLoader classLoader, boolean isNative) {
        TransformerRegistry.checkName(transformer.getTransformerName(), isNative);
        if (registedTransformer.containsKey(transformer.getTransformerName())) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_DUPLICATE_ERROR, " name=" + transformer.getTransformerName());
        }
        registedTransformer.put(transformer.getTransformerName(), TransformerRegistry.buildTransformerInfo(new ComplexTransformerProxy(transformer), isNative, classLoader));
    }

    public static synchronized void registComplexTransformer(ComplexTransformer complexTransformer, ClassLoader classLoader, boolean isNative) {
        TransformerRegistry.checkName(complexTransformer.getTransformerName(), isNative);
        if (registedTransformer.containsKey(complexTransformer.getTransformerName())) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_DUPLICATE_ERROR, " name=" + complexTransformer.getTransformerName());
        }
        registedTransformer.put(complexTransformer.getTransformerName(), TransformerRegistry.buildTransformerInfo(complexTransformer, isNative, classLoader));
    }

    private static void checkName(String functionName, boolean isNative) {
        boolean checkResult = true;
        if (isNative) {
            if (!functionName.startsWith("dx_")) {
                checkResult = false;
            }
        } else if (functionName.startsWith("dx_")) {
            checkResult = false;
        }
        if (!checkResult) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_NAME_ERROR, " name=" + functionName + ": isNative=" + isNative);
        }
    }

    private static TransformerInfo buildTransformerInfo(ComplexTransformer complexTransformer, boolean isNative, ClassLoader classLoader) {
        TransformerInfo transformerInfo = new TransformerInfo();
        transformerInfo.setClassLoader(classLoader);
        transformerInfo.setIsNative(isNative);
        transformerInfo.setTransformer(complexTransformer);
        return transformerInfo;
    }

    public static List<String> getAllSuportTransformer() {
        return new ArrayList<String>(registedTransformer.keySet());
    }

    static {
        TransformerRegistry.registTransformer(new SubstrTransformer());
        TransformerRegistry.registTransformer(new PadTransformer());
        TransformerRegistry.registTransformer(new ReplaceTransformer());
        TransformerRegistry.registTransformer(new FilterTransformer());
        TransformerRegistry.registTransformer(new GroovyTransformer());
        TransformerRegistry.registTransformer(new EDPTransformer());
        TransformerRegistry.registTransformer(new EnumerateTransformer());
        TransformerRegistry.registTransformer(new FloorTransformer());
        TransformerRegistry.registTransformer(new HidingTransformer());
        TransformerRegistry.registTransformer(new MaskTransformer());
        TransformerRegistry.registTransformer(new MD5Transformer());
        TransformerRegistry.registTransformer(new PrefixPreserveTransformer());
    }
}

