/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.writer.streamwriter;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.RecordReceiver;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.spi.Writer;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.plugin.writer.streamwriter.StreamWriterErrorCode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWriter
extends com.alibaba.datax.common.spi.Writer {
    private static String buildFilePath(String path, String fileName) {
        boolean isEndWithSeparator = false;
        switch (IOUtils.DIR_SEPARATOR) {
            case '/': {
                isEndWithSeparator = path.endsWith(String.valueOf(IOUtils.DIR_SEPARATOR));
                break;
            }
            case '\\': {
                isEndWithSeparator = path.endsWith(String.valueOf('\\'));
                break;
            }
        }
        if (!isEndWithSeparator) {
            path = path + IOUtils.DIR_SEPARATOR;
        }
        return String.format("%s%s", path, fileName);
    }

    public static class Task
    extends Writer.Task {
        private static final Logger LOG = LoggerFactory.getLogger(Task.class);
        private static final String NEWLINE_FLAG = System.getProperty("line.separator", "\n");
        private Configuration writerSliceConfig;
        private String fieldDelimiter;
        private boolean print;
        private String path;
        private String fileName;
        private long recordNumBeforSleep;
        private long sleepTime;

        @Override
        public void init() {
            this.writerSliceConfig = this.getPluginJobConf();
            this.fieldDelimiter = this.writerSliceConfig.getString("fieldDelimiter", "\t");
            this.print = this.writerSliceConfig.getBool("print", true);
            this.path = this.writerSliceConfig.getString("path", null);
            this.fileName = this.writerSliceConfig.getString("fileName", null);
            this.recordNumBeforSleep = this.writerSliceConfig.getLong("recordNumBeforeSleep", 0L);
            this.sleepTime = this.writerSliceConfig.getLong("sleepTime", 0L);
            if (this.recordNumBeforSleep < 0L) {
                throw DataXException.asDataXException((ErrorCode)StreamWriterErrorCode.CONFIG_INVALID_EXCEPTION, "recordNumber \u4e0d\u80fd\u4e3a\u8d1f\u503c");
            }
            if (this.sleepTime < 0L) {
                throw DataXException.asDataXException((ErrorCode)StreamWriterErrorCode.CONFIG_INVALID_EXCEPTION, "sleep \u4e0d\u80fd\u4e3a\u8d1f\u503c");
            }
        }

        @Override
        public void prepare() {
        }

        @Override
        public void startWrite(RecordReceiver recordReceiver) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.path}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.fileName})) {
                this.writeToFile(recordReceiver, this.path, this.fileName, this.recordNumBeforSleep, this.sleepTime);
            } else {
                try {
                    Record record;
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
                    while ((record = recordReceiver.getFromReader()) != null) {
                        if (!this.print) continue;
                        writer.write(this.recordToString(record));
                    }
                    writer.flush();
                }
                catch (Exception e) {
                    throw DataXException.asDataXException((ErrorCode)StreamWriterErrorCode.RUNTIME_EXCEPTION, e);
                }
            }
        }

        private void writeToFile(RecordReceiver recordReceiver, String path, String fileName, long recordNumBeforSleep, long sleepTime) {
            LOG.info("begin do write...");
            String fileFullPath = StreamWriter.buildFilePath(path, fileName);
            LOG.info(String.format("write to file : [%s]", fileFullPath));
            BufferedWriter writer = null;
            try {
                Record record;
                File newFile = new File(fileFullPath);
                newFile.createNewFile();
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile, true), "UTF-8"));
                int count = 0;
                while ((record = recordReceiver.getFromReader()) != null) {
                    if (recordNumBeforSleep > 0L && sleepTime > 0L && (long)count == recordNumBeforSleep) {
                        LOG.info("StreamWriter start to sleep ... recordNumBeforSleep={},sleepTime={}", (Object)recordNumBeforSleep, (Object)sleepTime);
                        try {
                            Thread.sleep(sleepTime * 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    writer.write(this.recordToString(record));
                    ++count;
                }
                writer.flush();
            }
            catch (Exception e) {
                try {
                    throw DataXException.asDataXException((ErrorCode)StreamWriterErrorCode.RUNTIME_EXCEPTION, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }

        @Override
        public void post() {
        }

        @Override
        public void destroy() {
        }

        private String recordToString(Record record) {
            int recordLength = record.getColumnNumber();
            if (0 == recordLength) {
                return NEWLINE_FLAG;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < recordLength; ++i) {
                Column column = record.getColumn(i);
                sb.append(column.asString()).append(this.fieldDelimiter);
            }
            sb.setLength(sb.length() - 1);
            sb.append(NEWLINE_FLAG);
            return sb.toString();
        }
    }

    public static class Job
    extends Writer.Job {
        private static final Logger LOG = LoggerFactory.getLogger(Job.class);
        private Configuration originalConfig;

        @Override
        public void init() {
            this.originalConfig = super.getPluginJobConf();
            String path = this.originalConfig.getString("path", null);
            String fileName = this.originalConfig.getString("fileName", null);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{path}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileName})) {
                this.validateParameter(path, fileName);
            }
        }

        private void validateParameter(String path, String fileName) {
            block6: {
                try {
                    boolean createdOk;
                    File dir = new File(path);
                    if (dir.isFile()) {
                        throw DataXException.asDataXException((ErrorCode)StreamWriterErrorCode.ILLEGAL_VALUE, String.format("\u60a8\u914d\u7f6e\u7684path: [%s] \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u76ee\u5f55, \u8bf7\u60a8\u6ce8\u610f\u6587\u4ef6\u91cd\u540d, \u4e0d\u5408\u6cd5\u76ee\u5f55\u540d\u7b49\u60c5\u51b5.", path));
                    }
                    if (!dir.exists() && !(createdOk = dir.mkdirs())) {
                        throw DataXException.asDataXException((ErrorCode)StreamWriterErrorCode.CONFIG_INVALID_EXCEPTION, String.format("\u60a8\u6307\u5b9a\u7684\u6587\u4ef6\u8def\u5f84 : [%s] \u521b\u5efa\u5931\u8d25.", path));
                    }
                    String fileFullPath = StreamWriter.buildFilePath(path, fileName);
                    File newFile = new File(fileFullPath);
                    if (!newFile.exists()) break block6;
                    try {
                        FileUtils.forceDelete((File)newFile);
                    }
                    catch (IOException e) {
                        throw DataXException.asDataXException(StreamWriterErrorCode.RUNTIME_EXCEPTION, String.format("\u5220\u9664\u6587\u4ef6\u5931\u8d25 : [%s] ", fileFullPath), e);
                    }
                }
                catch (SecurityException se) {
                    throw DataXException.asDataXException(StreamWriterErrorCode.SECURITY_NOT_ENOUGH, String.format("\u60a8\u6ca1\u6709\u6743\u9650\u521b\u5efa\u6587\u4ef6\u8def\u5f84 : [%s] ", path), se);
                }
            }
        }

        @Override
        public void prepare() {
        }

        @Override
        public List<Configuration> split(int mandatoryNumber) {
            ArrayList<Configuration> writerSplitConfigs = new ArrayList<Configuration>();
            for (int i = 0; i < mandatoryNumber; ++i) {
                writerSplitConfigs.add(this.originalConfig);
            }
            return writerSplitConfigs;
        }

        @Override
        public void post() {
        }

        @Override
        public void destroy() {
        }
    }
}

