package org.bdware.sc.crdt;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import org.bdware.crdt.counter.GCounter;
import org.bdware.sc.util.JsonUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class SharableVar {
    public final static HashedWheelTimer HASHED_WHEEL_TIMER =
            new HashedWheelTimer(new ThreadFactory() {
                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    return t;
                }
            }, 5, TimeUnit.MILLISECONDS, 2);
    private final String varId;

    private long interval;
    private final String myId;
    GCounter counter;
    int offset;
    List<String> sendTo;
    private SyncTimeout nextTimeOut;


    public SharableVar(String cpId, String identifier,
            SharableVarManager.VarResolveResult resolveResult) {
        counter = new GCounter(cpId, identifier);
        myId = cpId;
        varId = identifier;
        HASHED_WHEEL_TIMER.newTimeout(new TimerTask() {
            @Override
            public void run(Timeout timeout) throws Exception {
                initByVarResolve(resolveResult);

            }
        }, 0, TimeUnit.MILLISECONDS);

    }

    public void join(String content) {
        GCounter toJoin = JsonUtil.fromJson(content, GCounter.class);
        counter.join(toJoin);
    }

    class SyncTimeout implements TimerTask {
        @Override
        public void run(Timeout timeout) throws Exception {
            try {
                syncVar();
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                HASHED_WHEEL_TIMER.newTimeout(nextTimeOut, interval, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void syncVar() {
        String content = JsonUtil.toJson(counter);
        SharableVarManager.instance.broadcastSyncMessage(varId, sendTo, content);
    }

    private void initByVarResolve(SharableVarManager.VarResolveResult resolveResult) {
        sendTo = new ArrayList<>();
        // 假设没有同一个人既是reader又是writer。
        offset = -1;
        for (int i = 0; i < resolveResult.writer.length; i++) {
            if (myId.equals(resolveResult.writer[i])) {
                offset = i;
            }
        }
        if (offset == -1)
            for (int i = 0; i < resolveResult.reader.length; i++) {
                if (myId.equals(resolveResult.reader[i])) {
                    offset = resolveResult.writer.length + i;
                }
            }
        for (int i = 0; i < resolveResult.sendTo[offset].length; i++) {
            int pos = resolveResult.sendTo[offset][i];
            sendTo.add(findByOffset(pos, resolveResult));
        }
        interval = resolveResult.interval[offset];
        nextTimeOut = new SyncTimeout();
        HASHED_WHEEL_TIMER.newTimeout(nextTimeOut, interval, TimeUnit.MILLISECONDS);
    }

    private String findByOffset(int pos, SharableVarManager.VarResolveResult resolveResult) {
        if (pos < resolveResult.writer.length)
            return resolveResult.writer[pos];
        return resolveResult.reader[pos - resolveResult.writer.length];
    }

    public GCounter get() {
        return counter;
    }

}
