/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import java.util.Arrays;

public class PadTransformer
extends Transformer {
    public PadTransformer() {
        this.setTransformerName("dx_pad");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        String padString;
        int length;
        String padType;
        int columnIndex;
        try {
            if (paras.length != 4) {
                throw new RuntimeException("dx_pad paras must be 4");
            }
            columnIndex = (Integer)paras[0];
            padType = (String)paras[1];
            length = Integer.valueOf((String)paras[2]);
            padString = (String)paras[3];
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                oriValue = "";
            }
            if (!padType.equalsIgnoreCase("r") && !padType.equalsIgnoreCase("l")) {
                throw new RuntimeException(String.format("dx_pad first para(%s) support l or r", padType));
            }
            String newValue = length <= oriValue.length() ? oriValue.substring(0, length) : this.doPad(padType, oriValue, length, padString);
            record.setColumn(columnIndex, new StringColumn(newValue));
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }

    private String doPad(String padType, String oriValue, int length, String padString) {
        String finalPad = "";
        int NeedLength = length - oriValue.length();
        while (NeedLength > 0) {
            if (NeedLength >= padString.length()) {
                finalPad = finalPad + padString;
                NeedLength -= padString.length();
                continue;
            }
            finalPad = finalPad + padString.substring(0, NeedLength);
            NeedLength = 0;
        }
        if (padType.equalsIgnoreCase("l")) {
            return finalPad + oriValue;
        }
        return oriValue + finalPad;
    }
}

