/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.memory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jdk.internal.dynalink.beans.StaticClass;
import org.bdware.sc.boundry.JavaScriptEntry;
import org.bdware.sc.memory.JSEDump;
import org.bdware.sc.memory.MOType;
import org.bdware.sc.memory.MemoryArrayObject;
import org.bdware.sc.memory.MemoryFunctionObject;
import org.bdware.sc.memory.MemoryJSObject;
import org.bdware.sc.memory.MemoryObject;
import org.bdware.sc.util.JsonUtil;
import wrp.jdk.nashorn.api.scripting.ScriptObjectMirror;
import wrp.jdk.nashorn.internal.objects.Global;
import wrp.jdk.nashorn.internal.runtime.Context;
import wrp.jdk.nashorn.internal.runtime.PropertyMap;
import wrp.jdk.nashorn.internal.runtime.Undefined;
import wrp.jdk.nashorn.internal.scripts.JO;

public class MemoryDump
implements Serializable {
    transient long id = 0L;
    transient Map<Object, Long> allocated;
    Map<Long, MemoryObject> objects = new HashMap<Long, MemoryObject>();
    JSEDump jseDump;
    transient Map<Long, Object> recreate;

    public MemoryDump() {
        this.allocated = new HashMap<Object, Long>();
        this.getRoot();
    }

    public static MemoryDump loadFromStr(String memDump) {
        JsonObject map = JsonUtil.parseStringAsJsonObject((String)memDump);
        MemoryDump ret = new MemoryDump();
        for (Map.Entry<String, JsonElement> entry : map.entrySet()) {
            long id = Long.parseLong(entry.getKey());
            JsonObject obj = entry.getValue().getAsJsonObject();
            MOType type = MOType.valueOf(obj.get("type").getAsString());
            MemoryObject mo = null;
            switch (type) {
                case JSObject: 
                case JSArray: {
                    mo = (MemoryObject)JsonUtil.fromJson((JsonElement)obj, MemoryJSObject.class);
                    break;
                }
                case JSFunction: {
                    mo = (MemoryObject)JsonUtil.fromJson((JsonElement)obj, MemoryFunctionObject.class);
                    break;
                }
                case Int: {
                    mo = (MemoryObject)JsonUtil.fromJson((JsonElement)obj, MemoryObject.class);
                    mo.data = Integer.parseInt(obj.get("data").getAsString());
                    break;
                }
                case Boolean: {
                    mo = (MemoryObject)JsonUtil.fromJson((JsonElement)obj, MemoryObject.class);
                    mo.data = Boolean.parseBoolean(obj.get("data").getAsString());
                    break;
                }
                case String: 
                case Double: {
                    mo = (MemoryObject)JsonUtil.fromJson((JsonElement)obj, MemoryObject.class);
                    break;
                }
                default: {
                    System.out.println("[MemoryDump] todo, missing type:" + (Object)((Object)type));
                }
            }
            ret.objects.put(id, mo);
        }
        return ret;
    }

    public Map<Long, MemoryObject> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<Long, MemoryObject> m) {
        this.objects = m;
    }

    public MemoryJSObject getRoot() {
        if (this.objects.containsKey(0L)) {
            return (MemoryJSObject)this.objects.get(0L);
        }
        MemoryJSObject jo = new MemoryJSObject(0L);
        this.objects.put(0L, jo);
        return jo;
    }

    public long allocate(Object obj) {
        if (obj == null) {
            return -1L;
        }
        ++this.id;
        long currID = this.id;
        if (obj.getClass() != StaticClass.class) {
            if (this.allocated.containsKey(obj)) {
                return this.allocated.get(obj);
            }
            this.allocated.put(obj, currID);
        }
        if (obj.getClass() == ScriptObjectMirror.class) {
            ScriptObjectMirror som = (ScriptObjectMirror)obj;
            if (som.isFunction()) {
                MemoryFunctionObject fo = new MemoryFunctionObject(currID);
                this.objects.put(currID, fo);
                for (String str : som.getOwnKeys(true)) {
                    fo.addField(str, this.allocate(som.getMember(str)));
                }
            } else if (som.isArray()) {
                MemoryArrayObject ao = new MemoryArrayObject(currID);
                this.objects.put(currID, ao);
                for (String str : som.getOwnKeys(true)) {
                    ao.addField(str, this.allocate(som.getMember(str)));
                }
            } else {
                MemoryJSObject jo = new MemoryJSObject(currID);
                this.objects.put(currID, jo);
                for (String str : som.getOwnKeys(true)) {
                    jo.addField(str, this.allocate(som.getMember(str)));
                }
            }
        } else if (obj.getClass() != Undefined.class && obj.getClass() != StaticClass.class) {
            MOType type = MOType.getType(obj);
            if (type.isPrimitive()) {
                MemoryObject mo = new MemoryObject(currID);
                mo.type = type;
                mo.data = obj;
                this.objects.put(currID, mo);
            } else {
                System.out.println("[MemoryDump] Allocat MetType:" + obj.getClass() + " now id=" + currID);
            }
        }
        return currID;
    }

    public Map<Long, Object> recreateObject() {
        this.recreate = new HashMap<Long, Object>();
        this.fillRecreate();
        this.fillJO();
        return this.recreate;
    }

    private void fillJO() {
        block3: for (Long key : this.objects.keySet()) {
            MemoryObject mo = this.objects.get(key);
            if (mo == null) continue;
            switch (mo.type) {
                case JSObject: 
                case JSArray: {
                    MemoryJSObject mjo = (MemoryJSObject)mo;
                    ScriptObjectMirror jo = (ScriptObjectMirror)this.recreate.get(key);
                    for (String field : mjo.fields.keySet()) {
                        Object temp = this.recreate.get(mjo.fields.get(field));
                        if (mjo.fields.get(field) < 0L) continue;
                        if (field.length() > 0) {
                            jo.setMember(field, temp);
                            continue;
                        }
                        jo.setMember(" ", temp);
                    }
                    continue block3;
                }
            }
        }
    }

    private void fillRecreate() {
        Context.setGlobal(JavaScriptEntry.getEngineGlobal());
        for (Long key : this.objects.keySet()) {
            Object obj = null;
            MemoryObject mo = this.objects.get(key);
            if (mo == null) continue;
            switch (mo.type) {
                case JSArray: {
                    obj = ScriptObjectMirror.wrap(Global.allocate(new int[0]), JavaScriptEntry.getEngineGlobal());
                    break;
                }
                case JSObject: {
                    obj = ScriptObjectMirror.wrap(new JO(PropertyMap.newMap()), JavaScriptEntry.getEngineGlobal());
                    break;
                }
                case JSFunction: {
                    break;
                }
                case Int: 
                case Boolean: 
                case String: {
                    obj = mo.data;
                    break;
                }
                case Double: {
                    obj = Double.parseDouble(mo.data.toString());
                    break;
                }
                default: {
                    System.out.println("[MemoryDump] todo, missing type:" + (Object)((Object)mo.type));
                }
            }
            this.recreate.put(key, obj);
        }
    }
}

