/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.job;

import com.alibaba.datax.common.constant.PluginType;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.AbstractJobPlugin;
import com.alibaba.datax.common.plugin.JobPluginCollector;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.spi.Reader;
import com.alibaba.datax.common.spi.Writer;
import com.alibaba.datax.common.statistics.PerfTrace;
import com.alibaba.datax.common.statistics.VMInfo;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.common.util.StrUtil;
import com.alibaba.datax.core.AbstractContainer;
import com.alibaba.datax.core.Engine;
import com.alibaba.datax.core.container.util.HookInvoker;
import com.alibaba.datax.core.container.util.JobAssignUtil;
import com.alibaba.datax.core.job.scheduler.AbstractScheduler;
import com.alibaba.datax.core.job.scheduler.processinner.StandAloneScheduler;
import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.datax.core.statistics.communication.CommunicationTool;
import com.alibaba.datax.core.statistics.container.communicator.job.StandAloneJobContainerCommunicator;
import com.alibaba.datax.core.statistics.plugin.DefaultJobPluginCollector;
import com.alibaba.datax.core.util.ErrorRecordChecker;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import com.alibaba.datax.core.util.container.ClassLoaderSwapper;
import com.alibaba.datax.core.util.container.CoreConstant;
import com.alibaba.datax.core.util.container.LoadUtil;
import com.alibaba.datax.dataxservice.face.domain.enums.ExecuteMode;
import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobContainer
extends AbstractContainer {
    private static final Logger LOG = LoggerFactory.getLogger(JobContainer.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ClassLoaderSwapper classLoaderSwapper = ClassLoaderSwapper.newCurrentThreadClassLoaderSwapper();
    private long jobId;
    private String readerPluginName;
    private String writerPluginName;
    private Reader.Job jobReader;
    private Writer.Job jobWriter;
    private Configuration userConf;
    private long startTimeStamp;
    private long endTimeStamp;
    private long startTransferTimeStamp;
    private long endTransferTimeStamp;
    private int needChannelNumber;
    private int totalStage = 1;
    private ErrorRecordChecker errorLimit;

    public JobContainer(Configuration configuration) {
        super(configuration);
        this.errorLimit = new ErrorRecordChecker(configuration);
    }

    @Override
    public void start() {
        LOG.info("DataX jobContainer starts job.");
        boolean hasException = false;
        boolean isDryRun = false;
        try {
            this.startTimeStamp = System.currentTimeMillis();
            isDryRun = this.configuration.getBool("job.setting.dryRun", false);
            if (isDryRun) {
                LOG.info("jobContainer starts to do preCheck ...");
                this.preCheck();
            } else {
                this.userConf = this.configuration.clone();
                LOG.debug("jobContainer starts to do preHandle ...");
                this.preHandle();
                LOG.debug("jobContainer starts to do init ...");
                this.init();
                LOG.info("jobContainer starts to do prepare ...");
                this.prepare();
                LOG.info("jobContainer starts to do split ...");
                this.totalStage = this.split();
                LOG.info("jobContainer starts to do schedule ...");
                this.schedule();
                LOG.debug("jobContainer starts to do post ...");
                this.post();
                LOG.debug("jobContainer starts to do postHandle ...");
                this.postHandle();
                LOG.info("DataX jobId [{}] completed successfully.", (Object)this.jobId);
                this.invokeHooks();
            }
        }
        catch (Throwable e) {
            LOG.error("Exception when job run", e);
            hasException = true;
            if (e instanceof OutOfMemoryError) {
                this.destroy();
                System.gc();
            }
            if (super.getContainerCommunicator() == null) {
                StandAloneJobContainerCommunicator tempContainerCollector = new StandAloneJobContainerCommunicator(this.configuration);
                super.setContainerCommunicator(tempContainerCollector);
            }
            Communication communication = super.getContainerCommunicator().collect();
            communication.setThrowable(e);
            communication.setTimestamp(this.endTimeStamp);
            Communication tempComm = new Communication();
            tempComm.setTimestamp(this.startTransferTimeStamp);
            Communication reportCommunication = CommunicationTool.getReportCommunication(communication, tempComm, this.totalStage);
            super.getContainerCommunicator().report(reportCommunication);
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, e);
        }
        finally {
            if (!isDryRun) {
                this.destroy();
                this.endTimeStamp = System.currentTimeMillis();
                if (!hasException) {
                    VMInfo vmInfo = VMInfo.getVmInfo();
                    if (vmInfo != null) {
                        vmInfo.getDelta(false);
                        LOG.info(vmInfo.totalString());
                    }
                    LOG.info(PerfTrace.getInstance().summarizeNoException());
                    this.logStatistics();
                }
            }
        }
    }

    private void preCheck() {
        this.preCheckInit();
        this.adjustChannelNumber();
        if (this.needChannelNumber <= 0) {
            this.needChannelNumber = 1;
        }
        this.preCheckReader();
        this.preCheckWriter();
        LOG.info("PreCheck\u901a\u8fc7");
    }

    private void preCheckInit() {
        this.jobId = this.configuration.getLong("core.container.job.id", -1L);
        if (this.jobId < 0L) {
            LOG.info("Set jobId = 0");
            this.jobId = 0L;
            this.configuration.set("core.container.job.id", this.jobId);
        }
        Thread.currentThread().setName("job-" + this.jobId);
        DefaultJobPluginCollector jobPluginCollector = new DefaultJobPluginCollector(this.getContainerCommunicator());
        this.jobReader = this.preCheckReaderInit(jobPluginCollector);
        this.jobWriter = this.preCheckWriterInit(jobPluginCollector);
    }

    private Reader.Job preCheckReaderInit(JobPluginCollector jobPluginCollector) {
        this.readerPluginName = this.configuration.getString("job.content[0].reader.name");
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.READER, this.readerPluginName));
        Reader.Job jobReader = (Reader.Job)LoadUtil.loadJobPlugin(PluginType.READER, this.readerPluginName);
        this.configuration.set("job.content[0].reader.parameter.dryRun", true);
        jobReader.setPluginJobConf(this.configuration.getConfiguration("job.content[0].reader.parameter"));
        jobReader.setPeerPluginJobConf(this.configuration.getConfiguration("job.content[0].reader.parameter"));
        jobReader.setJobPluginCollector(jobPluginCollector);
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
        return jobReader;
    }

    private Writer.Job preCheckWriterInit(JobPluginCollector jobPluginCollector) {
        this.writerPluginName = this.configuration.getString("job.content[0].writer.name");
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.WRITER, this.writerPluginName));
        Writer.Job jobWriter = (Writer.Job)LoadUtil.loadJobPlugin(PluginType.WRITER, this.writerPluginName);
        this.configuration.set("job.content[0].writer.parameter.dryRun", true);
        jobWriter.setPluginJobConf(this.configuration.getConfiguration("job.content[0].writer.parameter"));
        jobWriter.setPeerPluginJobConf(this.configuration.getConfiguration("job.content[0].reader.parameter"));
        jobWriter.setPeerPluginName(this.readerPluginName);
        jobWriter.setJobPluginCollector(jobPluginCollector);
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
        return jobWriter;
    }

    private void preCheckReader() {
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.READER, this.readerPluginName));
        LOG.info(String.format("DataX Reader.Job [%s] do preCheck work .", this.readerPluginName));
        this.jobReader.preCheck();
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
    }

    private void preCheckWriter() {
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.WRITER, this.writerPluginName));
        LOG.info(String.format("DataX Writer.Job [%s] do preCheck work .", this.writerPluginName));
        this.jobWriter.preCheck();
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
    }

    private void init() {
        this.jobId = this.configuration.getLong("core.container.job.id", -1L);
        if (this.jobId < 0L) {
            LOG.info("Set jobId = 0");
            this.jobId = 0L;
            this.configuration.set("core.container.job.id", this.jobId);
        }
        Thread.currentThread().setName("job-" + this.jobId);
        DefaultJobPluginCollector jobPluginCollector = new DefaultJobPluginCollector(this.getContainerCommunicator());
        this.jobReader = this.initJobReader(jobPluginCollector);
        this.jobWriter = this.initJobWriter(jobPluginCollector);
    }

    private void prepare() {
        this.prepareJobReader();
        this.prepareJobWriter();
    }

    private void preHandle() {
        PluginType handlerPluginType;
        String handlerPluginTypeStr = this.configuration.getString("job.preHandler.pluginType");
        if (!StringUtils.isNotEmpty((String)handlerPluginTypeStr)) {
            return;
        }
        try {
            handlerPluginType = PluginType.valueOf(handlerPluginTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.CONFIG_ERROR, String.format("Job preHandler's pluginType(%s) set error, reason(%s)", handlerPluginTypeStr.toUpperCase(), e.getMessage()));
        }
        String handlerPluginName = this.configuration.getString("job.preHandler.pluginName");
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(handlerPluginType, handlerPluginName));
        AbstractJobPlugin handler = LoadUtil.loadJobPlugin(handlerPluginType, handlerPluginName);
        DefaultJobPluginCollector jobPluginCollector = new DefaultJobPluginCollector(this.getContainerCommunicator());
        handler.setJobPluginCollector(jobPluginCollector);
        handler.preHandler(this.configuration);
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
        LOG.info("After PreHandler: \n" + Engine.filterJobConfiguration(this.configuration) + "\n");
    }

    private void postHandle() {
        PluginType handlerPluginType;
        String handlerPluginTypeStr = this.configuration.getString("job.postHandler.pluginType");
        if (!StringUtils.isNotEmpty((String)handlerPluginTypeStr)) {
            return;
        }
        try {
            handlerPluginType = PluginType.valueOf(handlerPluginTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.CONFIG_ERROR, String.format("Job postHandler's pluginType(%s) set error, reason(%s)", handlerPluginTypeStr.toUpperCase(), e.getMessage()));
        }
        String handlerPluginName = this.configuration.getString("job.postHandler.pluginName");
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(handlerPluginType, handlerPluginName));
        AbstractJobPlugin handler = LoadUtil.loadJobPlugin(handlerPluginType, handlerPluginName);
        DefaultJobPluginCollector jobPluginCollector = new DefaultJobPluginCollector(this.getContainerCommunicator());
        handler.setJobPluginCollector(jobPluginCollector);
        handler.postHandler(this.configuration);
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
    }

    private int split() {
        this.adjustChannelNumber();
        if (this.needChannelNumber <= 0) {
            this.needChannelNumber = 1;
        }
        List<Configuration> readerTaskConfigs = this.doReaderSplit(this.needChannelNumber);
        int taskNumber = readerTaskConfigs.size();
        List<Configuration> writerTaskConfigs = this.doWriterSplit(taskNumber);
        List<Configuration> transformerList = this.configuration.getListConfiguration("job.content[0].transformer");
        LOG.debug("transformer configuration: " + JSON.toJSONString(transformerList));
        List<Configuration> contentConfig = this.mergeReaderAndWriterTaskConfigs(readerTaskConfigs, writerTaskConfigs, transformerList);
        LOG.debug("contentConfig configuration: " + JSON.toJSONString(contentConfig));
        this.configuration.set("job.content", contentConfig);
        return contentConfig.size();
    }

    private void adjustChannelNumber() {
        boolean isChannelLimit;
        boolean isRecordLimit;
        boolean isByteLimit;
        int needChannelNumberByByte = Integer.MAX_VALUE;
        int needChannelNumberByRecord = Integer.MAX_VALUE;
        boolean bl = isByteLimit = this.configuration.getInt("job.setting.speed.byte", 0) > 0;
        if (isByteLimit) {
            long globalLimitedByteSpeed = this.configuration.getInt("job.setting.speed.byte", 0xA00000).intValue();
            Long channelLimitedByteSpeed = this.configuration.getLong("core.transport.channel.speed.byte");
            if (channelLimitedByteSpeed == null || channelLimitedByteSpeed <= 0L) {
                DataXException.asDataXException((ErrorCode)FrameworkErrorCode.CONFIG_ERROR, "\u5728\u6709\u603bbps\u9650\u901f\u6761\u4ef6\u4e0b\uff0c\u5355\u4e2achannel\u7684bps\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e5f\u4e0d\u80fd\u4e3a\u975e\u6b63\u6570");
            }
            needChannelNumberByByte = (needChannelNumberByByte = (int)(globalLimitedByteSpeed / channelLimitedByteSpeed)) > 0 ? needChannelNumberByByte : 1;
            LOG.info("Job set Max-Byte-Speed to " + globalLimitedByteSpeed + " bytes.");
        }
        boolean bl2 = isRecordLimit = this.configuration.getInt("job.setting.speed.record", 0) > 0;
        if (isRecordLimit) {
            long globalLimitedRecordSpeed = this.configuration.getInt("job.setting.speed.record", 100000).intValue();
            Long channelLimitedRecordSpeed = this.configuration.getLong("core.transport.channel.speed.record");
            if (channelLimitedRecordSpeed == null || channelLimitedRecordSpeed <= 0L) {
                DataXException.asDataXException((ErrorCode)FrameworkErrorCode.CONFIG_ERROR, "\u5728\u6709\u603btps\u9650\u901f\u6761\u4ef6\u4e0b\uff0c\u5355\u4e2achannel\u7684tps\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e5f\u4e0d\u80fd\u4e3a\u975e\u6b63\u6570");
            }
            needChannelNumberByRecord = (needChannelNumberByRecord = (int)(globalLimitedRecordSpeed / channelLimitedRecordSpeed)) > 0 ? needChannelNumberByRecord : 1;
            LOG.info("Job set Max-Record-Speed to " + globalLimitedRecordSpeed + " records.");
        }
        int n = this.needChannelNumber = needChannelNumberByByte < needChannelNumberByRecord ? needChannelNumberByByte : needChannelNumberByRecord;
        if (this.needChannelNumber < Integer.MAX_VALUE) {
            return;
        }
        boolean bl3 = isChannelLimit = this.configuration.getInt("job.setting.speed.channel", 0) > 0;
        if (isChannelLimit) {
            this.needChannelNumber = this.configuration.getInt("job.setting.speed.channel");
            LOG.info("Job set Channel-Number to " + this.needChannelNumber + " channels.");
            return;
        }
        throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.CONFIG_ERROR, "Job\u8fd0\u884c\u901f\u5ea6\u5fc5\u987b\u8bbe\u7f6e");
    }

    private void schedule() {
        int channelsPerTaskGroup = this.configuration.getInt("core.container.taskGroup.channel", 5);
        int taskNumber = this.configuration.getList("job.content").size();
        this.needChannelNumber = Math.min(this.needChannelNumber, taskNumber);
        PerfTrace.getInstance().setChannelNumber(this.needChannelNumber);
        List<Configuration> taskGroupConfigs = JobAssignUtil.assignFairly(this.configuration, this.needChannelNumber, channelsPerTaskGroup);
        LOG.info("Scheduler starts [{}] taskGroups.", (Object)taskGroupConfigs.size());
        ExecuteMode executeMode = null;
        try {
            executeMode = ExecuteMode.STANDALONE;
            AbstractScheduler scheduler = this.initStandaloneScheduler(this.configuration);
            for (Configuration taskGroupConfig : taskGroupConfigs) {
                taskGroupConfig.set("core.container.job.mode", executeMode.getValue());
            }
            if ((executeMode == ExecuteMode.LOCAL || executeMode == ExecuteMode.DISTRIBUTE) && this.jobId <= 0L) {
                throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, "\u5728[ local | distribute ]\u6a21\u5f0f\u4e0b\u5fc5\u987b\u8bbe\u7f6ejobId\uff0c\u5e76\u4e14\u5176\u503c > 0 .");
            }
            LOG.info("Running by {} Mode.", (Object)executeMode);
            this.startTransferTimeStamp = System.currentTimeMillis();
            scheduler.schedule(taskGroupConfigs);
            this.endTransferTimeStamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            LOG.error("\u8fd0\u884cscheduler \u6a21\u5f0f[{}]\u51fa\u9519.", (Object)executeMode);
            this.endTransferTimeStamp = System.currentTimeMillis();
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, e);
        }
        this.checkLimit();
    }

    private AbstractScheduler initStandaloneScheduler(Configuration configuration) {
        StandAloneJobContainerCommunicator containerCommunicator = new StandAloneJobContainerCommunicator(configuration);
        super.setContainerCommunicator(containerCommunicator);
        return new StandAloneScheduler(containerCommunicator);
    }

    private void post() {
        this.postJobWriter();
        this.postJobReader();
    }

    private void destroy() {
        if (this.jobWriter != null) {
            this.jobWriter.destroy();
            this.jobWriter = null;
        }
        if (this.jobReader != null) {
            this.jobReader.destroy();
            this.jobReader = null;
        }
    }

    private void logStatistics() {
        long totalCosts = (this.endTimeStamp - this.startTimeStamp) / 1000L;
        long transferCosts = (this.endTransferTimeStamp - this.startTransferTimeStamp) / 1000L;
        if (0L == transferCosts) {
            transferCosts = 1L;
        }
        if (super.getContainerCommunicator() == null) {
            return;
        }
        Communication communication = super.getContainerCommunicator().collect();
        communication.setTimestamp(this.endTimeStamp);
        Communication tempComm = new Communication();
        tempComm.setTimestamp(this.startTransferTimeStamp);
        Communication reportCommunication = CommunicationTool.getReportCommunication(communication, tempComm, this.totalStage);
        long byteSpeedPerSecond = communication.getLongCounter("readSucceedBytes") / transferCosts;
        long recordSpeedPerSecond = communication.getLongCounter("readSucceedRecords") / transferCosts;
        reportCommunication.setLongCounter("byteSpeed", byteSpeedPerSecond);
        reportCommunication.setLongCounter("recordSpeed", recordSpeedPerSecond);
        super.getContainerCommunicator().report(reportCommunication);
        LOG.info(String.format("\n%-26s: %-18s\n%-26s: %-18s\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n", "\u4efb\u52a1\u542f\u52a8\u65f6\u523b", dateFormat.format(this.startTimeStamp), "\u4efb\u52a1\u7ed3\u675f\u65f6\u523b", dateFormat.format(this.endTimeStamp), "\u4efb\u52a1\u603b\u8ba1\u8017\u65f6", String.valueOf(totalCosts) + "s", "\u4efb\u52a1\u5e73\u5747\u6d41\u91cf", StrUtil.stringify(byteSpeedPerSecond) + "/s", "\u8bb0\u5f55\u5199\u5165\u901f\u5ea6", String.valueOf(recordSpeedPerSecond) + "rec/s", "\u8bfb\u51fa\u8bb0\u5f55\u603b\u6570", String.valueOf(CommunicationTool.getTotalReadRecords(communication)), "\u8bfb\u5199\u5931\u8d25\u603b\u6570", String.valueOf(CommunicationTool.getTotalErrorRecords(communication))));
        if (communication.getLongCounter("totalTransformerSuccessRecords") > 0L || communication.getLongCounter("totalTransformerFailedRecords") > 0L || communication.getLongCounter("totalTransformerFilterRecords") > 0L) {
            LOG.info(String.format("\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n", "Transformer\u6210\u529f\u8bb0\u5f55\u603b\u6570", communication.getLongCounter("totalTransformerSuccessRecords"), "Transformer\u5931\u8d25\u8bb0\u5f55\u603b\u6570", communication.getLongCounter("totalTransformerFailedRecords"), "Transformer\u8fc7\u6ee4\u8bb0\u5f55\u603b\u6570", communication.getLongCounter("totalTransformerFilterRecords")));
        }
    }

    private Reader.Job initJobReader(JobPluginCollector jobPluginCollector) {
        this.readerPluginName = this.configuration.getString("job.content[0].reader.name");
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.READER, this.readerPluginName));
        Reader.Job jobReader = (Reader.Job)LoadUtil.loadJobPlugin(PluginType.READER, this.readerPluginName);
        jobReader.setPluginJobConf(this.configuration.getConfiguration("job.content[0].reader.parameter"));
        jobReader.setPeerPluginJobConf(this.configuration.getConfiguration("job.content[0].writer.parameter"));
        jobReader.setJobPluginCollector(jobPluginCollector);
        jobReader.init();
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
        return jobReader;
    }

    private Writer.Job initJobWriter(JobPluginCollector jobPluginCollector) {
        this.writerPluginName = this.configuration.getString("job.content[0].writer.name");
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.WRITER, this.writerPluginName));
        Writer.Job jobWriter = (Writer.Job)LoadUtil.loadJobPlugin(PluginType.WRITER, this.writerPluginName);
        jobWriter.setPluginJobConf(this.configuration.getConfiguration("job.content[0].writer.parameter"));
        jobWriter.setPeerPluginJobConf(this.configuration.getConfiguration("job.content[0].reader.parameter"));
        jobWriter.setPeerPluginName(this.readerPluginName);
        jobWriter.setJobPluginCollector(jobPluginCollector);
        jobWriter.init();
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
        return jobWriter;
    }

    private void prepareJobReader() {
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.READER, this.readerPluginName));
        LOG.info(String.format("DataX Reader.Job [%s] do prepare work .", this.readerPluginName));
        this.jobReader.prepare();
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
    }

    private void prepareJobWriter() {
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.WRITER, this.writerPluginName));
        LOG.info(String.format("DataX Writer.Job [%s] do prepare work .", this.writerPluginName));
        this.jobWriter.prepare();
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
    }

    private List<Configuration> doReaderSplit(int adviceNumber) {
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.READER, this.readerPluginName));
        List<Configuration> readerSlicesConfigs = this.jobReader.split(adviceNumber);
        if (readerSlicesConfigs == null || readerSlicesConfigs.size() <= 0) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.PLUGIN_SPLIT_ERROR, "reader\u5207\u5206\u7684task\u6570\u76ee\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        LOG.info("DataX Reader.Job [{}] splits to [{}] tasks.", (Object)this.readerPluginName, (Object)readerSlicesConfigs.size());
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
        return readerSlicesConfigs;
    }

    private List<Configuration> doWriterSplit(int readerTaskNumber) {
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.WRITER, this.writerPluginName));
        List<Configuration> writerSlicesConfigs = this.jobWriter.split(readerTaskNumber);
        if (writerSlicesConfigs == null || writerSlicesConfigs.size() <= 0) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.PLUGIN_SPLIT_ERROR, "writer\u5207\u5206\u7684task\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        LOG.info("DataX Writer.Job [{}] splits to [{}] tasks.", (Object)this.writerPluginName, (Object)writerSlicesConfigs.size());
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
        return writerSlicesConfigs;
    }

    private List<Configuration> mergeReaderAndWriterTaskConfigs(List<Configuration> readerTasksConfigs, List<Configuration> writerTasksConfigs) {
        return this.mergeReaderAndWriterTaskConfigs(readerTasksConfigs, writerTasksConfigs, null);
    }

    private List<Configuration> mergeReaderAndWriterTaskConfigs(List<Configuration> readerTasksConfigs, List<Configuration> writerTasksConfigs, List<Configuration> transformerConfigs) {
        if (readerTasksConfigs.size() != writerTasksConfigs.size()) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.PLUGIN_SPLIT_ERROR, String.format("reader\u5207\u5206\u7684task\u6570\u76ee[%d]\u4e0d\u7b49\u4e8ewriter\u5207\u5206\u7684task\u6570\u76ee[%d].", readerTasksConfigs.size(), writerTasksConfigs.size()));
        }
        ArrayList<Configuration> contentConfigs = new ArrayList<Configuration>();
        for (int i = 0; i < readerTasksConfigs.size(); ++i) {
            Configuration taskConfig = Configuration.newDefault();
            taskConfig.set("reader.name", this.readerPluginName);
            taskConfig.set("reader.parameter", readerTasksConfigs.get(i));
            taskConfig.set("writer.name", this.writerPluginName);
            taskConfig.set("writer.parameter", writerTasksConfigs.get(i));
            if (transformerConfigs != null && transformerConfigs.size() > 0) {
                taskConfig.set("transformer", transformerConfigs);
            }
            taskConfig.set("taskId", i);
            contentConfigs.add(taskConfig);
        }
        return contentConfigs;
    }

    private List<Configuration> distributeTasksToTaskGroup(int averTaskPerChannel, int channelNumber, int channelsPerTaskGroup) {
        List<Configuration> taskGroupJobContent;
        Validate.isTrue((averTaskPerChannel > 0 && channelNumber > 0 && channelsPerTaskGroup > 0 ? 1 : 0) != 0, (String)"\u6bcf\u4e2achannel\u7684\u5e73\u5747task\u6570[averTaskPerChannel]\uff0cchannel\u6570\u76ee[channelNumber]\uff0c\u6bcf\u4e2ataskGroup\u7684\u5e73\u5747channel\u6570[channelsPerTaskGroup]\u90fd\u5e94\u8be5\u4e3a\u6b63\u6570");
        List<Configuration> taskConfigs = this.configuration.getListConfiguration("job.content");
        int taskGroupNumber = channelNumber / channelsPerTaskGroup;
        int leftChannelNumber = channelNumber % channelsPerTaskGroup;
        if (leftChannelNumber > 0) {
            ++taskGroupNumber;
        }
        if (taskGroupNumber == 1) {
            final Configuration taskGroupConfig = this.configuration.clone();
            taskGroupConfig.set("job.content", this.configuration.getListConfiguration("job.content"));
            taskGroupConfig.set("core.container.taskGroup.channel", channelNumber);
            taskGroupConfig.set("core.container.taskGroup.id", 0);
            return new ArrayList<Configuration>(){
                {
                    this.add(taskGroupConfig);
                }
            };
        }
        ArrayList<Configuration> taskGroupConfigs = new ArrayList<Configuration>();
        for (int i = 0; i < taskGroupNumber; ++i) {
            Configuration taskGroupConfig = this.configuration.clone();
            List<Configuration> taskGroupJobContent2 = taskGroupConfig.getListConfiguration("job.content");
            taskGroupJobContent2.clear();
            taskGroupConfig.set("job.content", taskGroupJobContent2);
            taskGroupConfigs.add(taskGroupConfig);
        }
        int taskConfigIndex = 0;
        int taskGroupConfigIndex = 0;
        if (leftChannelNumber > 0) {
            Configuration taskGroupConfig = (Configuration)taskGroupConfigs.get(taskGroupConfigIndex);
            for (int channelIndex = 0; channelIndex < leftChannelNumber; ++channelIndex) {
                for (int i = 0; i < averTaskPerChannel; ++i) {
                    taskGroupJobContent = taskGroupConfig.getListConfiguration("job.content");
                    taskGroupJobContent.add(taskConfigs.get(taskConfigIndex++));
                    taskGroupConfig.set("job.content", taskGroupJobContent);
                }
            }
            taskGroupConfig.set("core.container.taskGroup.channel", leftChannelNumber);
            taskGroupConfig.set("core.container.taskGroup.id", taskGroupConfigIndex++);
        }
        int equalDivisionStartIndex = taskGroupConfigIndex;
        while (taskConfigIndex < taskConfigs.size() && equalDivisionStartIndex < taskGroupConfigs.size()) {
            for (taskGroupConfigIndex = equalDivisionStartIndex; taskGroupConfigIndex < taskGroupConfigs.size() && taskConfigIndex < taskConfigs.size(); ++taskGroupConfigIndex) {
                Configuration taskGroupConfig = (Configuration)taskGroupConfigs.get(taskGroupConfigIndex);
                taskGroupJobContent = taskGroupConfig.getListConfiguration("job.content");
                taskGroupJobContent.add(taskConfigs.get(taskConfigIndex++));
                taskGroupConfig.set("job.content", taskGroupJobContent);
            }
        }
        taskGroupConfigIndex = equalDivisionStartIndex;
        while (taskGroupConfigIndex < taskGroupConfigs.size()) {
            Configuration taskGroupConfig = (Configuration)taskGroupConfigs.get(taskGroupConfigIndex);
            taskGroupConfig.set("core.container.taskGroup.channel", channelsPerTaskGroup);
            taskGroupConfig.set("core.container.taskGroup.id", taskGroupConfigIndex++);
        }
        return taskGroupConfigs;
    }

    private void postJobReader() {
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.READER, this.readerPluginName));
        LOG.info("DataX Reader.Job [{}] do post work.", (Object)this.readerPluginName);
        this.jobReader.post();
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
    }

    private void postJobWriter() {
        this.classLoaderSwapper.setCurrentThreadClassLoader(LoadUtil.getJarLoader(PluginType.WRITER, this.writerPluginName));
        LOG.info("DataX Writer.Job [{}] do post work.", (Object)this.writerPluginName);
        this.jobWriter.post();
        this.classLoaderSwapper.restoreCurrentThreadClassLoader();
    }

    private void checkLimit() {
        Communication communication = super.getContainerCommunicator().collect();
        this.errorLimit.checkRecordLimit(communication);
        this.errorLimit.checkPercentageLimit(communication);
    }

    private void invokeHooks() {
        Communication comm = super.getContainerCommunicator().collect();
        HookInvoker invoker = new HookInvoker(CoreConstant.DATAX_HOME + "/hook", this.configuration, comm.getCounter());
        invoker.invokeAll();
    }
}

