/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.datax.core.statistics.communication.CommunicationTool;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorRecordChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorRecordChecker.class);
    private Long recordLimit;
    private Double percentageLimit;

    public ErrorRecordChecker(Configuration configuration) {
        this(configuration.getLong("job.setting.errorLimit.record"), configuration.getDouble("job.setting.errorLimit.percentage"));
    }

    public ErrorRecordChecker(Long rec, Double percentage) {
        this.recordLimit = rec;
        this.percentageLimit = percentage;
        if (this.percentageLimit != null) {
            Validate.isTrue((0.0 <= this.percentageLimit && this.percentageLimit <= 1.0 ? 1 : 0) != 0, (String)"\u810f\u6570\u636e\u767e\u5206\u6bd4\u9650\u5236\u5e94\u8be5\u5728[0.0, 1.0]\u4e4b\u95f4", (Object[])new Object[0]);
        }
        if (this.recordLimit != null) {
            Validate.isTrue((this.recordLimit >= 0L ? 1 : 0) != 0, (String)"\u810f\u6570\u636e\u6761\u6570\u73b0\u5728\u5e94\u8be5\u4e3a\u975e\u8d1f\u6574\u6570", (Object[])new Object[0]);
            this.percentageLimit = null;
        }
    }

    public void checkRecordLimit(Communication communication) {
        if (this.recordLimit == null) {
            return;
        }
        long errorNumber = CommunicationTool.getTotalErrorRecords(communication);
        if (this.recordLimit < errorNumber) {
            LOG.debug(String.format("Error-limit set to %d, error count check.", this.recordLimit));
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.PLUGIN_DIRTY_DATA_LIMIT_EXCEED, String.format("\u810f\u6570\u636e\u6761\u6570\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u9650\u5236\u662f[%d]\u6761\uff0c\u4f46\u5b9e\u9645\u4e0a\u6355\u83b7\u4e86[%d]\u6761.", this.recordLimit, errorNumber));
        }
    }

    public void checkPercentageLimit(Communication communication) {
        if (this.percentageLimit == null) {
            return;
        }
        LOG.debug(String.format("Error-limit set to %f, error percent check.", this.percentageLimit));
        long total = CommunicationTool.getTotalReadRecords(communication);
        long error = CommunicationTool.getTotalErrorRecords(communication);
        if (total > 0L && (double)error / (double)total > this.percentageLimit) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.PLUGIN_DIRTY_DATA_LIMIT_EXCEED, String.format("\u810f\u6570\u636e\u767e\u5206\u6bd4\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u9650\u5236\u662f[%f]\uff0c\u4f46\u5b9e\u9645\u4e0a\u6355\u83b7\u5230[%f].", this.percentageLimit, (double)error / (double)total));
        }
    }
}

