/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.util;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.core.transport.transformer.TransformerExecution;
import com.alibaba.datax.core.transport.transformer.TransformerExecutionParas;
import com.alibaba.datax.core.transport.transformer.TransformerInfo;
import com.alibaba.datax.core.transport.transformer.TransformerRegistry;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TransformerUtil.class);

    public static List<TransformerExecution> buildTransformerInfo(Configuration taskConfig) {
        List<Configuration> tfConfigs = taskConfig.getListConfiguration("transformer");
        if (tfConfigs == null || tfConfigs.size() == 0) {
            return null;
        }
        ArrayList<TransformerExecution> result = new ArrayList<TransformerExecution>();
        ArrayList<String> functionNames = new ArrayList<String>();
        for (Configuration configuration : tfConfigs) {
            String functionName = configuration.getString("name");
            if (StringUtils.isEmpty((CharSequence)functionName)) {
                throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_CONFIGURATION_ERROR, "config=" + configuration.toJSON());
            }
            if (functionName.equals("dx_groovy") && functionNames.contains("dx_groovy")) {
                throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_CONFIGURATION_ERROR, "dx_groovy can be invoke once only.");
            }
            functionNames.add(functionName);
        }
        LOG.info(String.format(" user config tranformers [%s], loading...", functionNames));
        TransformerRegistry.loadTransformerFromLocalStorage(functionNames);
        int i = 0;
        for (Configuration configuration : tfConfigs) {
            String functionName = configuration.getString("name");
            TransformerInfo transformerInfo = TransformerRegistry.getTransformer(functionName);
            if (transformerInfo == null) {
                throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_NOTFOUND_ERROR, "name=" + functionName);
            }
            TransformerExecutionParas transformerExecutionParas = new TransformerExecutionParas();
            if (!functionName.equals("dx_groovy") && !functionName.equals("dx_fackGroovy")) {
                Integer columnIndex = configuration.getInt("parameter.columnIndex");
                if (columnIndex == null) {
                    throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "columnIndex must be set by UDF:name=" + functionName);
                }
                transformerExecutionParas.setColumnIndex(columnIndex);
                List<String> paras = configuration.getList("parameter.paras", String.class);
                if (paras != null && paras.size() > 0) {
                    transformerExecutionParas.setParas(paras.toArray(new String[0]));
                }
            } else {
                String code = configuration.getString("parameter.code");
                if (StringUtils.isEmpty((CharSequence)code)) {
                    throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "groovy code must be set by UDF:name=" + functionName);
                }
                transformerExecutionParas.setCode(code);
                List<String> extraPackage = configuration.getList("parameter.extraPackage", String.class);
                if (extraPackage != null && extraPackage.size() > 0) {
                    transformerExecutionParas.setExtraPackage(extraPackage);
                }
            }
            transformerExecutionParas.settContext(configuration.getMap("parameter.context"));
            TransformerExecution transformerExecution = new TransformerExecution(transformerInfo, transformerExecutionParas);
            transformerExecution.genFinalParas();
            result.add(transformerExecution);
            LOG.info(String.format(" %s of transformer init success. name=%s, isNative=%s parameter = %s", ++i, transformerInfo.getTransformer().getTransformerName(), transformerInfo.isNative(), configuration.getConfiguration("parameter")));
        }
        return result;
    }
}

