/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.transport.transformer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.transport.transformer.Transformer;
import com.alibaba.datax.transport.transformer.TransformerErrorCode;
import com.alibaba.datax.transport.transformer.maskingMethods.differentialPrivacy.EpsilonDifferentialPrivacyImpl;
import java.util.Arrays;

public class EDPTransformer
extends Transformer {
    private Object masker;
    String key;
    int columnIndex;

    public EDPTransformer() {
        this.setTransformerName("dx_edp");
        System.out.println("Using Epsilon Differential Privacy masker");
    }

    @Override
    public Record evaluate(Record record, Object ... paras) {
        try {
            if (paras.length < 2) {
                throw new RuntimeException("dx_edp transformer\u7f3a\u5c11\u53c2\u6570");
            }
            this.columnIndex = (Integer)paras[0];
            this.key = (String)paras[1];
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)TransformerErrorCode.TRANSFORMER_ILLEGAL_PARAMETER, "paras:" + Arrays.asList(paras).toString() + " => " + e.getMessage());
        }
        Column column = record.getColumn(this.columnIndex);
        try {
            String oriValue = column.asString();
            if (oriValue == null) {
                return record;
            }
            if (column.getType() == Column.Type.DOUBLE) {
                EpsilonDifferentialPrivacyImpl masker = new EpsilonDifferentialPrivacyImpl();
                double newValue = masker.maskOne(Double.parseDouble(oriValue), Double.parseDouble(this.key));
                record.setColumn(this.columnIndex, new DoubleColumn(newValue));
            } else if (column.getType() == Column.Type.LONG) {
                EpsilonDifferentialPrivacyImpl masker = new EpsilonDifferentialPrivacyImpl();
                long newValue = masker.maskOne(Long.valueOf(oriValue), Double.parseDouble(this.key));
                record.setColumn(this.columnIndex, new LongColumn(newValue));
            }
        }
        catch (Exception e) {
            throw DataXException.asDataXException(TransformerErrorCode.TRANSFORMER_RUN_EXCEPTION, e.getMessage(), e);
        }
        return record;
    }
}

