/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.compiler;

import java.io.IOException;
import java.io.InputStream;
import org.bdware.sc.compiler.PermissionStub;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class PermissionStubGenerator
extends ClassVisitor
implements Opcodes {
    private final String p;

    public PermissionStubGenerator(int api, ClassVisitor cn, String permission) {
        super(api, cn);
        this.p = permission;
    }

    public static byte[] generateStub(Class<?> clz, String permission) {
        PermissionStub stub = clz.getAnnotation(PermissionStub.class);
        if (stub == null) {
            return null;
        }
        try {
            String resource = clz.getCanonicalName().replaceAll("\\.", "/") + ".class";
            InputStream input = clz.getClassLoader().getResourceAsStream(resource);
            ClassReader cr = new ClassReader(input);
            ClassWriter cw = new ClassWriter(3);
            PermissionStubGenerator generator = new PermissionStubGenerator(262144, (ClassVisitor)cw, permission);
            cr.accept((ClassVisitor)generator, 0);
            return cw.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.cv != null) {
            this.cv.visit(version, access, name + "Stub", null, "java/lang/Object", null);
        }
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.cv != null) {
            if (name.equals("<clinit>")) {
                return null;
            }
            if (name.equals("<init>")) {
                return null;
            }
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, new String[]{"javax/script/ScriptException"});
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitTypeInsn(187, "javax/script/ScriptException");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)("Do not have " + this.p + " Permission"));
            mv.visitMethodInsn(183, "javax/script/ScriptException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
            mv.visitMaxs(5, 20);
            mv.visitEnd();
            return null;
        }
        return null;
    }
}

