/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.statistics.communication;

import com.alibaba.datax.core.statistics.communication.Communication;
import com.alibaba.datax.dataxservice.face.domain.enums.State;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;

public final class LocalTGCommunicationManager {
    private static Map<Integer, Communication> taskGroupCommunicationMap = new ConcurrentHashMap<Integer, Communication>();

    public static void registerTaskGroupCommunication(int taskGroupId, Communication communication) {
        taskGroupCommunicationMap.put(taskGroupId, communication);
    }

    public static Communication getJobCommunication() {
        Communication communication = new Communication();
        communication.setState(State.SUCCEEDED);
        for (Communication taskGroupCommunication : taskGroupCommunicationMap.values()) {
            communication.mergeFrom(taskGroupCommunication);
        }
        return communication;
    }

    public static Set<Integer> getTaskGroupIdSet() {
        return taskGroupCommunicationMap.keySet();
    }

    public static Communication getTaskGroupCommunication(int taskGroupId) {
        Validate.isTrue((taskGroupId >= 0 ? 1 : 0) != 0, (String)"taskGroupId\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        return taskGroupCommunicationMap.get(taskGroupId);
    }

    public static void updateTaskGroupCommunication(int taskGroupId, Communication communication) {
        Validate.isTrue((boolean)taskGroupCommunicationMap.containsKey(taskGroupId), (String)String.format("taskGroupCommunicationMap\u4e2d\u6ca1\u6709\u6ce8\u518ctaskGroupId[%d]\u7684Communication\uff0c\u65e0\u6cd5\u66f4\u65b0\u8be5taskGroup\u7684\u4fe1\u606f", taskGroupId), (Object[])new Object[0]);
        taskGroupCommunicationMap.put(taskGroupId, communication);
    }

    public static void clear() {
        taskGroupCommunicationMap.clear();
    }

    public static Map<Integer, Communication> getTaskGroupCommunicationMap() {
        return taskGroupCommunicationMap;
    }
}

