/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.core.transport.record;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.core.util.ClassSize;
import com.alibaba.datax.core.util.FrameworkErrorCode;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultRecord
implements Record {
    private static final int RECORD_AVERGAE_COLUMN_NUMBER = 16;
    private List<Column> columns;
    private int byteSize;
    private int memorySize = ClassSize.DefaultRecordHead;

    public DefaultRecord() {
        this.columns = new ArrayList<Column>(16);
    }

    @Override
    public void addColumn(Column column) {
        this.columns.add(column);
        this.incrByteSize(column);
    }

    @Override
    public Column getColumn(int i) {
        if (i < 0 || i >= this.columns.size()) {
            return null;
        }
        return this.columns.get(i);
    }

    @Override
    public void setColumn(int i, Column column) {
        if (i < 0) {
            throw DataXException.asDataXException((ErrorCode)FrameworkErrorCode.ARGUMENT_ERROR, "\u4e0d\u80fd\u7ed9index\u5c0f\u4e8e0\u7684column\u8bbe\u7f6e\u503c");
        }
        if (i >= this.columns.size()) {
            this.expandCapacity(i + 1);
        }
        this.decrByteSize(this.getColumn(i));
        this.columns.set(i, column);
        this.incrByteSize(this.getColumn(i));
    }

    @Override
    public String toString() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("size", this.getColumnNumber());
        json.put("data", this.columns);
        return JSON.toJSONString(json);
    }

    @Override
    public int getColumnNumber() {
        return this.columns.size();
    }

    @Override
    public int getByteSize() {
        return this.byteSize;
    }

    @Override
    public int getMemorySize() {
        return this.memorySize;
    }

    private void decrByteSize(Column column) {
        if (null == column) {
            return;
        }
        this.byteSize -= column.getByteSize();
        this.memorySize = this.memorySize - ClassSize.ColumnHead - column.getByteSize();
    }

    private void incrByteSize(Column column) {
        if (null == column) {
            return;
        }
        this.byteSize += column.getByteSize();
        this.memorySize = this.memorySize + ClassSize.ColumnHead + column.getByteSize();
    }

    private void expandCapacity(int totalSize) {
        if (totalSize <= 0) {
            return;
        }
        int needToExpand = totalSize - this.columns.size();
        while (needToExpand-- > 0) {
            this.columns.add(null);
        }
    }
}

