/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.crdt;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.bdware.crdt.counter.GCounter;
import org.bdware.sc.crdt.SharableVarManager;
import org.bdware.sc.util.JsonUtil;

public class SharableVar {
    public static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    }, 5L, TimeUnit.MILLISECONDS, 2);
    private final String varId;
    private long interval;
    private final String myId;
    GCounter counter;
    int offset;
    List<String> sendTo;
    private SyncTimeout nextTimeOut;

    public SharableVar(String cpId, String identifier, final SharableVarManager.VarResolveResult resolveResult) {
        this.counter = new GCounter(cpId, identifier);
        this.myId = cpId;
        this.varId = identifier;
        HASHED_WHEEL_TIMER.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                SharableVar.this.initByVarResolve(resolveResult);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public void join(String content) {
        GCounter toJoin = (GCounter)JsonUtil.fromJson((String)content, GCounter.class);
        this.counter.join((Object)toJoin);
    }

    private void syncVar() {
        String content = JsonUtil.toJson((Object)this.counter);
        SharableVarManager.instance.broadcastSyncMessage(this.varId, this.sendTo, content);
    }

    private void initByVarResolve(SharableVarManager.VarResolveResult resolveResult) {
        int i;
        this.sendTo = new ArrayList<String>();
        this.offset = -1;
        for (i = 0; i < resolveResult.writer.length; ++i) {
            if (!this.myId.equals(resolveResult.writer[i])) continue;
            this.offset = i;
        }
        if (this.offset == -1) {
            for (i = 0; i < resolveResult.reader.length; ++i) {
                if (!this.myId.equals(resolveResult.reader[i])) continue;
                this.offset = resolveResult.writer.length + i;
            }
        }
        for (i = 0; i < resolveResult.sendTo[this.offset].length; ++i) {
            int pos = resolveResult.sendTo[this.offset][i];
            this.sendTo.add(this.findByOffset(pos, resolveResult));
        }
        this.interval = resolveResult.interval[this.offset];
        this.nextTimeOut = new SyncTimeout();
        HASHED_WHEEL_TIMER.newTimeout((TimerTask)this.nextTimeOut, this.interval, TimeUnit.MILLISECONDS);
    }

    private String findByOffset(int pos, SharableVarManager.VarResolveResult resolveResult) {
        if (pos < resolveResult.writer.length) {
            return resolveResult.writer[pos];
        }
        return resolveResult.reader[pos - resolveResult.writer.length];
    }

    public GCounter get() {
        return this.counter;
    }

    class SyncTimeout
    implements TimerTask {
        SyncTimeout() {
        }

        public void run(Timeout timeout) throws Exception {
            try {
                SharableVar.this.syncVar();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                HASHED_WHEEL_TIMER.newTimeout((TimerTask)SharableVar.this.nextTimeOut, SharableVar.this.interval, TimeUnit.MILLISECONDS);
            }
        }
    }
}

