/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.handler;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractProcess;
import org.bdware.sc.bean.Contract;
import org.bdware.sc.conn.Description;
import org.bdware.sc.conn.MsgHandler;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.conn.ServiceServer;
import org.bdware.sc.get.GetMessage;
import org.bdware.sc.util.JsonUtil;

public class ContractHandler
extends MsgHandler
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(ContractHandler.class);
    ContractProcess cs;
    String identifier = "null";

    public ContractHandler(ContractProcess cs) {
        this.cs = cs;
    }

    @Override
    public void run() {
        System.out.println("ContractHandler: exit in 2 seconds!");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    @Description(value="start sync mech")
    public void startSync(GetMessage msg, ResultCallback cb) {
        this.cs.startSync();
        cb.onResult("success");
    }

    @Description(value="stop sync mech")
    public void stopSync(GetMessage msg, ResultCallback cb) {
        this.cs.stopSync();
        cb.onResult("success");
    }

    @Description(value="set ContractRecord file name")
    public void setCRFile(GetMessage msg, ResultCallback cb) {
        this.cs.setCRFile(msg.arg);
        cb.onResult("success");
    }

    @Description(value="set contractDir")
    public void setDir(GetMessage msg, ResultCallback cb) {
        System.out.println("ContractHandler setDir");
        this.cs.setDir(msg.arg);
        cb.onResult("success");
    }

    @Description(value="getDebug")
    public void getDebug(GetMessage msg, ResultCallback cb) {
        LOGGER.debug("getDebug");
        cb.onResult(JsonUtil.toJson((Object)this.cs.isDebug()));
    }

    @Description(value="clearSyncFiles")
    public void clearSyncFiles(GetMessage msg, ResultCallback cb) {
        this.cs.clearSyncFiles(msg.arg);
        cb.onResult("success");
    }

    @Description(value="changeDumpPeriod")
    public void changeDumpPeriod(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.changeDumpPeriod(msg.arg));
    }

    @Description(value="getDumpPeriod")
    public void getDumpPeriod(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getDumpPeriod());
    }

    @Description(value="getCachedTransRecords")
    public void getCachedTransRecords(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getCachedTransRecords(msg.arg));
    }

    @Description(value="start auto dump")
    public void startAutoDump(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.startAutoDump());
    }

    @Description(value="register manager port")
    public void registerMangerPort(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.registerMangerPort(msg.arg));
    }

    @Description(value="set current ContractBundle")
    public void setContractBundle(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.setContractBundle((Contract)JsonUtil.fromJson((String)msg.arg, Contract.class)));
    }

    @Description(value="set members")
    public void setMembers(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.setMembers((List)JsonUtil.fromJson((String)msg.arg, (Type)new TypeToken<List<String>>(){}.getType())));
    }

    @Description(value="get current contract name")
    public void getContractName(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getContractName());
    }

    @Description(value="set current Contract")
    public void setContract(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.setContract((Contract)JsonUtil.fromJson((String)msg.arg, Contract.class)));
    }

    @Description(value="execute contract", isAsync=true)
    public void executeContract(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.executeContract(msg.arg));
    }

    @Description(value="invoke function without limit")
    public void invokeFunctionWithoutLimit(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.executeFunctionWithoutLimit(msg.arg));
    }

    @Description(value="set DesktopPermission")
    public void setDesktopPermission(GetMessage msg, ResultCallback cb) {
        String result = this.cs.setDesktopPermission(msg.arg);
        cb.onResult(result);
    }

    @Description(value="change debug Flag")
    public void changeDebugFlag(GetMessage msg, ResultCallback cb) {
        String result = this.cs.changeDebugFlag(Boolean.valueOf(msg.arg));
        cb.onResult(result);
    }

    @Description(value="get functionEvaluates")
    public void functionEvaluates(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.evaluatesAnalysis(msg.arg));
    }

    @Description(value="get memory set")
    public void getMemorySet(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getMemorySet());
    }

    @Description(value="get logType")
    public void getLogType(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getLogType(msg.arg));
    }

    @Description(value="exit Contract!")
    public void suicide(GetMessage msg, ResultCallback cb) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("status", "success");
        this.cs.beforeSuicide();
        if (this.cs.checkSub()) {
            ret.put("cleanSub", true);
        }
        ServiceServer.executor.execute(this);
        cb.onResult(JsonUtil.toJson(ret));
    }

    @Description(value="check alive")
    public void ping(GetMessage msg, ResultCallback cb) {
        cb.onResult("pong");
    }

    @Description(value="dump contract process memory")
    public void getMemoryDump(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getMemoryDump(msg.arg));
    }

    @Description(value="get memory usage")
    public void getStorage(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getStorage());
    }

    @Description(value="redo by local trans record")
    public void redo(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.redo(msg.arg));
    }

    @Description(value="load dumped memory")
    public void loadMemory(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.loadMemoryDump(msg.arg));
    }

    @Description(value="setDBInfo, the db is used to store local logs")
    public void setDBInfo(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.setDBInfo(msg.arg));
    }

    @Description(value="getUsedMemory")
    public void getUsedMemory(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getUsedMemory("") + "");
    }

    @Description(value="showPermission")
    public void showPermission(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.showPermission());
    }

    @Description(value="is signature required?")
    public void isSigRequired(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.isSigRequired() + "");
    }

    @Description(value="Get Declared Events")
    public void getDeclaredEvents(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getDeclaredEvents());
    }

    @Description(value="Get Contract Annotations")
    public void getAnnotations(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getAnnotations());
    }

    @Description(value="Get Exported Functions")
    public void getExportedFunctions(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getExportedFunctions());
    }

    @Description(value="Whether current process is contract process, always cmi")
    public void isContractProcess(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.cmi);
    }

    @Description(value="get contract")
    public void getContract(GetMessage msg, ResultCallback cb) {
        cb.onResult(JsonUtil.toJson((Object)this.cs.getContract()));
    }

    @Description(value="setPID")
    public void setPID(GetMessage msg, ResultCallback cb) {
        this.cs.setPID(msg.arg);
        cb.onResult("success");
    }

    @Description(value="setProjectConfig")
    public void setProjectConfig(GetMessage msg, ResultCallback cb) {
        LOGGER.debug("ContractHandler: " + msg.arg);
        this.cs.setProjectConfig(msg.arg);
        cb.onResult("success");
    }

    @Description(value="getPID")
    public void getPID(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getPID());
    }

    @Description(value="requestLogSize")
    public void getLogSize(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.logSize() + "");
    }

    @Description(value="request Log")
    public void requestLog(GetMessage msg, ResultCallback cb) {
        String[] data = msg.arg.split(",");
        cb.onResult(this.cs.requestLog(Long.parseLong(data[0]), Integer.parseInt(data[1])));
    }

    @Description(value="request LastLog")
    public void requestLastLog(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.requestLast(Integer.parseInt(msg.arg)));
    }

    @Description(value="setIdentifier")
    public void setIdentifier(GetMessage msg, ResultCallback cb) {
        this.identifier = msg.arg;
        cb.onResult("success");
    }

    @Description(value="getIdentifier")
    public void getIdentifier(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.identifier);
    }

    @Description(value="getControlFlow")
    public void getControlFlow(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getControlFlow((Contract)JsonUtil.fromJson((String)msg.arg, Contract.class)));
    }

    @Description(value="getStateful")
    public void getStateful(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getStateful());
    }

    @Description(value="parseYpkPermissions")
    public void parseYpkPermissions(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.parseYpkPermissions(msg.arg));
    }

    @Description(value="staticVerify")
    public void staticVerify(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.staticVerify((Contract)JsonUtil.fromJson((String)msg.arg, Contract.class)));
    }

    @Description(value="getDependentContracts")
    public void getDependentContracts(GetMessage msg, ResultCallback cb) {
        cb.onResult(this.cs.getDependentContracts());
    }
}

